/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xpath.XPathException;

public class DeepEqual
extends CollatingFunction {
    private transient Configuration config = null;

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        this.config = staticContext.getConfiguration();
        return super.preEvaluate(staticContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicComparer atomicComparer = this.getAtomicComparer(2, xPathContext);
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        SequenceIterator sequenceIterator2 = this.argument[1].iterate(xPathContext);
        Configuration configuration = this.config != null ? this.config : xPathContext.getController().getConfiguration();
        return BooleanValue.get(DeepEqual.deepEquals(sequenceIterator, sequenceIterator2, atomicComparer, configuration));
    }

    public static boolean deepEquals(SequenceIterator sequenceIterator, SequenceIterator sequenceIterator2, AtomicComparer atomicComparer, Configuration configuration) {
        boolean bl;
        block9: {
            bl = true;
            try {
                while (true) {
                    Item item = sequenceIterator.next();
                    Item item2 = sequenceIterator2.next();
                    if (item == null && item2 == null) break block9;
                    if (item == null || item2 == null) {
                        bl = false;
                        break block9;
                    }
                    if (item instanceof NodeInfo) {
                        if (item2 instanceof NodeInfo) {
                            if (DeepEqual.deepEquals((NodeInfo)item, (NodeInfo)item2, atomicComparer, configuration)) continue;
                            bl = false;
                        } else {
                            bl = false;
                        }
                        break block9;
                    }
                    if (item2 instanceof NodeInfo) {
                        bl = false;
                        break block9;
                    }
                    if (!atomicComparer.comparesEqual(item, item2)) break;
                }
                bl = false;
            }
            catch (ClassCastException classCastException) {
                bl = false;
            }
            catch (XPathException xPathException) {
                bl = false;
            }
        }
        return bl;
    }

    private static boolean deepEquals(NodeInfo nodeInfo, NodeInfo nodeInfo2, AtomicComparer atomicComparer, Configuration configuration) throws XPathException {
        if (nodeInfo.isSameNodeInfo(nodeInfo2)) {
            return true;
        }
        if (nodeInfo.getNodeKind() != nodeInfo2.getNodeKind()) {
            return false;
        }
        switch (nodeInfo.getNodeKind()) {
            case 1: {
                NodeInfo nodeInfo3;
                AxisIterator axisIterator;
                Object object;
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    return false;
                }
                AxisIterator axisIterator2 = nodeInfo.iterateAxis((byte)2);
                AxisIterator axisIterator3 = nodeInfo2.iterateAxis((byte)2);
                if (Aggregate.count(axisIterator2.getAnother()) != Aggregate.count(axisIterator3)) {
                    return false;
                }
                while ((object = (NodeInfo)axisIterator2.next()) != null) {
                    axisIterator = nodeInfo2.iterateAxis((byte)2, new NameTest(2, object.getFingerprint(), configuration.getNamePool()));
                    nodeInfo3 = (NodeInfo)axisIterator.next();
                    if (nodeInfo3 == null) {
                        return false;
                    }
                    if (DeepEqual.deepEquals((NodeInfo)object, nodeInfo3, atomicComparer, configuration)) continue;
                    return false;
                }
            }
            case 9: {
                NodeInfo nodeInfo4;
                NodeInfo nodeInfo3;
                Object object = nodeInfo.iterateAxis((byte)3);
                AxisIterator axisIterator = nodeInfo2.iterateAxis((byte)3);
                do {
                    nodeInfo3 = (NodeInfo)object.next();
                    while (nodeInfo3 != null && (nodeInfo3.getNodeKind() == 8 || nodeInfo3.getNodeKind() == 7)) {
                        nodeInfo3 = (NodeInfo)object.next();
                    }
                    nodeInfo4 = (NodeInfo)axisIterator.next();
                    while (nodeInfo4 != null && (nodeInfo4.getNodeKind() == 8 || nodeInfo4.getNodeKind() == 7)) {
                        nodeInfo4 = (NodeInfo)axisIterator.next();
                    }
                    if (nodeInfo3 != null && nodeInfo4 != null) continue;
                    return nodeInfo3 == nodeInfo4;
                } while (DeepEqual.deepEquals(nodeInfo3, nodeInfo4, atomicComparer, configuration));
                return false;
            }
            case 2: {
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    return false;
                }
                return DeepEqual.deepEquals(nodeInfo.getTypedValue(configuration), nodeInfo2.getTypedValue(configuration), atomicComparer, configuration);
            }
            case 7: 
            case 13: {
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    return false;
                }
            }
            case 3: 
            case 8: {
                return atomicComparer.comparesEqual(nodeInfo.getStringValue(), nodeInfo2.getStringValue());
            }
        }
        throw new IllegalArgumentException("Unknown node type");
    }
}

