/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.AppendExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.EagerLetExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Attribute;
import net.sf.saxon.instruct.Comment;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Element;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.ProcessingInstruction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TraceExpression;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.TupleExpression;
import net.sf.saxon.sort.TupleSorter;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class QueryParser
extends ExpressionParser {
    private boolean preserveSpace = false;
    private boolean defaultEmptyLeast = true;
    private int errorCount = 0;
    protected Executable executable;
    private boolean haveSeenBaseURI = false;

    public XQueryExpression makeXQueryExpression(String string, StaticQueryContext staticQueryContext, Configuration configuration) throws XPathException {
        DocumentInstr documentInstr;
        Executable executable = new Executable();
        executable.setLocationMap(new LocationMap());
        executable.setConfiguration(configuration);
        executable.setFunctionLibrary(new ExecutableFunctionLibrary(configuration));
        this.setExecutable(executable);
        staticQueryContext.setExecutable(executable);
        Expression expression = this.parseQuery(string, 0, 0, staticQueryContext);
        XQueryExpression xQueryExpression = new XQueryExpression(expression, executable, staticQueryContext, configuration);
        expression = xQueryExpression.getExpression();
        if (expression instanceof DocumentInstr) {
            documentInstr = (DocumentInstr)expression;
        } else {
            documentInstr = new DocumentInstr(false, null, staticQueryContext.getSystemId());
            this.makeContentConstructor(expression, documentInstr, 1);
        }
        xQueryExpression.setDocumentInstruction(documentInstr);
        FunctionLibrary functionLibrary = this.executable.getFunctionLibrary();
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(configuration, false));
        functionLibraryList.addFunctionLibrary(configuration.getVendorFunctionLibrary());
        functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(configuration));
        if (configuration.isAllowExternalFunctions()) {
            functionLibraryList.addFunctionLibrary(new JavaExtensionLibrary(configuration));
        }
        functionLibraryList.addFunctionLibrary(functionLibrary);
        this.executable.setFunctionLibrary(functionLibraryList);
        return xQueryExpression;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public final Expression parseQuery(String string, int n, int n2, StaticQueryContext staticQueryContext) throws XPathException {
        this.env = staticQueryContext;
        this.t = new Tokenizer();
        this.t.recognizePragmas = true;
        try {
            this.t.tokenize(string, n, -1, 1);
        }
        catch (StaticError staticError) {
            this.grumble(staticError.getMessage());
        }
        this.parseVersionDeclaration();
        this.parseProlog();
        Expression expression = this.parseExpression();
        if (this.t.currentToken != n2) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of query");
        }
        if (this.errorCount == 0) {
            try {
                this.setLocation(expression);
                staticQueryContext.bindUnboundFunctionCalls();
                staticQueryContext.fixupGlobalVariables(staticQueryContext.getGlobalStackFrameMap());
                staticQueryContext.fixupGlobalFunctions();
            }
            catch (XPathException xPathException) {
                try {
                    staticQueryContext.getConfiguration().getErrorListener().fatalError(xPathException);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof XPathException) {
                        throw (XPathException)transformerException;
                    }
                    throw new StaticError(transformerException);
                }
            }
        }
        if (this.errorCount == 0) {
            return expression;
        }
        throw new StaticError("Query Parsing failed");
    }

    public final void parseLibraryModule(String string, StaticQueryContext staticQueryContext) throws StaticError {
        this.env = staticQueryContext;
        this.executable = staticQueryContext.getExecutable();
        this.t = new Tokenizer();
        try {
            this.t.tokenize(string, 0, -1, 1);
        }
        catch (StaticError staticError) {
            this.grumble(staticError.getMessage());
        }
        this.parseVersionDeclaration();
        this.parseModuleDeclaration();
        this.parseProlog();
        if (this.errorCount == 0) {
            staticQueryContext.bindUnboundFunctionCalls();
            staticQueryContext.fixupGlobalVariables(staticQueryContext.getExecutable().getGlobalVariableMap());
            staticQueryContext.fixupGlobalFunctions();
        }
        if (this.errorCount != 0) {
            throw new StaticError("Query parsing failed");
        }
    }

    protected void grumble(String string) throws StaticError {
        ++this.errorCount;
        String string2 = this.t.recentText();
        int n = this.t.getLineNumber();
        String string3 = "on line " + n + ' ';
        String string4 = this.env.getSystemId();
        string3 = string3 + (string4 == null ? "" : "of " + string4 + ' ');
        String string5 = this.getLanguage() + " syntax error " + string3 + (string.startsWith("...") ? "near" : "in") + " `" + string2 + "`:\n    ";
        StaticError staticError = new StaticError(string5 + string);
        try {
            this.env.getConfiguration().getErrorListener().error(staticError);
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof StaticError) {
                throw (StaticError)transformerException;
            }
            throw new StaticError(transformerException);
        }
        throw new StaticError("XQuery syntax error");
    }

    private void parseVersionDeclaration() throws StaticError {
        if (this.t.currentToken == 70) {
            this.nextToken();
            this.expect(102);
            if (!"1.0".equals(this.t.currentTokenValue)) {
                this.grumble("XQuery version must be 1.0");
            }
            this.nextToken();
            this.expect(90);
            this.nextToken();
        }
    }

    private void parseModuleDeclaration() throws StaticError {
        this.expect(80);
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String string2 = this.t.currentTokenValue;
        this.nextToken();
        this.expect(90);
        this.nextToken();
        ((StaticQueryContext)this.env).declarePassiveNamespace(string, string2);
        ((StaticQueryContext)this.env).setModuleNamespace(string2);
    }

    /*
     * Unable to fully structure code
     */
    private void parseProlog() throws StaticError {
        var1_1 = true;
        var2_2 = true;
        block2: while (true) {
            try {
                while (true) {
                    if (this.t.currentToken == 80) {
                        var3_3 = ((StaticQueryContext)this.env).getModuleNamespace();
                        if (var3_3 == null) {
                            this.grumble("Module declaration should not be used in a main module");
                        } else {
                            this.grumble("Module declaration appears more than once");
                        }
                        if (!var2_2) {
                            this.grumble("Module declaration must precede other declarations in the query prolog");
                        }
                    }
                    var2_2 = false;
                    if (this.t.currentToken == 71) {
                        var1_1 = false;
                        this.parseNamespaceDeclaration();
                    } else if (this.t.currentToken == 72) {
                        this.nextToken();
                        this.expect(101);
                        if (!var1_1) {
                            this.grumble("'declare default " + this.t.currentTokenValue + "' must appear earlier in the query prolog");
                        }
                        if (this.t.currentTokenValue == "element") {
                            this.parseDefaultElementNamespace();
                        } else if (this.t.currentTokenValue == "function") {
                            this.parseDefaultFunctionNamespace();
                        } else if (this.t.currentTokenValue == "collation") {
                            this.parseDefaultCollation();
                        } else if (this.t.currentTokenValue == "order") {
                            this.parseDefaultOrder();
                        } else {
                            this.grumble("After 'declare default', expected 'element', 'function', or 'collation'");
                        }
                    } else if (this.t.currentToken == 75) {
                        if (!var1_1) {
                            this.grumble("'declare xmlspace' must appear earlier in the query prolog");
                        }
                        this.parseXmlSpaceDeclaration();
                    } else if (this.t.currentToken == 84) {
                        if (!var1_1) {
                            this.grumble("'declare ordering' must appear earlier in the query prolog");
                        }
                        this.parseOrderingDeclaration();
                    } else if (this.t.currentToken == 74) {
                        if (!var1_1) {
                            this.grumble("'declare base-uri' must appear earlier in the query prolog");
                        }
                        this.parseBaseURIDeclaration();
                    } else if (this.t.currentToken == 76) {
                        var1_1 = false;
                        this.parseSchemaImport();
                    } else if (this.t.currentToken == 77) {
                        var1_1 = false;
                        this.parseModuleImport();
                    } else if (this.t.currentToken == 78) {
                        var1_1 = false;
                        this.parseVariableDeclaration();
                    } else if (this.t.currentToken == 79) {
                        var1_1 = false;
                        this.parseFunctionDeclaration();
                    } else {
                        if (this.t.currentToken != 73) break block2;
                        if (!var1_1) {
                            this.grumble("'declare construction' must appear earlier in the query prolog");
                        }
                        this.parseConstructionDeclaration();
                    }
                    this.expect(90);
                    this.nextToken();
                }
            }
            catch (StaticError var3_4) {
                ** while (this.t.currentToken != 90)
            }
lbl-1000:
            // 1 sources

            {
                this.nextToken();
                if (this.t.currentToken == 0) {
                    return;
                }
                if (this.t.currentToken == 115) {
                    this.t.lookAhead();
                    continue;
                }
                if (this.t.currentToken != 117) continue;
                this.parsePseudoXML(true);
                continue;
            }
lbl88:
            // 1 sources

            this.nextToken();
        }
    }

    private void parseDefaultCollation() throws StaticError {
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        try {
            ((StaticQueryContext)this.env).declareDefaultCollation(string);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        this.nextToken();
    }

    private void parseDefaultOrder() throws StaticError {
        this.nextToken();
        if (!this.isKeyword("empty")) {
            this.grumble("After 'declare default order', expected keyword 'empty'");
        }
        this.nextToken();
        if (this.isKeyword("least")) {
            this.defaultEmptyLeast = true;
        } else if (this.isKeyword("greatest")) {
            this.defaultEmptyLeast = false;
        } else {
            this.grumble("After 'declare default order empty', expected keyword 'least' or 'greatest'");
        }
        this.nextToken();
    }

    private void parseXmlSpaceDeclaration() throws StaticError {
        this.nextToken();
        this.expect(101);
        if ("preserve".equals(this.t.currentTokenValue)) {
            this.preserveSpace = true;
        } else if ("strip".equals(this.t.currentTokenValue)) {
            this.preserveSpace = false;
        } else {
            this.grumble("xmlspace must be 'preserve' or 'strip'");
        }
        this.nextToken();
    }

    private void parseOrderingDeclaration() throws StaticError {
        this.nextToken();
        this.expect(101);
        if (!"ordered".equals(this.t.currentTokenValue) && !"unordered".equals(this.t.currentTokenValue)) {
            this.grumble("ordering must be 'ordered' or 'unordered'");
        }
        this.nextToken();
    }

    private void parseConstructionDeclaration() throws StaticError {
        int n;
        this.nextToken();
        this.expect(101);
        if ("preserve".equals(this.t.currentTokenValue)) {
            n = 3;
        } else if ("strip".equals(this.t.currentTokenValue)) {
            n = 4;
        } else {
            this.grumble("construction mode must be 'preserve' or 'strip'");
            n = 4;
        }
        ((StaticQueryContext)this.env).setConstructionMode(n);
        this.nextToken();
    }

    private void parseSchemaImport() throws StaticError {
        Configuration configuration;
        if (!this.env.getConfiguration().isSchemaAware(11)) {
            this.grumble("To import a schema, you need the schema-aware version of Saxon");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        this.nextToken();
        if (this.isKeyword("namespace")) {
            this.nextToken();
            this.expect(101);
            string = this.t.currentTokenValue;
            this.nextToken();
            this.expect(6);
            this.nextToken();
        } else if (this.isKeyword("default")) {
            this.nextToken();
            if (!this.isKeyword("element")) {
                this.grumble("In 'import schema', expected 'element namespace'");
            }
            this.nextToken();
            if (!this.isKeyword("namespace")) {
                this.grumble("In 'import schema', expected keyword 'namespace'");
            }
            this.nextToken();
            string = "";
        }
        if (this.t.currentToken == 102) {
            string2 = this.t.currentTokenValue;
            this.nextToken();
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(102);
                string3 = this.t.currentTokenValue;
                this.nextToken();
            } else if (this.t.currentToken != 90) {
                this.grumble("After the target namespace URI, expected 'at' or ';'");
            }
        } else {
            this.grumble("After 'import schema', expected 'namespace', 'default', or a string-literal");
        }
        if (string != null) {
            if ("".equals(string)) {
                ((StaticQueryContext)this.env).setDefaultElementNamespace(string2);
            } else {
                ((StaticQueryContext)this.env).declarePassiveNamespace(string, string2);
            }
        }
        if ((configuration = this.env.getConfiguration()).getSchema(string2) == null) {
            if (string3 != null) {
                try {
                    string2 = configuration.readSchema(this.env.getBaseURI(), string3, string2);
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    this.grumble("Error in schema. " + transformerConfigurationException.getMessage());
                }
            } else {
                this.grumble("Unable to locate requested schema");
            }
        }
        ((StaticQueryContext)this.env).addImportedSchema(string2);
    }

    private void parseModuleImport() throws StaticError {
        Object object;
        StaticQueryContext staticQueryContext;
        String string;
        StaticQueryContext staticQueryContext2 = (StaticQueryContext)this.env;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        this.nextToken();
        if (this.t.currentToken == 101 && this.t.currentTokenValue == "namespace") {
            this.nextToken();
            this.expect(101);
            string2 = this.t.currentTokenValue;
            this.nextToken();
            this.expect(6);
            this.nextToken();
        }
        if (this.t.currentToken == 102) {
            string3 = this.t.currentTokenValue;
            this.nextToken();
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(102);
                string4 = this.t.currentTokenValue;
                this.nextToken();
            }
        } else {
            this.grumble("After 'import module', expected 'namespace' or a string-literal");
        }
        if (string2 != null) {
            staticQueryContext2.declarePassiveNamespace(string2, string3);
        }
        if ((string = staticQueryContext2.getModuleNamespace()) != null && string.equals(string3)) {
            this.grumble("A module cannot import itself");
        }
        try {
            staticQueryContext = staticQueryContext2.loadModule(string3, string4);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
            return;
        }
        short s = staticQueryContext.getModuleNamespaceCode();
        NamePool namePool = this.env.getNamePool();
        Iterator iterator = staticQueryContext.getFunctionDefinitions();
        while (iterator.hasNext()) {
            object = (XQueryFunction)iterator.next();
            if (namePool.getURICode(((XQueryFunction)object).getFunctionFingerprint()) != s) continue;
            staticQueryContext2.declareFunction((XQueryFunction)object);
        }
        iterator = staticQueryContext.getVariableDeclarations();
        while (iterator.hasNext()) {
            object = (VariableDeclaration)iterator.next();
            if (namePool.getURICode(object.getNameCode()) != s) continue;
            staticQueryContext2.declareVariable((VariableDeclaration)object);
        }
    }

    private void parseBaseURIDeclaration() throws StaticError {
        if (this.haveSeenBaseURI) {
            this.grumble("Base URI Declaration may only appear once");
        }
        this.haveSeenBaseURI = true;
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setBaseURI(string);
        this.nextToken();
    }

    private void parseDefaultFunctionNamespace() throws StaticError {
        this.nextToken();
        this.expect(101);
        if (!"namespace".equals(this.t.currentTokenValue)) {
            this.grumble("After 'declare default function', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setDefaultFunctionNamespace(string);
        this.nextToken();
    }

    private void parseDefaultElementNamespace() throws StaticError {
        this.nextToken();
        this.expect(101);
        if (!"namespace".equals(this.t.currentTokenValue)) {
            this.grumble("After 'declare default element', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setDefaultElementNamespace(string);
        this.nextToken();
    }

    private void parseNamespaceDeclaration() throws StaticError {
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        if (!XMLChar.isValidNCName(string)) {
            this.grumble("Invalid namespace prefix " + Err.wrap(string));
        }
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String string2 = this.t.currentTokenValue;
        if ("".equals(string2)) {
            this.grumble("A namespace URI cannot be empty");
        }
        ((StaticQueryContext)this.env).declarePassiveNamespace(string, string2);
        this.nextToken();
    }

    private void parseVariableDeclaration() throws StaticError {
        Object object;
        Expression expression;
        int n = this.t.currentTokenStartOffset;
        GlobalVariableDefinition globalVariableDefinition = new GlobalVariableDefinition();
        globalVariableDefinition.setLineNumber(this.t.getLineNumber());
        this.nextToken();
        this.expect(21);
        this.t.setState(1);
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        globalVariableDefinition.setVariableName(string);
        int n2 = this.makeNameCode(this.t.currentTokenValue, false);
        int n3 = n2 & 0xFFFFF;
        globalVariableDefinition.setNameCode(n3);
        this.nextToken();
        SequenceType sequenceType = SequenceType.ANY_SEQUENCE;
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            sequenceType = this.parseSequenceType();
        }
        globalVariableDefinition.setRequiredType(sequenceType);
        if (this.t.currentToken == 53) {
            this.t.setState(0);
            this.nextToken();
            expression = this.parseExpression();
            globalVariableDefinition.setIsParameter(false);
            globalVariableDefinition.setValueExpression(this.makeTracer(n, expression, 185, n2));
            this.expect(115);
            this.lookAhead();
            this.nextToken();
        } else if (this.t.currentToken == 52) {
            this.t.setState(0);
            this.nextToken();
            expression = this.parseExpression();
            globalVariableDefinition.setIsParameter(false);
            globalVariableDefinition.setValueExpression(this.makeTracer(n, expression, 185, n2));
        } else if (this.t.currentToken == 101) {
            if ("external".equals(this.t.currentTokenValue)) {
                globalVariableDefinition.setIsParameter(true);
                this.nextToken();
            } else {
                this.grumble("Variable must either be initialized or be declared as external");
            }
        } else {
            this.grumble("Expected '{' or ':=' or 'external' in variable declaration");
        }
        expression = null;
        while (this.t.lastPragma != null) {
            try {
                String string2;
                block21: {
                    object = new StringTokenizer(this.t.lastPragma);
                    this.t.lastPragma = null;
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        string2 = ((StringTokenizer)object).nextToken();
                        String[] stringArray = Name.getQNameParts(string2);
                        if (!"default".equals(stringArray[1])) break;
                        try {
                            if (!this.env.getURIForPrefix(stringArray[0]).equals("http://saxon.sf.net/")) {
                            }
                            break block21;
                        }
                        catch (XPathException xPathException) {
                            this.grumble("Unrecognized namespace prefix in pragma name {" + string2 + '}');
                        }
                        break;
                    }
                }
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                string2 = ((StringTokenizer)object).nextToken();
                if (string2.charAt(0) == '\"' || string2.charAt(0) == '\'') {
                    expression = new StringValue(string2.substring(1, string2.length() - 1));
                    continue;
                }
                expression = NumericValue.parseNumber(string2);
                if (!((NumericValue)expression).isNaN()) continue;
                this.grumble("Default value of query parameter must be a string or numeric literal");
            }
            catch (QNameException qNameException) {
                // empty catch block
            }
        }
        if (expression != null) {
            globalVariableDefinition.setValueExpression(expression);
        }
        if (((StaticQueryContext)(object = (StaticQueryContext)this.env)).getModuleNamespace() != null && this.env.getNamePool().getURICode(n3) != ((StaticQueryContext)object).getModuleNamespaceCode()) {
            this.grumble("Variable " + Err.wrap(string, 5) + " is not defined in the module namespace");
        }
        try {
            ((StaticQueryContext)object).declareVariable(globalVariableDefinition);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    private void parseFunctionDeclaration() throws StaticError {
        int n = this.t.currentTokenStartOffset;
        this.nextToken();
        this.expect(34);
        if (this.t.currentTokenValue.indexOf(58) < 0) {
            this.grumble("Saxon requires user-defined functions to have a namespace prefix");
        }
        XQueryFunction xQueryFunction = new XQueryFunction();
        xQueryFunction.setNameCode(this.makeNameCode(this.t.currentTokenValue, false));
        xQueryFunction.arguments = new ArrayList(8);
        xQueryFunction.resultType = SequenceType.ANY_SEQUENCE;
        xQueryFunction.body = null;
        xQueryFunction.lineNumber = this.t.getLineNumber(n);
        xQueryFunction.columnNumber = this.t.getColumnNumber(n);
        xQueryFunction.systemId = this.env.getSystemId();
        xQueryFunction.setExecutable(this.getExecutable());
        this.nextToken();
        HashSet<Integer> hashSet = new HashSet<Integer>(8);
        while (this.t.currentToken != 104) {
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            int n2 = this.makeNameCode(string, false);
            int n3 = n2 & 0xFFFFF;
            Integer n4 = new Integer(n3);
            if (hashSet.contains(n4)) {
                this.grumble("Duplicate parameter name " + Err.wrap(this.t.currentTokenValue, 5));
            }
            hashSet.add(n4);
            SequenceType sequenceType = SequenceType.ANY_SEQUENCE;
            this.nextToken();
            if (this.t.currentToken == 101 && "as".equals(this.t.currentTokenValue)) {
                this.nextToken();
                sequenceType = this.parseSequenceType();
            }
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setNameCode(n2);
            rangeVariableDeclaration.setRequiredType(sequenceType);
            rangeVariableDeclaration.setVariableName(string);
            xQueryFunction.arguments.add(rangeVariableDeclaration);
            this.declareRangeVariable(rangeVariableDeclaration);
            if (this.t.currentToken == 104) break;
            if (this.t.currentToken == 7) {
                this.nextToken();
                continue;
            }
            this.grumble("Expected ',' or ')' after function argument, found '" + Token.tokens[this.t.currentToken] + '\'');
        }
        this.t.setState(1);
        this.nextToken();
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            xQueryFunction.resultType = this.parseSequenceType();
        }
        if (this.isKeyword("external")) {
            this.grumble("Saxon does not allow external functions to be declared");
        } else {
            this.expect(53);
            this.t.setState(0);
            this.nextToken();
            xQueryFunction.body = this.parseExpression();
            this.expect(115);
            this.lookAhead();
        }
        int n5 = 0;
        while (n5 < xQueryFunction.arguments.size()) {
            this.undeclareRangeVariable();
            ++n5;
        }
        this.t.setState(0);
        this.nextToken();
        StaticQueryContext staticQueryContext = (StaticQueryContext)this.env;
        if (staticQueryContext.getModuleNamespace() != null && this.env.getNamePool().getURICode(xQueryFunction.getFunctionFingerprint()) != staticQueryContext.getModuleNamespaceCode()) {
            this.grumble("Function " + Err.wrap(this.env.getNamePool().getDisplayName(xQueryFunction.getNameCode()), 3) + " is not defined in the module namespace");
        }
        try {
            staticQueryContext.declareFunction(xQueryFunction);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    protected Expression parseForExpression() throws StaticError {
        Object object;
        Object object2;
        int n = this.t.currentTokenStartOffset;
        Expression expression = null;
        int n2 = -1;
        ArrayList arrayList = new ArrayList(4);
        while (true) {
            if (this.t.currentToken == 111) {
                this.parseForClause(arrayList);
                continue;
            }
            if (this.t.currentToken != 116) break;
            this.parseLetClause(arrayList);
        }
        if (this.t.currentToken == 28 || this.isKeyword("where")) {
            n2 = this.t.currentTokenStartOffset;
            this.nextToken();
            expression = this.parseExpression();
        }
        int n3 = this.t.currentTokenStartOffset;
        if (this.isKeyword("stable")) {
            this.nextToken();
            if (!this.isKeyword("order")) {
                this.grumble("'stable' must be followed by 'order by'");
            }
        }
        List list = null;
        if (this.isKeyword("order")) {
            this.t.setState(1);
            this.nextToken();
            if (!this.isKeyword("by")) {
                this.grumble("'order' must be followed by 'by'");
            }
            this.t.setState(0);
            this.nextToken();
            list = this.parseSortDefinition();
        }
        int n4 = this.t.currentTokenStartOffset;
        this.expect(25);
        this.t.setState(0);
        this.nextToken();
        Expression expression2 = this.parseExprSingle();
        expression2 = this.makeTracer(n4, expression2, 2014, -1);
        if (expression != null) {
            expression2 = new IfExpression(expression, expression2, EmptySequence.getInstance());
            expression2 = this.makeTracer(n2, expression2, 2018, -1);
            this.setLocation(expression2);
        }
        if (list != null) {
            TupleExpression tupleExpression = new TupleExpression(1 + list.size());
            this.setLocation(tupleExpression);
            tupleExpression.setExpression(0, expression2);
            int n5 = 0;
            while (n5 < list.size()) {
                try {
                    object2 = TypeChecker.staticTypeCheck(((SortSpec)list.get((int)n5)).sortKey, SequenceType.OPTIONAL_ATOMIC, false, new RoleLocator(6, "FLWR", n5), this.env);
                    tupleExpression.setExpression(n5 + 1, (Expression)object2);
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                }
                ++n5;
            }
            expression2 = tupleExpression;
        }
        int n6 = arrayList.size() - 1;
        while (n6 >= 0) {
            Object e = arrayList.get(n6);
            if (e instanceof ExpressionParser.ForClause) {
                object2 = (ExpressionParser.ForClause)e;
                object = new ForExpression();
                ((Assignation)object).setVariableDeclaration(((ExpressionParser.ForClause)object2).rangeVariable);
                ((ForExpression)object).setPositionVariable(((ExpressionParser.ForClause)object2).positionVariable);
                ((ComputedExpression)object).setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), this.t.getLineNumber(((ExpressionParser.ForClause)object2).offset)));
                ((Assignation)object).setSequence(((ExpressionParser.ForClause)object2).sequence);
                ((ForExpression)object).setAction(expression2);
                expression2 = this.makeTracer(((ExpressionParser.ForClause)object2).offset, (Expression)object, 2012, ((ExpressionParser.ForClause)object2).rangeVariable.getNameCode());
            } else {
                object2 = (LetClause)e;
                object = this.makeLetExpression();
                ((Assignation)object).setVariableDeclaration(((LetClause)object2).variable);
                ((ComputedExpression)object).setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), this.t.getLineNumber(((LetClause)object2).offset)));
                ((Assignation)object).setSequence(((LetClause)object2).value);
                ((Assignation)object).setAction(expression2);
                expression2 = this.makeTracer(((LetClause)object2).offset, (Expression)object, 2013, ((LetClause)object2).variable.getNameCode());
            }
            --n6;
        }
        if (list != null) {
            FixedSortKeyDefinition[] fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[list.size()];
            int n7 = 0;
            while (n7 < list.size()) {
                object = (SortSpec)list.get(n7);
                FixedSortKeyDefinition fixedSortKeyDefinition = new FixedSortKeyDefinition();
                fixedSortKeyDefinition.setSortKey(((SortSpec)list.get((int)n7)).sortKey);
                fixedSortKeyDefinition.setOrder(new StringValue(((SortSpec)object).ascending ? "ascending" : "descending"));
                fixedSortKeyDefinition.setEmptyFirst(((SortSpec)object).ascending ? ((SortSpec)object).emptyLeast : !((SortSpec)object).emptyLeast);
                try {
                    if (((SortSpec)object).collation != null) {
                        fixedSortKeyDefinition.setCollation(this.env.getCollation(((SortSpec)object).collation));
                    }
                    fixedSortKeyDefinition.bindComparer();
                    fixedSortKeyDefinitionArray[n7] = fixedSortKeyDefinition;
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                }
                ++n7;
            }
            object = new TupleSorter(expression2, fixedSortKeyDefinitionArray);
            this.setLocation((Expression)object);
            expression2 = this.makeTracer(n3, (Expression)object, 2019, -1);
        }
        int n8 = arrayList.size() - 1;
        while (n8 >= 0) {
            Object e = arrayList.get(n8);
            if (e instanceof ExpressionParser.ForClause && ((ExpressionParser.ForClause)e).positionVariable != null) {
                this.undeclareRangeVariable();
            }
            this.undeclareRangeVariable();
            --n8;
        }
        this.setLocation(expression2, n);
        return expression2;
    }

    private LetExpression makeLetExpression() {
        if (this.env.getConfiguration().getTraceListener() == null) {
            return new LetExpression();
        }
        return new EagerLetExpression();
    }

    private void parseForClause(List list) throws StaticError {
        boolean bl = true;
        do {
            Object object;
            ExpressionParser.ForClause forClause = new ExpressionParser.ForClause();
            if (bl) {
                forClause.offset = this.t.currentTokenStartOffset;
            }
            list.add(forClause);
            this.nextToken();
            if (bl) {
                bl = false;
            } else {
                forClause.offset = this.t.currentTokenStartOffset;
            }
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setNameCode(this.makeNameCode(string, false));
            rangeVariableDeclaration.setRequiredType(SequenceType.SINGLE_ITEM);
            rangeVariableDeclaration.setVariableName(string);
            forClause.rangeVariable = rangeVariableDeclaration;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                object = this.parseSequenceType();
                rangeVariableDeclaration.setRequiredType((SequenceType)object);
                if (((SequenceType)object).getCardinality() != 512) {
                    this.grumble("Cardinality of range variable must be exactly one");
                }
            }
            forClause.positionVariable = null;
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(21);
                this.nextToken();
                this.expect(101);
                object = new RangeVariableDeclaration();
                ((RangeVariableDeclaration)object).setNameCode(this.makeNameCode(this.t.currentTokenValue, false));
                ((RangeVariableDeclaration)object).setRequiredType(SequenceType.SINGLE_INTEGER);
                ((RangeVariableDeclaration)object).setVariableName(this.t.currentTokenValue);
                forClause.positionVariable = object;
                this.declareRangeVariable((VariableDeclaration)object);
                this.nextToken();
            }
            this.expect(30);
            this.nextToken();
            forClause.sequence = this.parseExprSingle();
            this.declareRangeVariable(forClause.rangeVariable);
            if (forClause.positionVariable == null) continue;
            this.declareRangeVariable(forClause.positionVariable);
        } while (this.t.currentToken == 7);
    }

    private void parseLetClause(List list) throws StaticError {
        boolean bl = true;
        do {
            LetClause letClause = new LetClause();
            if (bl) {
                letClause.offset = this.t.currentTokenStartOffset;
            }
            list.add(letClause);
            this.nextToken();
            if (bl) {
                bl = false;
            } else {
                letClause.offset = this.t.currentTokenStartOffset;
            }
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setNameCode(this.makeNameCode(string, false));
            rangeVariableDeclaration.setRequiredType(SequenceType.ANY_SEQUENCE);
            rangeVariableDeclaration.setVariableName(string);
            letClause.variable = rangeVariableDeclaration;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                rangeVariableDeclaration.setRequiredType(this.parseSequenceType());
            }
            this.expect(52);
            this.nextToken();
            letClause.value = this.parseExprSingle();
            this.declareRangeVariable(rangeVariableDeclaration);
        } while (this.t.currentToken == 7);
    }

    private List parseSortDefinition() throws StaticError {
        ArrayList<SortSpec> arrayList = new ArrayList<SortSpec>(5);
        while (true) {
            SortSpec sortSpec = new SortSpec();
            sortSpec.sortKey = this.parseExprSingle();
            sortSpec.ascending = true;
            sortSpec.emptyLeast = this.defaultEmptyLeast;
            sortSpec.collation = this.env.getDefaultCollationName();
            if (this.isKeyword("ascending")) {
                this.nextToken();
            } else if (this.isKeyword("descending")) {
                sortSpec.ascending = false;
                this.nextToken();
            }
            if (this.isKeyword("empty")) {
                this.nextToken();
                if (this.isKeyword("greatest")) {
                    sortSpec.emptyLeast = false;
                    this.nextToken();
                } else if (this.isKeyword("least")) {
                    sortSpec.emptyLeast = true;
                    this.nextToken();
                } else {
                    this.grumble("'empty' must be followed by 'greatest' or 'least'");
                }
            }
            if (this.isKeyword("collation")) {
                this.nextToken();
                this.expect(102);
                sortSpec.collation = this.t.currentTokenValue;
                this.nextToken();
            }
            arrayList.add(sortSpec);
            if (this.t.currentToken != 7) break;
            this.nextToken();
        }
        return arrayList;
    }

    protected Expression parseTypeswitchExpression() throws StaticError {
        Object object;
        Object object2;
        int n;
        int n2 = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression expression = this.parseExpression();
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(10);
        this.expect(104);
        this.nextToken();
        LetExpression letExpression = this.makeLetExpression();
        RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
        rangeVariableDeclaration.setNameCode(this.makeNameCode("zz_typeswitchVar", false));
        rangeVariableDeclaration.setRequiredType(SequenceType.ANY_SEQUENCE);
        rangeVariableDeclaration.setVariableName("zz_typeswitchVar");
        letExpression.setVariableDeclaration(rangeVariableDeclaration);
        letExpression.setSequence(expression);
        while (this.t.currentToken == 59) {
            n = this.t.currentTokenStartOffset;
            this.nextToken();
            if (this.t.currentToken == 21) {
                this.nextToken();
                this.expect(101);
                String string = this.t.currentTokenValue;
                int n3 = this.makeNameCode(string, false);
                this.nextToken();
                this.expect(101);
                if (!"as".equals(this.t.currentTokenValue)) {
                    this.grumble("After 'case $" + string + "', expected 'as'");
                }
                this.nextToken();
                object2 = this.parseSequenceType();
                object = this.makeTracer(n, this.parseTypeswitchReturnClause(string, n3, (SequenceType)object2, rangeVariableDeclaration), 2021, n3);
                if (object instanceof TraceExpression) {
                    ((TraceExpression)object).setProperty("type", ((SequenceType)object2).toString());
                }
            } else {
                object2 = this.parseSequenceType();
                this.t.treatCurrentAsOperator();
                this.expect(25);
                this.nextToken();
                object = this.makeTracer(n, this.parseExprSingle(), 2021, -1);
                if (object instanceof TraceExpression) {
                    ((TraceExpression)object).setProperty("type", ((SequenceType)object2).toString());
                }
            }
            arrayList.add(object2);
            arrayList2.add(object);
        }
        if (arrayList.size() == 0) {
            this.grumble("At least one case clause is required in a typeswitch");
        }
        this.expect(60);
        n = this.t.currentTokenStartOffset;
        this.nextToken();
        if (this.t.currentToken == 21) {
            this.nextToken();
            this.expect(101);
            object = this.t.currentTokenValue;
            int n4 = this.makeNameCode((String)object, false);
            this.nextToken();
            object2 = this.makeTracer(n, this.parseTypeswitchReturnClause((String)object, n4, SequenceType.ANY_SEQUENCE, rangeVariableDeclaration), 2022, n4);
        } else {
            this.t.treatCurrentAsOperator();
            this.expect(25);
            this.nextToken();
            object2 = this.makeTracer(n, this.parseExprSingle(), 2022, -1);
        }
        object = object2;
        int n5 = arrayList.size() - 1;
        while (n5 >= 0) {
            VariableReference variableReference = new VariableReference(rangeVariableDeclaration);
            this.setLocation(variableReference);
            InstanceOfExpression instanceOfExpression = new InstanceOfExpression(variableReference, (SequenceType)arrayList.get(n5));
            this.setLocation(instanceOfExpression);
            IfExpression ifExpression = new IfExpression(instanceOfExpression, (Expression)arrayList2.get(n5), (Expression)object);
            this.setLocation(ifExpression);
            object = ifExpression;
            --n5;
        }
        letExpression.setAction((Expression)object);
        return this.makeTracer(n2, letExpression, 2020, -1);
    }

    private Expression parseTypeswitchReturnClause(String string, int n, SequenceType sequenceType, RangeVariableDeclaration rangeVariableDeclaration) throws StaticError {
        this.t.treatCurrentAsOperator();
        this.expect(25);
        this.nextToken();
        RangeVariableDeclaration rangeVariableDeclaration2 = new RangeVariableDeclaration();
        rangeVariableDeclaration2.setNameCode(n);
        rangeVariableDeclaration2.setRequiredType(sequenceType);
        rangeVariableDeclaration2.setVariableName(string);
        this.declareRangeVariable(rangeVariableDeclaration2);
        Expression expression = this.parseExprSingle();
        this.undeclareRangeVariable();
        LetExpression letExpression = this.makeLetExpression();
        letExpression.setVariableDeclaration(rangeVariableDeclaration2);
        letExpression.setSequence(new VariableReference(rangeVariableDeclaration));
        letExpression.setAction(expression);
        expression = letExpression;
        return expression;
    }

    protected Expression parseValidateExpression() throws StaticError {
        if (!this.env.getConfiguration().isSchemaAware(11)) {
            this.grumble("To use a validate expression, you need the schema-aware processor from http://www.saxonica.com/");
        }
        int n = this.t.currentTokenStartOffset;
        int n2 = 1;
        boolean bl = false;
        switch (this.t.currentToken) {
            case 82: {
                n2 = 1;
                this.nextToken();
                break;
            }
            case 83: {
                n2 = 2;
                this.nextToken();
                break;
            }
            case 54: {
                if (this.t.currentTokenValue != "validate") {
                    throw new AssertionError((Object)"shouldn't be parsing a validate expression");
                }
                n2 = 1;
                bl = true;
            }
        }
        if (!bl) {
            this.expect(53);
        }
        this.nextToken();
        Expression expression = this.parseExpression();
        if (expression instanceof ElementCreator) {
            ((ElementCreator)expression).setValidationMode(n2);
        } else if (expression instanceof DocumentInstr) {
            ((DocumentInstr)expression).setValidationAction(n2);
        } else {
            try {
                expression = TypeChecker.staticTypeCheck(expression, SequenceType.SINGLE_NODE, false, new RoleLocator(2, "validate", 0), this.env);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage());
            }
            expression = new CopyOf(expression, true, n2, null);
            this.setLocation(expression);
            ((CopyOf)expression).setRequireDocumentOrElement(true);
        }
        this.expect(115);
        this.t.lookAhead();
        this.nextToken();
        return this.makeTracer(n, expression, 2023, -1);
    }

    protected Expression parseConstructor() throws StaticError {
        int n = this.t.currentTokenStartOffset;
        switch (this.t.currentToken) {
            case 117: {
                Expression expression = this.parsePseudoXML(false);
                this.lookAhead();
                this.t.setState(3);
                this.nextToken();
                return expression;
            }
            case 54: {
                String string = this.t.currentTokenValue;
                if (string == "validate") {
                    return this.parseValidateExpression();
                }
                if (string == "ordered" || string == "unordered") {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    return expression;
                }
                if (string == "document") {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    DocumentInstr documentInstr = new DocumentInstr(false, null, this.env.getBaseURI());
                    this.makeContentConstructor(expression, documentInstr, n);
                    return documentInstr;
                }
                if ("element".equals(string)) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression2 = null;
                    if (this.t.currentToken != 115) {
                        expression2 = this.parseExpression();
                        if (expression2 instanceof ElementCreator) {
                            ((ElementCreator)expression2).setValidationMode(3);
                        }
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    if (expression instanceof Value) {
                        int n2;
                        if (expression instanceof StringValue) {
                            String string2 = ((StringValue)expression).getStringValue();
                            n2 = this.makeNameCode(string2, true);
                        } else if (expression instanceof QNameValue) {
                            n2 = this.env.getNamePool().allocate("", ((QNameValue)expression).getNamespaceURI(), ((QNameValue)expression).getLocalName());
                        } else {
                            this.grumble("Element name must be either a string or a QName");
                            return null;
                        }
                        FixedElement fixedElement = new FixedElement(n2, ((StaticQueryContext)this.env).getActiveNamespaceCodes(), null, false, null, ((StaticQueryContext)this.env).getConstructionMode());
                        this.setLocation(fixedElement);
                        this.makeContentConstructor(expression2, fixedElement, n);
                        return this.makeTracer(n, fixedElement, 2006, n2);
                    }
                    Element element = new Element(expression, null, this.env.getNamespaceResolver(), null, null, ((StaticQueryContext)this.env).getConstructionMode());
                    this.setLocation(element);
                    this.makeContentConstructor(expression2, element, n);
                    return this.makeTracer(n, element, 143, -1);
                }
                if ("attribute".equals(string)) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression3 = null;
                    if (this.t.currentToken != 115) {
                        expression3 = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    if (expression instanceof StringValue && expression3 instanceof Value) {
                        int n3 = this.makeNameCode(((StringValue)expression).getStringValue(), false);
                        FixedAttribute fixedAttribute = new FixedAttribute(n3, 4, Type.UNTYPED_ATOMIC_TYPE, -1);
                        fixedAttribute.setRejectDuplicates();
                        this.makeSimpleContent(expression3, fixedAttribute, n);
                        return this.makeTracer(n, fixedAttribute, 131, -1);
                    }
                    Attribute attribute = new Attribute(expression, null, this.env.getNamespaceResolver(), 4, null, -1);
                    attribute.setRejectDuplicates();
                    this.makeSimpleContent(expression3, attribute, n);
                    return this.makeTracer(n, attribute, 131, -1);
                }
                if ("text".equals(string)) {
                    this.nextToken();
                    if (this.t.currentToken == 115) {
                        this.lookAhead();
                        this.nextToken();
                        return EmptySequence.getInstance();
                    }
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    ValueOf valueOf = new ValueOf(this.stringify(expression), false);
                    this.setLocation(valueOf, n);
                    return this.makeTracer(n, valueOf, 182, -1);
                }
                if ("comment".equals(string)) {
                    this.nextToken();
                    if (this.t.currentToken == 115) {
                        this.lookAhead();
                        this.nextToken();
                        return EmptySequence.getInstance();
                    }
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    Comment comment = new Comment();
                    this.makeSimpleContent(expression, comment, n);
                    return this.makeTracer(n, comment, 138, -1);
                }
                if ("processing-instruction".equals(string)) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression4 = null;
                    if (this.t.currentToken != 115) {
                        expression4 = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    ProcessingInstruction processingInstruction = new ProcessingInstruction(expression);
                    this.makeSimpleContent(expression4, processingInstruction, n);
                    return this.makeTracer(n, processingInstruction, 173, -1);
                }
                this.grumble("Unrecognized node constructor " + this.t.currentTokenValue + "{}");
            }
            case 55: {
                int n4 = this.makeNameCode(this.t.currentTokenValue, true);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                FixedElement fixedElement = new FixedElement(n4, ((StaticQueryContext)this.env).getActiveNamespaceCodes(), null, false, null, ((StaticQueryContext)this.env).getConstructionMode());
                this.setLocation(fixedElement);
                this.makeContentConstructor(expression, fixedElement, n);
                return this.makeTracer(n, fixedElement, 2006, n4);
            }
            case 56: {
                int n5 = this.makeNameCode(this.t.currentTokenValue, false);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                FixedAttribute fixedAttribute = new FixedAttribute(n5, 4, null, -1);
                fixedAttribute.setRejectDuplicates();
                this.makeSimpleContent(expression, fixedAttribute, n);
                return this.makeTracer(n, fixedAttribute, 2007, n5);
            }
            case 57: {
                StringValue stringValue = new StringValue(this.t.currentTokenValue);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                ProcessingInstruction processingInstruction = new ProcessingInstruction(stringValue);
                this.makeSimpleContent(expression, processingInstruction, n);
                return this.makeTracer(n, processingInstruction, 173, -1);
            }
        }
        return null;
    }

    private void makeSimpleContent(Expression expression, SimpleNodeConstructor simpleNodeConstructor, int n) throws StaticError {
        try {
            if (expression == null) {
                simpleNodeConstructor.setSelect(StringValue.EMPTY_STRING);
            } else {
                simpleNodeConstructor.setSelect(this.stringify(expression));
            }
            this.setLocation(simpleNodeConstructor, n);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    private void makeContentConstructor(Expression expression, InstructionWithChildren instructionWithChildren, int n) {
        if (expression == null) {
            instructionWithChildren.setChildren(null);
        } else if (expression instanceof AppendExpression) {
            ArrayList arrayList = new ArrayList(10);
            this.convertAppendExpression((AppendExpression)expression, arrayList);
            instructionWithChildren.setChildren(arrayList.toArray(new Expression[arrayList.size()]));
        } else {
            Expression[] expressionArray = new Expression[]{expression};
            instructionWithChildren.setChildren(expressionArray);
        }
        this.setLocation(instructionWithChildren, n);
    }

    private void convertAppendExpression(AppendExpression appendExpression, List list) {
        Iterator iterator = appendExpression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if (expression instanceof AppendExpression) {
                this.convertAppendExpression((AppendExpression)expression, list);
                continue;
            }
            list.add(expression);
        }
    }

    private Expression parsePseudoXML(boolean bl) throws StaticError {
        Expression expression = null;
        int n = this.t.inputOffset;
        char c = this.t.nextChar();
        switch (c) {
            case '!': {
                c = this.t.nextChar();
                if (c == '-') {
                    expression = this.parseCommentConstructor();
                    break;
                }
                if (c == '[') {
                    expression = this.parseCDATAConstructor();
                    break;
                }
                this.grumble("Expected '--' or '[CDATA[' after '<!'");
                break;
            }
            case '?': {
                expression = this.parsePIConstructor();
                break;
            }
            case '/': {
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer(40);
                    while ((c = this.t.nextChar()) != '>') {
                        stringBuffer.append(c);
                    }
                    return new StringValue(stringBuffer);
                }
                this.grumble("Unmatched XML end tag");
                break;
            }
            default: {
                this.t.unreadChar();
                expression = this.parseDirectElementConstructor();
            }
        }
        this.setLocation(expression, n);
        return expression;
    }

    private Expression parseDirectElementConstructor() throws StaticError {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        char c;
        int n = this.t.inputOffset - 1;
        StringBuffer stringBuffer = new StringBuffer(40);
        int n2 = 0;
        while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        HashMap<String, Expression[]> hashMap = new HashMap<String, Expression[]>(10);
        while ((c = this.skipSpaces(c)) != '/' && c != '>') {
            int n3 = this.t.inputOffset - 1;
            stringBuffer.setLength(0);
            do {
                stringBuffer.append(c);
            } while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '=');
            String string2 = stringBuffer.toString();
            if (!Name.isQName(string2)) {
                this.grumble("Invalid attribute name " + Err.wrap(string2, 2));
            }
            c = this.skipSpaces(c);
            this.expectChar(c, '=');
            c = this.t.nextChar();
            c = this.skipSpaces(c);
            try {
                object5 = this.makeAttributeContent(this.t.input, this.t.inputOffset, c, true);
            }
            catch (StaticError staticError) {
                this.grumble(staticError.getMessage());
                return null;
            }
            catch (XPathException xPathException) {
                throw xPathException.makeStatic();
            }
            int n4 = (int)((IntegerValue)object5).longValue();
            object4 = this.t.input.substring(this.t.inputOffset - 1, n4 + 1);
            object3 = this.t.input.substring(this.t.inputOffset, n4);
            this.t.inputOffset = n4 + 1;
            c = this.t.nextChar();
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
                this.grumble("There must be whitespace after every attribute except the last");
            }
            if ("xmlns".equals(string2) || string2.startsWith("xmlns:")) {
                if (((String)object3).indexOf(123) >= 0) {
                    this.grumble("Namespace URI must be a constant value");
                }
                if ("xmlns".equals(string2)) {
                    object2 = "";
                    object = object3;
                } else {
                    object2 = string2.substring(6);
                    object = object3;
                    if ("".equals(object)) {
                        this.grumble("Namespace URI must not be empty");
                    }
                }
                ++n2;
                ((StaticQueryContext)this.env).declareActiveNamespace((String)object2, (String)object);
            }
            object2 = new AttributeDetails();
            object2.name = string2;
            object2.value = object4;
            object2.startOffset = n3;
            hashMap.put(string2, (Expression[])object2);
        }
        int n5 = 0;
        try {
            object5 = Name.getQNameParts(string);
            String string3 = ((StaticQueryContext)this.env).checkURIForPrefix(object5[0]);
            if (string3 == null) {
                this.grumble("Undeclared prefix in element name " + Err.wrap(string, 1));
            }
            n5 = this.env.getNamePool().allocate(object5[0], string3, object5[1]);
        }
        catch (QNameException qNameException) {
            this.grumble("Invalid element name " + Err.wrap(string, 1));
        }
        int n6 = ((StaticQueryContext)this.env).getConstructionMode();
        FixedElement fixedElement = new FixedElement(n5, ((StaticQueryContext)this.env).getActiveNamespaceCodes(), null, false, null, n6);
        this.setLocation(fixedElement, n);
        object4 = new ArrayList(10);
        object3 = hashMap.keySet().iterator();
        while (object3.hasNext()) {
            Expression expression;
            Object object6;
            object2 = (Expression[])object3.next();
            object = (AttributeDetails)hashMap.get(object2);
            String string4 = ((AttributeDetails)object).value;
            int n7 = ((AttributeDetails)object).startOffset;
            if ("xmlns".equals(object2) || object2.startsWith("xmlns:")) continue;
            int n8 = 0;
            try {
                object6 = Name.getQNameParts((CharSequence)object2);
                String string5 = "".equals(object6[0]) ? "" : ((StaticQueryContext)this.env).checkURIForPrefix(object6[0]);
                if (string5 == null) {
                    this.grumble("Undeclared prefix in attribute name " + Err.wrap((CharSequence)object2, 2));
                }
                n8 = this.env.getNamePool().allocate(object6[0], string5, object6[1]);
            }
            catch (QNameException qNameException) {
                this.grumble("Invalid attribute name " + Err.wrap((CharSequence)object2, 2));
            }
            object6 = new FixedAttribute(n8, 4, null, -1);
            this.setLocation((Expression)object6);
            try {
                expression = this.makeAttributeContent(string4, 1, string4.charAt(0), false);
            }
            catch (XPathException xPathException) {
                throw xPathException.makeStatic();
            }
            ((FixedAttribute)object6).setSelect(expression);
            ((FixedAttribute)object6).setRejectDuplicates();
            this.setLocation((Expression)object6);
            object4.add(this.makeTracer(n7, (Expression)object6, 2007, n8));
        }
        if (c == '/') {
            this.expectChar(this.t.nextChar(), '>');
        } else {
            this.readElementContent(string, (List)object4);
        }
        object2 = new Expression[object4.size()];
        int n9 = 0;
        while (n9 < object4.size()) {
            if (n6 != 4 && object4.get(n9) instanceof ElementCreator && ((ElementCreator)object4.get(n9)).getValidationMode() == n6) {
                ((ElementCreator)object4.get(n9)).setValidationMode(3);
            }
            object2[n9] = (Expression)object4.get(n9);
            ++n9;
        }
        fixedElement.setChildren((Expression[])object2);
        int n10 = 0;
        while (n10 < n2) {
            ((StaticQueryContext)this.env).undeclareNamespace();
            ++n10;
        }
        return this.makeTracer(n, fixedElement, 2006, n5);
    }

    private Expression makeAttributeContent(String string, int n, char c, boolean bl) throws XPathException {
        Expression expression;
        Object object;
        int n2 = this.t.getLineNumber();
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        int n3 = n;
        int n4 = string.length();
        while (n3 < n4) {
            int n5 = string.indexOf(c, n3);
            if (n5 < 0) {
                throw new StaticError("Attribute constructor is not properly terminated");
            }
            int n6 = string.indexOf("{", n3);
            int n7 = string.indexOf("{{", n3);
            int n8 = string.indexOf("}", n3);
            int n9 = string.indexOf("}}", n3);
            if (!(n6 >= 0 && n5 >= n6 || n8 >= 0 && n5 >= n8)) {
                this.addStringComponent(arrayList, string, n3, n5);
                if (n5 + 1 < string.length() && string.charAt(n5 + 1) == c) {
                    arrayList.add(new StringValue(c + ""));
                    n3 = n5 + 2;
                    continue;
                }
                n3 = n5;
                break;
            }
            if (n8 >= 0 && (n6 < 0 || n8 < n6)) {
                if (n8 != n9) {
                    throw new StaticError("Closing curly brace in attribute value template \"" + string + "\" must be doubled");
                }
                this.addStringComponent(arrayList, string, n3, n8 + 1);
                n3 = n8 + 2;
                continue;
            }
            if (n7 >= 0 && n7 == n6) {
                this.addStringComponent(arrayList, string, n3, n7 + 1);
                n3 = n7 + 2;
                continue;
            }
            if (n6 >= 0) {
                if (n6 > n3) {
                    this.addStringComponent(arrayList, string, n3, n6);
                }
                object = new QueryParser();
                ((ExpressionParser)object).setScanOnly(bl);
                if (this.rangeVariables != null) {
                    ((ExpressionParser)object).setRangeVariableStack(this.rangeVariables);
                }
                expression = ((ExpressionParser)object).parse(string, n6 + 1, 115, n2, this.env);
                if (!bl) {
                    expression = expression.simplify(this.env);
                }
                n3 = ((ExpressionParser)object).getTokenizer().currentTokenStartOffset + 1;
                arrayList.add(AttributeValueTemplate.makeStringJoin(expression, this.env.getNamePool()));
                continue;
            }
            throw new IllegalStateException("Internal error parsing AVT");
        }
        if (bl) {
            return new IntegerValue(n3);
        }
        if (arrayList.size() == 0) {
            return StringValue.EMPTY_STRING;
        }
        if (arrayList.size() == 1) {
            return ((Expression)arrayList.get(0)).simplify(this.env);
        }
        expression = (Concat)SystemFunction.makeSystemFunction("concat", this.env.getNamePool());
        object = new Expression[arrayList.size()];
        arrayList.toArray((T[])object);
        ((FunctionCall)expression).setArguments((Expression[])object);
        ((ComputedExpression)expression).setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), n2));
        return ((FunctionCall)expression).simplify(this.env);
    }

    private void addStringComponent(List list, String string, int n, int n2) throws XPathException {
        if (n < n2) {
            list.add(this.makeStringLiteral(string.substring(n, n2)));
        }
    }

    private void readElementContent(String string, List list) throws StaticError {
        try {
            while (true) {
                Object object;
                Expression expression;
                char c;
                StringBuffer stringBuffer = new StringBuffer(10);
                boolean bl = false;
                while ((c = this.t.nextChar()) != '<') {
                    if (c == '&') {
                        stringBuffer.append(this.readEntityReference());
                        bl = true;
                        continue;
                    }
                    if (c == '}') {
                        c = this.t.nextChar();
                        if (c != '}') {
                            this.grumble("'}' must be written as '}}' within element content");
                        }
                        stringBuffer.append(c);
                        continue;
                    }
                    if (c == '{') {
                        c = this.t.nextChar();
                        if (c != '{') {
                            c = '{';
                            break;
                        }
                        stringBuffer.append(c);
                        continue;
                    }
                    stringBuffer.append(c);
                }
                if (stringBuffer.length() > 0 && bl | this.preserveSpace | !Navigator.isWhite(stringBuffer)) {
                    expression = new ValueOf(new StringValue(stringBuffer.toString()), false);
                    this.setLocation(expression);
                    list.add(expression);
                }
                if (c == '<') {
                    expression = this.parsePseudoXML(true);
                    if (expression instanceof StringValue) {
                        object = ((StringValue)expression).getStringValue().trim();
                        if (((String)object).equals(string)) {
                            return;
                        }
                        this.grumble("end tag </" + (String)object + "> does not match start tag <" + string + '>');
                        continue;
                    }
                    list.add(expression);
                    continue;
                }
                this.t.unreadChar();
                this.t.setState(0);
                this.lookAhead();
                this.nextToken();
                expression = this.parseExpression();
                list.add(expression);
                this.expect(115);
                object = new ValueOf(new StringValue(""), false);
                this.setLocation((Expression)object);
                list.add(object);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing end tag found for direct element constructor");
            return;
        }
    }

    private Expression parsePIConstructor() throws StaticError {
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer(120);
            int n = -1;
            while (!stringBuffer.toString().endsWith("?>")) {
                char c = this.t.nextChar();
                if (n < 0 && " \t\r\n".indexOf(c) >= 0) {
                    n = stringBuffer.length();
                }
                stringBuffer.append(c);
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            String string2 = "";
            if (n < 0) {
                string = stringBuffer.toString();
            } else {
                string = stringBuffer.substring(0, n);
                string2 = stringBuffer.substring(n + 1).trim();
            }
            if (!XMLChar.isValidNCName(string)) {
                this.grumble("Invalid processing instruction name " + Err.wrap(string));
            }
            ProcessingInstruction processingInstruction = new ProcessingInstruction(new StringValue(string));
            processingInstruction.setSelect(new StringValue(string2));
            this.setLocation(processingInstruction);
            return processingInstruction;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '?>' found for processing instruction");
            return null;
        }
    }

    private Expression parseCDATAConstructor() throws StaticError {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, 'C');
            c = this.t.nextChar();
            this.expectChar(c, 'D');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, 'T');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, '[');
            StringBuffer stringBuffer = new StringBuffer(240);
            while (!stringBuffer.toString().endsWith("]]>")) {
                stringBuffer.append(this.t.nextChar());
            }
            String string = stringBuffer.substring(0, stringBuffer.length() - 3);
            ValueOf valueOf = new ValueOf(new StringValue(string), false);
            this.setLocation(valueOf);
            return valueOf;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ']]>' found for CDATA section");
            return null;
        }
    }

    private Expression parseCommentConstructor() throws StaticError {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, '-');
            StringBuffer stringBuffer = new StringBuffer(240);
            while (!stringBuffer.toString().endsWith("--")) {
                stringBuffer.append(this.t.nextChar());
            }
            if (this.t.nextChar() != '>') {
                this.grumble("'--' is not permitted in an XML comment");
            }
            String string = stringBuffer.substring(0, stringBuffer.length() - 2);
            Comment comment = new Comment();
            comment.setSelect(new StringValue(string));
            this.setLocation(comment);
            return comment;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '-->' found for comment constructor");
            return null;
        }
    }

    private Expression stringify(Expression expression) {
        expression = new Atomizer(expression);
        expression = new AtomicSequenceConverter(expression, Type.STRING_TYPE);
        StringJoin stringJoin = (StringJoin)SystemFunction.makeSystemFunction("string-join", this.executable.getConfiguration().getNamePool());
        Expression[] expressionArray = new Expression[]{expression, new StringValue(" ")};
        stringJoin.setArguments(expressionArray);
        this.setLocation(stringJoin);
        return stringJoin;
    }

    protected StringValue makeStringLiteral(String string) throws StaticError {
        if (string.indexOf(38) == -1) {
            return new StringValue(string);
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '&') {
                int n2 = string.indexOf(59, n);
                if (n2 < 0) {
                    this.grumble("No closing ';' found for entity or character reference");
                } else {
                    String string2 = string.substring(n + 1, n2);
                    stringBuffer.append(this.analyzeEntityReference(string2));
                    n = n2;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return new StringValue(stringBuffer);
    }

    private String readEntityReference() throws StaticError {
        try {
            char c;
            StringBuffer stringBuffer = new StringBuffer(40);
            while ((c = this.t.nextChar()) != ';') {
                stringBuffer.append(c);
            }
            String string = stringBuffer.toString();
            return this.analyzeEntityReference(string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ';' found for entity or character reference");
            return null;
        }
    }

    private String analyzeEntityReference(String string) throws StaticError {
        if ("lt".equals(string)) {
            return "<";
        }
        if ("gt".equals(string)) {
            return ">";
        }
        if ("amp".equals(string)) {
            return "&";
        }
        if ("quot".equals(string)) {
            return "\"";
        }
        if ("apos".equals(string)) {
            return "'";
        }
        if (string.length() < 2 || string.charAt(0) != '#') {
            this.grumble("invalid entity reference &" + string + ';');
            return null;
        }
        string = string.toLowerCase();
        return this.parseCharacterReference(string);
    }

    private String parseCharacterReference(String string) throws StaticError {
        int n = 0;
        if (string.charAt(1) == 'x') {
            int n2 = 2;
            while (n2 < string.length()) {
                int n3 = "0123456789abcdef".indexOf(string.charAt(n2));
                if (n3 < 0) {
                    this.grumble("invalid character '" + string.charAt(n2) + "' in hex character reference");
                }
                n = n * 16 + n3;
                ++n2;
            }
        } else {
            int n4 = 1;
            while (n4 < string.length()) {
                int n5 = "0123456789".indexOf(string.charAt(n4));
                if (n5 < 0) {
                    this.grumble("invalid character '" + string.charAt(n4) + "' in decimal character reference");
                }
                n = n * 10 + n5;
                ++n4;
            }
        }
        if (n < 32 && n != 10 && n != 9 && n != 13 || n >= 55296 && n <= 57343 || n == 65534 || n == 65535 || n > 0x10FFFF) {
            this.grumble("Invalid XML character reference x" + Integer.toHexString(n));
        }
        if (n <= 65535) {
            return "" + (char)n;
        }
        if (n <= 0x10FFFF) {
            return "" + (char)(0xD800 | (n -= 65536) >> 10) + (char)(0xDC00 | n & 0x3FF);
        }
        this.grumble("Character reference x" + Integer.toHexString(n) + " is too large");
        return null;
    }

    private void lookAhead() throws StaticError {
        try {
            this.t.lookAhead();
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    private char skipSpaces(char c) {
        while (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
            c = this.t.nextChar();
        }
        return c;
    }

    private void expectChar(char c, char c2) throws StaticError {
        if (c != c2) {
            this.grumble("Expected '" + c2 + "', found '" + c + '\'');
        }
    }

    protected String getLanguage() {
        return "XQuery";
    }

    private static class AttributeDetails {
        String name;
        String value;
        int startOffset;

        private AttributeDetails() {
        }
    }

    private static class SortSpec {
        public Expression sortKey;
        public boolean ascending;
        public boolean emptyLeast;
        public String collation;

        private SortSpec() {
        }
    }

    private static class LetClause {
        public RangeVariableDeclaration variable;
        public Expression value;
        public int offset;

        private LetClause() {
        }
    }
}

