/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.sort.LowercaseFirstComparer;
import net.sf.saxon.sort.NumericComparer;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.TextComparer;
import net.sf.saxon.sort.UppercaseFirstComparer;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class FixedSortKeyDefinition
extends SortKeyDefinition {
    private transient Comparator comparer = null;

    public SortKeyDefinition simplify() throws XPathException {
        return this;
    }

    public FixedSortKeyDefinition reduce(XPathContext xPathContext) throws XPathException {
        return this;
    }

    public void bindComparer() throws XPathException {
        Serializable serializable;
        Object object;
        Comparator comparator;
        String string = ((StringValue)this.order).getStringValue();
        String string2 = ((StringValue)this.caseOrder).getStringValue();
        String string3 = ((StringValue)this.language).getStringValue();
        if (this.collation != null) {
            comparator = this.collation;
        } else {
            if (string3.equals("")) {
                object = Collator.getInstance();
            } else {
                serializable = Configuration.getLocale(string3);
                object = Collator.getInstance((Locale)serializable);
            }
            comparator = this.getCaseOrderComparer((Collator)object, string2);
        }
        if (this.dataTypeExpression == null || this.dataTypeExpression instanceof EmptySequence) {
            object = new RoleLocator(4, "xsl:sort/sort-key", 0);
            this.sortKey = new CardinalityChecker(this.sortKey, 768, (RoleLocator)object);
            comparator = new AtomicSortComparer(comparator);
        } else {
            object = ((StringValue)this.dataTypeExpression).getStringValue();
            if (((String)object).equals("text")) {
                comparator = new TextComparer(comparator);
            } else if (((String)object).equals("number")) {
                comparator = new NumericComparer();
            } else {
                serializable = new DynamicError("data-type on xsl:sort must be 'text' or 'number'");
                ((XPathException)serializable).setErrorCode("XT0030");
                throw serializable;
            }
        }
        this.comparer = this.getOrderedComparer(comparator, string);
    }

    private Comparator getOrderedComparer(Comparator comparator, String string) throws XPathException {
        if (string.equals("ascending")) {
            return comparator;
        }
        if (string.equals("descending")) {
            return new DescendingComparer(comparator);
        }
        DynamicError dynamicError = new DynamicError("order must be 'ascending' or 'descending'");
        dynamicError.setErrorCode("XT0030");
        throw dynamicError;
    }

    private Comparator getCaseOrderComparer(Collator collator, String string) throws XPathException {
        if (string.equals("#default")) {
            return collator;
        }
        if (string.equals("lower-first")) {
            return new LowercaseFirstComparer(collator);
        }
        if (string.equals("upper-first")) {
            return new UppercaseFirstComparer(collator);
        }
        DynamicError dynamicError = new DynamicError("case-order must be 'lower-first' or 'upper-first'");
        dynamicError.setErrorCode("XT0030");
        throw dynamicError;
    }

    public Comparator getComparer(XPathContext xPathContext) throws XPathException {
        return this.comparer;
    }
}

