/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class XSLFunction
extends StyleElement
implements StylesheetProcedure {
    private String nameAtt = null;
    private String asAtt = null;
    private String overrideAtt = null;
    private SequenceType resultType;
    private String functionName;
    private SlotManager stackFrameMap;
    private boolean memoFunction = false;
    private boolean override = true;
    private int numberOfArguments = -1;
    private UserFunction compiledFunction;
    List references = new ArrayList();

    public void registerReference(UserFunctionCall userFunctionCall) {
        this.references.add(userFunctionCall);
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "name") {
                this.nameAtt = attributeCollection.getValue(n).trim();
                if (this.nameAtt.indexOf(58) < 0) {
                    this.compileError("Function name must have a namespace prefix");
                }
                try {
                    this.setObjectNameCode(this.makeNameCode(this.nameAtt.trim()));
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
            } else if (string == "as") {
                this.asAtt = attributeCollection.getValue(n);
            } else if (string == "override") {
                this.overrideAtt = attributeCollection.getValue(n).trim();
                if (this.overrideAtt.equals("yes")) {
                    this.override = true;
                } else if (this.overrideAtt.equals("no")) {
                    this.override = false;
                } else {
                    this.compileError("override must be 'yes' or 'no'");
                }
            } else if (string == "{http://saxon.sf.net/}memo-function") {
                String string2 = attributeCollection.getValue(n).trim();
                if (string2.equals("yes")) {
                    this.memoFunction = true;
                } else if (string2.equals("no")) {
                    this.memoFunction = false;
                } else {
                    this.compileError("saxon:memo-function must be 'yes' or 'no'");
                }
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
        }
        this.resultType = this.asAtt == null ? SequenceType.ANY_SEQUENCE : this.makeSequenceType(this.asAtt);
        this.functionName = this.nameAtt;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public boolean isOverriding() {
        return this.override;
    }

    public void fixupReferences() throws TransformerConfigurationException {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            ((UserFunctionCall)iterator.next()).setStaticType(this.resultType);
        }
        super.fixupReferences();
    }

    public void validate() throws TransformerConfigurationException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        this.getNumberOfArguments();
        XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
        List list = xSLStylesheet.getTopLevel();
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (e instanceof XSLFunction && e != this && ((XSLFunction)e).getFunctionFingerprint() == this.getFunctionFingerprint() && ((XSLFunction)e).getNumberOfArguments() == this.numberOfArguments && ((XSLFunction)e).getPrecedence() == this.getPrecedence()) {
                this.compileError("Duplicate function declaration");
            }
            --n;
        }
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        this.compileAsExpression(executable);
        return null;
    }

    private void compileAsExpression(Executable executable) throws TransformerConfigurationException {
        Serializable serializable;
        Block block = new Block();
        this.compileChildren(executable, block, false);
        Block block2 = block;
        UserFunction userFunction = new UserFunction();
        userFunction.setBody(block2);
        userFunction.setFunctionNameCode(this.getObjectNameCode());
        userFunction.setArgumentTypes(this.getArgumentTypes());
        userFunction.setResultType(this.getResultType());
        userFunction.setLineNumber(this.getLineNumber());
        userFunction.setSystemId(this.getSystemId());
        userFunction.setStackFrameMap(this.stackFrameMap);
        userFunction.setMemoFunction(this.memoFunction);
        userFunction.setExecutable(executable);
        Object object = block2;
        try {
            object = block2.simplify(this.staticContext).analyze(this.staticContext, null);
            if (this.resultType != null) {
                serializable = new RoleLocator(5, this.functionName, 0);
                object = TypeChecker.staticTypeCheck((Expression)object, this.resultType, false, (RoleLocator)serializable, this.getStaticContext());
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        if (this.getConfiguration().getTraceListener() != null) {
            serializable = new TraceInstruction((Expression)object, this);
            serializable.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            object = serializable;
        }
        this.allocateSlots((Expression)object);
        if (object != block2) {
            userFunction.setBody((Expression)object);
        }
        this.fixupInstruction(userFunction, this.getStaticContext());
        this.compiledFunction = userFunction;
    }

    private void fixupInstruction(UserFunction userFunction, StaticContext staticContext) throws TransformerConfigurationException {
        try {
            Iterator iterator = this.references.iterator();
            while (iterator.hasNext()) {
                ((UserFunctionCall)iterator.next()).setFunction(userFunction, staticContext);
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public int getFunctionFingerprint() {
        if (this.getObjectFingerprint() == -1) {
            try {
                this.prepareAttributes();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                return -1;
            }
        }
        return this.getObjectFingerprint();
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public int getNumberOfArguments() {
        if (this.numberOfArguments == -1) {
            Item item;
            this.numberOfArguments = 0;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            while ((item = axisIterator.next()) instanceof XSLParam) {
                ++this.numberOfArguments;
            }
            return this.numberOfArguments;
        }
        return this.numberOfArguments;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] sequenceTypeArray = new SequenceType[this.getNumberOfArguments()];
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLParam)) continue;
            sequenceTypeArray[n++] = ((XSLParam)nodeInfo).getRequiredType();
        }
        return sequenceTypeArray;
    }

    public UserFunction getCompiledFunction() {
        return this.compiledFunction;
    }

    public int getConstructType() {
        return 149;
    }
}

