/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.SchemaException;

public class XSLImportSchema
extends StyleElement {
    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        Object var3_3 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "schema-location") {
                string = attributeCollection.getValue(n).trim();
            } else if (string2 == "namespace") {
                string = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if ("".equals(var3_3)) {
            this.compileError("The zero-length string is not a valid namespace URI. For a schema with no namspace, omit the namespace attribute");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkEmpty();
        this.checkTopLevel(null);
    }

    public void readSchema() throws SchemaException, TransformerConfigurationException {
        try {
            String string;
            String string2 = this.getAttributeValue("schema-location");
            if (string2 != null) {
                string2 = string2.trim();
            }
            string = (string = this.getAttributeValue("namespace")) == null ? "" : string.trim();
            Configuration configuration = this.getPreparedStylesheet().getConfiguration();
            if (!configuration.isSchemaAware(10)) {
                this.compileError("To use xsl:import-schema, you need the schema-aware version of Saxon from http://www.saxonica.com/");
                return;
            }
            if (configuration.getSchema(string) == null) {
                if (string2 == null) {
                    this.compileError("The schema-location attribute is required (no schema for this namespace is known)");
                    return;
                }
                string = configuration.readSchema(this.getBaseURI(), string2, string);
            }
            this.getPrincipalStylesheet().addImportedSchema(string);
        }
        catch (SchemaException schemaException) {
            this.compileError(schemaException.getMessage());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.compileError(transformerConfigurationException.getMessage());
        }
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        return null;
    }
}

