/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.StaticError;

public abstract class XSLStringConstructor
extends StyleElement {
    protected Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void validate() throws TransformerConfigurationException {
        if (this.select != null && this.hasChildNodes()) {
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty");
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
        if (this.select == null) {
            if (nodeInfo == null) {
                this.select = StringValue.EMPTY_STRING;
            } else if (axisIterator.next() == null && nodeInfo.getNodeKind() == 3) {
                this.select = new StringValue(nodeInfo.getStringValue());
            }
        }
    }

    protected void compileContent(Executable executable, SimpleNodeConstructor simpleNodeConstructor) throws TransformerConfigurationException {
        if (this.select != null) {
            try {
                simpleNodeConstructor.setSelect(this.select);
            }
            catch (StaticError staticError) {
                this.compileError(staticError);
            }
        } else {
            this.compileChildren(executable, simpleNodeConstructor, true);
        }
    }
}

