/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.Err;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class ListType
extends SimpleType
implements MappingFunction {
    private SimpleType itemType = null;

    public ListType(NamePool namePool) {
        super.setNamePool(namePool);
    }

    public boolean isListType() {
        return true;
    }

    public SimpleType getItemType() {
        return this.itemType;
    }

    public boolean isDerivedFrom(String string, String string2, int n) {
        if ((n == 0 || (n & 8) != 0) && this.itemType.isDerivedFrom(string, string2, n)) {
            return true;
        }
        return super.isDerivedFrom(string, string2, n);
    }

    public void setItemType(SimpleType simpleType) throws SchemaException {
        this.itemType = simpleType;
    }

    public int relationshipTo(SchemaType schemaType) {
        if (schemaType instanceof AnyType) {
            return 2;
        }
        if (schemaType instanceof ListType) {
            return this.itemType.relationshipTo(((ListType)schemaType).getItemType());
        }
        if (schemaType instanceof SimpleType) {
            int n = this.itemType.relationshipTo(schemaType);
            switch (n) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            throw new IllegalStateException();
        }
        return 4;
    }

    public String applyWhitespaceNormalization(String string) {
        return NormalizeSpace.normalize(string);
    }

    public void validateContent(CharSequence charSequence, NamespaceResolver namespaceResolver) throws ValidationException {
        SimpleType simpleType = this.getItemType();
        StringTokenIterator stringTokenIterator = new StringTokenIterator(charSequence.toString());
        int n = 0;
        try {
            Object object;
            while ((object = (StringValue)stringTokenIterator.next()) != null) {
                simpleType.validateContent(((StringValue)object).getStringValue(), namespaceResolver);
                ++n;
            }
            object = this.getFacets();
            while (object.hasNext()) {
                boolean bl;
                Facet facet = (Facet)object.next();
                if (!facet.testLength(n)) {
                    throw new ValidationException("Length of list (" + n + ") violates " + facet.getName() + " facet " + Err.wrap(facet.getValue()));
                }
                if (!facet.appliesToWholeList() || (bl = facet.testAtomicValue(new StringValue(NormalizeSpace.normalize(charSequence.toString()))))) continue;
                throw new ValidationException("List " + Err.wrap(charSequence) + " violates the " + facet.getName() + " facet " + Err.wrap(facet.getValue()));
            }
        }
        catch (XPathException xPathException) {
            throw new ValidationException(xPathException);
        }
    }

    public SequenceIterator getTypedValue(CharSequence charSequence, NodeInfo nodeInfo) throws ValidationException {
        StringTokenIterator stringTokenIterator = new StringTokenIterator(charSequence.toString());
        Object[] objectArray = new Object[]{nodeInfo, this.getItemType()};
        return new MappingIterator(stringTokenIterator, this, null, objectArray);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        try {
            NodeInfo nodeInfo = (NodeInfo)((Object[])object)[0];
            AtomicType atomicType = (AtomicType)((Object[])object)[1];
            return atomicType.getTypedValue(item.getStringValue(), nodeInfo);
        }
        catch (ValidationException validationException) {
            return new DynamicError(validationException);
        }
    }
}

