/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class QNameValue
extends AtomicValue {
    private String prefix;
    private String uri;
    private String localPart;
    static /* synthetic */ Class class$net$sf$saxon$value$QNameValue;

    public QNameValue(NamePool namePool, int n) {
        this.prefix = namePool.getPrefix(n);
        this.uri = namePool.getURI(n);
        this.localPart = namePool.getLocalName(n);
    }

    public QNameValue(String string, String string2, String string3) throws XPathException {
        if (!XMLChar.isValidNCName(string3)) {
            DynamicError dynamicError = new DynamicError("Malformed local name in QName: '" + string3 + '\'');
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        this.prefix = string == null ? "" : string;
        this.uri = string2 == null ? "" : string2;
        this.localPart = string3;
    }

    public String getStringValue() {
        if ("".equals(this.prefix)) {
            return this.localPart;
        }
        return this.prefix + ':' + this.localPart;
    }

    public String getClarkName() {
        if ("".equals(this.uri)) {
            return this.localPart;
        }
        return '{' + this.uri + '}' + this.localPart;
    }

    public String getLocalName() {
        return this.localPart;
    }

    public String getNamespaceURI() {
        return "".equals(this.uri) ? null : this.uri;
    }

    public AtomicValue getComponent(int n) {
        if (n == 8) {
            return new StringValue(this.localPart);
        }
        if (n == 9) {
            return new StringValue(this.uri);
        }
        throw new UnsupportedOperationException("Component of QName must be URI or Local Name");
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        switch (n) {
            case 88: 
            case 530: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot convert QName to " + StandardNames.getDisplayName(n));
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public ItemType getItemType() {
        return Type.QNAME_TYPE;
    }

    public boolean equals(Object object) {
        QNameValue qNameValue = (QNameValue)object;
        return this.localPart.equals(qNameValue.localPart) && this.uri.equals(qNameValue.uri);
    }

    public int hashCode() {
        return this.localPart.hashCode() ^ this.uri.hashCode();
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$QNameValue == null ? (class$net$sf$saxon$value$QNameValue = QNameValue.class$("net.sf.saxon.value.QNameValue")) : class$net$sf$saxon$value$QNameValue)) {
            return this;
        }
        Object object = super.convertToJava(clazz, configuration, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of QName to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public String toString() {
        return "QName(\"" + this.uri + "\", \"" + this.localPart + ')';
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

