/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class TimeValue
extends CalendarValue
implements Comparable {
    static /* synthetic */ Class class$net$sf$saxon$value$TimeValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public TimeValue(GregorianCalendar gregorianCalendar, boolean bl) {
        this.calendar = gregorianCalendar;
        this.zoneSpecified = bl;
    }

    public TimeValue(CharSequence charSequence) throws XPathException {
        this.zoneSpecified = false;
        StringTokenizer stringTokenizer = new StringTokenizer(Value.trimWhitespace(charSequence).toString(), "-:.+Z", true);
        try {
            Object object;
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            String string = (String)stringTokenizer.nextElement();
            int n = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badTime("hour must be two digits");
            }
            if (n > 23) {
                this.badTime("hour is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            if (!":".equals(stringTokenizer.nextElement())) {
                this.badTime("wrong delimiter after hour");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n2 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badTime("minute must be two digits");
            }
            if (n2 > 59) {
                this.badTime("minute is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            if (!":".equals(stringTokenizer.nextElement())) {
                this.badTime("wrong delimiter after minute");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badTime("too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n3 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badTime("second must be two digits");
            }
            if (n > 61) {
                this.badTime("second is out of range");
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (stringTokenizer.hasMoreElements()) {
                if (n6 == 9) {
                    this.badTime("characters after the end");
                }
                if (".".equals(object = (String)stringTokenizer.nextElement())) {
                    if (n6 != 0) {
                        this.badTime("decimal separator occurs twice");
                    }
                    string = (String)stringTokenizer.nextElement();
                    double d = Double.parseDouble("." + string);
                    n4 = (int)Math.round(d * 1000.0);
                    n6 = 1;
                    continue;
                }
                if ("Z".equals(object)) {
                    if (n6 > 1) {
                        this.badTime("Z cannot occur here");
                    }
                    this.zoneSpecified = true;
                    n5 = 0;
                    n6 = 9;
                    continue;
                }
                if ("+".equals(object) || "-".equals(object)) {
                    if (n6 > 1) {
                        this.badTime((String)object + " cannot occur here");
                    }
                    n6 = 2;
                    this.zoneSpecified = true;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badTime("missing timezone");
                    }
                    if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                        this.badTime("timezone hour must be two digits");
                    }
                    if ((n5 = Integer.parseInt(string) * 60) > 840) {
                        this.badTime("timezone hour is out of range");
                    }
                    if (!"-".equals(object)) continue;
                    n5 = -n5;
                    continue;
                }
                if (":".equals(object)) {
                    if (n6 != 2) {
                        this.badTime("colon cannot occur here");
                    }
                    n6 = 9;
                    string = (String)stringTokenizer.nextElement();
                    int n7 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badTime("timezone minute must be two digits");
                    }
                    if (n7 > 59) {
                        this.badTime("timezone minute is out of range");
                    }
                    if (n5 < 0) {
                        n7 = -n7;
                    }
                    n5 += n7;
                    continue;
                }
                this.badTime("timezone format is incorrect");
            }
            if (n6 == 2 || n6 == 3) {
                this.badTime("timezone incomplete");
            }
            object = new SimpleTimeZone(n5 * 60000, "LLL");
            this.calendar = new GregorianCalendar((TimeZone)object);
            this.calendar.setLenient(false);
            this.calendar.set(2000, 0, 1, n, n2, n3);
            this.calendar.set(14, n4);
            this.calendar.set(15, n5 * 60000);
            this.calendar.set(16, 0);
            try {
                this.calendar.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.badTime("time components out of range");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badTime("non-numeric component");
        }
    }

    private void badTime(String string) throws XPathException {
        throw new DynamicError("Invalid time value (" + string + ")");
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        switch (n) {
            case 88: 
            case 520: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot convert time to " + StandardNames.getDisplayName(n));
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer(16);
        DateTimeValue.appendString(stringBuffer, this.calendar.get(11), 2);
        stringBuffer.append(':');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(12), 2);
        stringBuffer.append(':');
        DateTimeValue.appendSeconds(this.calendar, stringBuffer);
        if (this.zoneSpecified) {
            DateTimeValue.appendTimezone(this.calendar, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public DateTimeValue toDateTime() {
        return new DateTimeValue(this.calendar, this.zoneSpecified);
    }

    public ItemType getItemType() {
        return Type.TIME_TYPE;
    }

    public CalendarValue removeTimezone() throws XPathException {
        return (CalendarValue)new DateTimeValue(this.calendar, this.zoneSpecified).removeTimezone().convert(520, null);
    }

    public CalendarValue setTimezone(SecondsDurationValue secondsDurationValue) throws XPathException {
        return (CalendarValue)new DateTimeValue(this.calendar, this.zoneSpecified).setTimezone(secondsDurationValue).convert(520, null);
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$TimeValue == null ? (class$net$sf$saxon$value$TimeValue = TimeValue.class$("net.sf.saxon.value.TimeValue")) : class$net$sf$saxon$value$TimeValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = TimeValue.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = TimeValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, configuration, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of time to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 4: {
                return new IntegerValue(this.calendar.get(11));
            }
            case 5: {
                return new IntegerValue(this.calendar.get(12));
            }
            case 6: {
                StringBuffer stringBuffer = new StringBuffer(10);
                DateTimeValue.appendSeconds(this.calendar, stringBuffer);
                return new DecimalValue(stringBuffer.toString());
            }
            case 7: {
                if (this.zoneSpecified) {
                    int n2 = this.calendar.get(15) + this.calendar.get(16);
                    return SecondsDurationValue.fromMilliseconds(n2);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for time: " + n);
    }

    public int compareTo(Object object) {
        if (!(object instanceof TimeValue)) {
            throw new ClassCastException("Time values are not comparable to " + object.getClass());
        }
        TimeValue timeValue = (TimeValue)object;
        if (this.zoneSpecified == timeValue.zoneSpecified) {
            GregorianCalendar gregorianCalendar = timeValue.calendar;
            return this.calendar.getTime().compareTo(gregorianCalendar.getTime());
        }
        return new DateTimeValue(this.calendar, this.zoneSpecified).compareTo(new DateTimeValue(timeValue.calendar, timeValue.zoneSpecified));
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return new DateTimeValue(this.calendar, this.zoneSpecified).hashCode();
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            double d = durationValue.getLengthInSeconds();
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
            gregorianCalendar.add(13, (int)d);
            gregorianCalendar.add(14, (int)(d % 1.0 * 1000.0));
            return new TimeValue(gregorianCalendar, this.zoneSpecified);
        }
        DynamicError dynamicError = new DynamicError("Time+Duration arithmetic is supported only for xdt:dayTimeDuration");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public SecondsDurationValue subtract(CalendarValue calendarValue) throws XPathException {
        if (!(calendarValue instanceof TimeValue)) {
            DynamicError dynamicError = new DynamicError("First operand of '-' is a time, but the second is not");
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
        return super.subtract(calendarValue);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

