/*
 * Decompiled with CFR 0.152.
 */
package com.mybada.docbook.docbook_helper.gui;

import com.mybada.docbook.docbook_helper.model.FileSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileSelectorPanel
extends JPanel
implements FileSelector {
    private JTextField xmlSrcTextField;
    private JTextField xslSrcTextField;
    private JTextField outputTextField;
    private File srcXmlFile = null;
    private File srcXslFile = null;
    private File outputFile = null;
    private JButton xmlSrcFindButton = new JButton("...");
    private JButton xslSrcFindButton = new JButton("...");
    private JButton outputFindButton = new JButton("...");
    private String defaultStylePath = new String();

    public File getSrcXmlFile() {
        return this.srcXmlFile;
    }

    public File getSrcXslFile() {
        return this.srcXslFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public String getSrcXmlFileName() {
        return this.xmlSrcTextField.getText();
    }

    public String getSrcXslFileName() {
        return this.xslSrcTextField.getText();
    }

    public String getOutputFileName() {
        return this.outputTextField.getText();
    }

    public FileSelectorPanel() {
        this.makeUI();
        this.myInit();
    }

    private void myInit() {
        String styleHome;
        String docbookHome = System.getProperty("docbook.home");
        this.defaultStylePath = docbookHome == null ? "" : (styleHome = docbookHome + "\\stylesheet\\hangul-stylesheet");
    }

    private void makeUI() {
        this.setLayout(new GridLayout(3, 1));
        JPanel xmlSrcPanel = new JPanel(new BorderLayout());
        JPanel xslSrcPanel = new JPanel(new BorderLayout());
        JPanel outputPanel = new JPanel(new BorderLayout());
        JLabel xmlSrcLabel = new JLabel("XML source file:");
        JLabel xslSrcLabel = new JLabel("XSL source file:");
        JLabel outputLabel = new JLabel("Output file:");
        int textFieldCols = 30;
        this.xmlSrcTextField = new JTextField(textFieldCols);
        this.xslSrcTextField = new JTextField(textFieldCols);
        this.outputTextField = new JTextField(textFieldCols);
        this.xmlSrcFindButton.addActionListener(new OpenL());
        this.xslSrcFindButton.addActionListener(new OpenL());
        this.outputFindButton.addActionListener(new OpenL());
        JPanel xmlTextFieldButtonPanel = new JPanel();
        xmlTextFieldButtonPanel.add(this.xmlSrcTextField);
        xmlTextFieldButtonPanel.add(this.xmlSrcFindButton);
        JPanel xslTextFieldButtonPanel = new JPanel();
        xslTextFieldButtonPanel.add(this.xslSrcTextField);
        xslTextFieldButtonPanel.add(this.xslSrcFindButton);
        JPanel outputTextFieldButtonPanel = new JPanel();
        outputTextFieldButtonPanel.add(this.outputTextField);
        outputTextFieldButtonPanel.add(this.outputFindButton);
        xmlSrcPanel.add((Component)xmlSrcLabel, "North");
        xmlSrcPanel.add(xmlTextFieldButtonPanel);
        xslSrcPanel.add((Component)xslSrcLabel, "North");
        xslSrcPanel.add(xslTextFieldButtonPanel);
        outputPanel.add((Component)outputLabel, "North");
        outputPanel.add(outputTextFieldButtonPanel);
        this.add(xmlSrcPanel);
        this.add(xslSrcPanel);
        this.add(outputPanel);
    }

    class OpenL
    implements ActionListener {
        OpenL() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser c = new JFileChooser();
            Object src = e.getSource();
            if (src == FileSelectorPanel.this.xmlSrcFindButton) {
                c.setSelectedFile(FileSelectorPanel.this.srcXmlFile);
            } else if (src == FileSelectorPanel.this.xslSrcFindButton) {
                if (FileSelectorPanel.this.defaultStylePath.length() != 0) {
                    c.setCurrentDirectory(new File(FileSelectorPanel.this.defaultStylePath));
                } else {
                    c.setSelectedFile(FileSelectorPanel.this.srcXslFile);
                }
            } else if (src == FileSelectorPanel.this.outputFindButton) {
                c.setSelectedFile(FileSelectorPanel.this.outputFile);
            } else {
                return;
            }
            int rVal = c.showOpenDialog(FileSelectorPanel.this);
            if (rVal == 0) {
                JTextField sourceField = null;
                if (src == FileSelectorPanel.this.xmlSrcFindButton) {
                    sourceField = FileSelectorPanel.this.xmlSrcTextField;
                    FileSelectorPanel.this.srcXmlFile = c.getSelectedFile();
                } else if (src == FileSelectorPanel.this.xslSrcFindButton) {
                    sourceField = FileSelectorPanel.this.xslSrcTextField;
                    FileSelectorPanel.this.srcXslFile = c.getSelectedFile();
                } else {
                    sourceField = FileSelectorPanel.this.outputTextField;
                    FileSelectorPanel.this.outputFile = c.getSelectedFile();
                }
                sourceField.setText(c.getSelectedFile().getPath());
            }
        }
    }
}

