<?php
rcs_id('$Id: pageinfo.php,v 1.2 2003/06/21 12:11:26 gryu Exp $');
require_once('lib/Template.php');

global $datetimeformat;

// Display the internal structure of a page.
$pagename = $request->getArg('pagename');
$page = $dbi->getPage($pagename);

//gryu+
$rows[] = <<<_HTML_
<tr>
	<th width="5%"></th>
	<th width="5%"></th>
	<th width="5%"></th>
	<th width="25%">Ͻ</th>
	<th>ۼ  </th>
</tr>
_HTML_;
//+gryu
/*gryu-
$rows[] = Element('tr',
                  "\n"
                  . Element('th', '') . "\n"
                  . Element('th', '') . "\n"
                  . Element('th', '') . "\n"
                  . Element('th', 'Ͻ') . "\n"
                  . Element('th', 'ۼ  ') . "\n"
                  );
-gryu*/

// Get all versions of a page, then iterate over them to make version list
$iter = $page->getAllRevisions();
$i = 0;
$last_author_id = false;

function bold_if($cond, $text) {
    return (bool)$cond ? '<b>'.$text.'</b>' : $text; //gryu*
}


while ($rev = $iter->next()) {
    $version = $rev->getVersion();
    $cols = array();
    $is_major_edit = ! $rev->get('is_minor_edit');
    
    $cols[] = Element('td', array('align' => 'right'),
                      Element('a', array('href'
                                          => WikiURL($pagename,
                                                     array('version' => $version))),
                              bold_if($is_major_edit, $version)));
    

    $cols[] = Element('td', array('align' => 'center'),
                      QElement('input', array('type' => 'radio',
                                              'name' => 'version',
                                              'value' => $version,
                                              'checked' => $i == 0)));
    
    $cols[] = Element('td', array('align' => 'center'),
                      QElement('input', array('type' => 'radio',
                                              'name' => 'previous',
                                              'value' => $version,
                                              'checked' => $i++ == 1)));
    
    $cols[] = QElement('td', array('align' => 'right'),
                       strftime($datetimeformat, $rev->get('mtime'))
                       . " "); //gryu* "\xa0"

    
//gryu-    $cols[] = Element('td', bold_if($is_major_edit, $rev->get('summary')));
    
    $author_id = $rev->get('author_id');
//gryu+
	$author = $rev->get('author');
    if (preg_match("/^(?<![0-9A-Za-z])([A-Z][a-z]+){2,}(?![0-9A-Za-z])\$/", $author))
		$author	= LinkWikiWord($author);
	elseif (preg_match("/(\[\s*)(.+?)(\s*\])/",	$author, $tmp_match)) //gryu+
		$author	= LinkWikiWord(htmlspecialchars($tmp_match[2])); //gryu+
	else
		$author	= htmlspecialchars($author);
//+gryu		
    $cols[] = '<td>' . bold_if($author_id !== $last_author_id,
          $author) . '...'. bold_if($is_major_edit, htmlspecialchars($rev->get('summary'))). "</td>\n";
    $last_author_id = $author_id;
    $rows[] = Element('tr', "\n" . join("\n", $cols) . "\n");
}

$table = "\n"
         . '<table class="recent" cellspacing="10">'. join("\n", $rows) . "</table>\n" //gryu*
         . Element('input', array('type' => 'hidden',
                                  'name' => 'action',
                                  'value' => 'diff')) . "\n"
         . Element('input', array('type' => 'submit', 'value' => 'Run Diff')) . "\n";

$formargs['action'] = USE_PATH_INFO ? WikiURL($pagename) : SCRIPT_NAME;
$formargs['method'] = 'post';

$html = Element('p',
                LinkExistingWikiWord($pagename) . '    ');
$html .= Element('form', $formargs, $table);

echo GeneratePage('MESSAGE', $html, ' : ' . $pagename);


// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
?>
