<?
ini_set('include_path', '../../');
require "lib/prepend.php";
include_once "mockobjects.php";
require "lib/stdlib.php";
include_once "lib/new_transform.php";
include_once "utils.php";

class HtmlOutputTest extends TestCase
{
	function setUp()
	{
		$aDocInfo  =  array ( 
				'TopLevelName' => 'article', 
				'IncludeXmlDeclaration'=>true,
				'IncludeDtdDeclaration'=>false,
				'FirstSection' => 'section');

		$this->TopLevelElementName = $aDocInfo['TopLevelName'];
	 	$this->IncludeXmlDeclaration = $aDocInfo['IncludeXmlDeclaration'];
	 	$this->IncludeDtdDeclaration = $aDocInfo['IncludeDtdDeclaration'];
	 	$this->DtdPath = '';

	 	$this->Transform = new WikiToHtmlTransform;
	 	$this->Transform->Params['FirstSectionName'] = $aDocInfo['FirstSection'];
	 	$this->Transform->Params['IndentChar'] = "\t";
		$this->Transform->Params['indent'] = '';
		$this->Transform->Params['Info'] = '';
		$this->Transform->Params['TopLevelTitle'] = '';
		$this->Transform->Params['FirstSectionState'] = 'notstarted';
		$this->Transform->registerInline('w2h_inline_emphasis');
		$this->Transform->registerInline('w2h_inline_quote');			
		$this->Transform->registerInline('w2h_inline_general_inline');
		$this->Transform->registerInline('w2h_inline_doubleBracket');
		$this->Transform->registerInline('w2h_inline_bracketlinks');
		$this->Transform->registerInline('w2h_inline_rawurl');
		$this->Transform->registerInline('w2h_inline_wikilinks');
		
		$this->Transform->register('!', 'w2h_block_section');
		$this->Transform->register('_', 'w2h_block_section');		
		$this->Transform->register('*', 'w2h_block_itemizedlist');
		$this->Transform->register('#', 'w2h_block_orderedlist');
		$this->Transform->register(';', 'w2h_block_variablelist');		
		$this->Transform->register(' ', 'w2h_block_preformat1');
		$this->Transform->register('{', 'w2h_block_preformat2');
		$this->Transform->register('<', 'w2h_block_verbatim');
		$this->Transform->register('|', 'w2h_block_table');
		$this->Transform->register('(', 'w2h_block_general_start');
		$this->Transform->register(')', 'w2h_block_general_end');
		$this->Transform->register('%', 'w2h_block_ignore');
		$this->Transform->register('@', 'w2h_metadata');		

	}

	function transform($raw_data)
	{
		 $lines = preg_split('/[ \t\r]*\n/', $raw_data);
		return  $this->Transform->do_transform('', $lines) ;
	}

	function test_para()
	{
		$lines=
"1111";
		$expected = rn2n(
"<p>1111
</p>
");
		$this->assertEquals($expected, $this->transform($lines) );
	}

	function test_programlisting()
	{
		$lines=
"
 hello               world

    <<ee>>
";
		$expected = rn2n(
"<pre>
 hello               world
</pre>
<pre>
    &lt;&lt;ee&gt;&gt;
</pre>
");

		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_preformatted()
	{
		$lines=
"{{{
hello               world
    <<ee>>

}}}
";
		$expected = rn2n(
"<pre>
hello               world
    &lt;&lt;ee&gt;&gt;

</pre>
");

		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_emphasis()
	{
		$lines="hello '''world'''!";
		$expected = rn2n(
"<p>hello <em>world</em>!
</p>
");
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_emphasis2()
	{
		$lines="'''hello''' '''world'''!";
		$expected = rn2n(
"<p><em>hello</em> <em>world</em>!
</p>
");
		$this->assertEquals($expected, $this->transform($lines));
	}
	function test_quote()
	{
		$lines="hello ''world''!";
		$expected = rn2n(
"<p>hello &quot;world&quot;!
</p>
");
		$this->assertEquals($expected, $this->transform($lines));
	}

        function test_quote2()
        {
		$lines="''hello'' ''world''!";
		$expected = rn2n(
"<p>&quot;hello&quot; &quot;world&quot;!
</p>
");

		$this->assertEquals($expected, $this->transform($lines));
        } 
        
	function test_emphasis_quote()
	{
		$lines = "hello ''world'' '''world'''";
		$expected = rn2n(
"<p>hello <quote>world</quote> <emp>world</emp>
</p>
");
	}

	function test_itemizedlist_simple()
	{
		$lines = 
"* 1
* 2
* 3
";
		$expected = rn2n(
"<ul>
<li>1
</li>
<li>2
</li>
<li>3
</li>
</ul>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_itemizedlist_2()
	{
		$lines = 
"* 1
** 1.1
*** 1.1.1
";
		$expected = rn2n(
"<ul>
<li>1
	<ul>
	<li>1.1
		<ul>
		<li>1.1.1
		</li>
		</ul>
	</li>
	</ul>
</li>
</ul>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_itemizedlist_3()
	{
		$lines = 
"* 1
** 1.1
*** 1.1.1
* 2
** 2.1
";
		$expected = rn2n(
"<ul>
<li>1
	<ul>
	<li>1.1
		<ul>
		<li>1.1.1
		</li>
		</ul>
	</li>
	</ul>
</li>
<li>2
	<ul>
	<li>2.1
	</li>
	</ul>
</li>
</ul>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}
	
	function test_orderedlist()
	{
		$lines = 
"# 1
## 1.1
## 1.2
# 2
## 2.1
";
		$expected = rn2n(
"<ol>
<li>1
	<ol>
	<li>1.1
	</li>
	<li>1.2
	</li>
	</ol>
</li>
<li>2
	<ol>
	<li>2.1
	</li>
	</ol>
</li>
</ol>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}


	function test_mixedlist()
	{
		$lines = 
"# 1
#* 1.1
#* 1.2
# 2
## 2.1
";
		$expected = rn2n(
"<ol>
<li>1
	<ul>
	<li>1.1
	</li>
	<li>1.2
	</li>
	</ul>
</li>
<li>2
	<ol>
	<li>2.1
	</li>
	</ol>
</li>
</ol>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_variablelist()
	{
		$lines = 
"; term1 : def1
; term2 : def2
ddd";
		$expected = rn2n(
"<dl>
<dt>term1 </dt>
<dd><p>def1 </p>
</dd>
<dt>term2 </dt>
<dd><p>def2 </p>
</dd>
</dl>
<p>ddd
</p>
"
		);
		$this->assertEquals($expected, $this->transform($lines));
	}
	
	function test_ulink()
	{
		$lines = 
"[linktext|linktarget] http://kldp.net/ [linktarget]";
		$expected = rn2n(
'<p><a href="linktarget" class="named-wiki">linktext</a> <a href="http://kldp.net/">http://kldp.net/</a> <a href="linktarget" class="wiki">linktarget</a>
</p>
');
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_rawurl()
	{
		$lines = 
"http://a.com/  http://hello.com/html.html";
		$expected = rn2n(
'<p><a href="http://a.com/">http://a.com/</a>  <a href="http://hello.com/html.html">http://hello.com/html.html</a>
</p>
');
		$this->assertEquals($expected, $this->transform($lines));
	}	
	function test_wikinames()
	{
		$lines = "HelloWorld from UnKnown";
		$expected = rn2n(
'<p><a href="HelloWorld" class="wiki">HelloWorld</a> from <span class="wikiunknown"><a href="UnKnown?action=edit">?</a><u>UnKnown</u></span>
</p>
');
		$this->assertEquals($expected, $this->transform($lines));
	}
	
	function test_link()
	{
		$lines =" ũ [#ID] Ǵ [ũؽƮ | #ID] Դϴ.";
		$expected = rn2n(
'<p> ũ <a href="#ID">ID</a> Ǵ <a href="#ID">ũؽƮ</a> Դϴ.
</p>
');
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_inlinemediaobject()
	{
		$lines = "ζ [image.png] [image.gif]";
		$expected = rn2n(
"<para>ζ <inlinemediaobject><imageobject><imagedata fileref=\"image.png\" /></imageobject></inlinemediaobject> <inlinemediaobject><imageobject><imagedata fileref=\"image.gif\" /></imageobject></inlinemediaobject>
</para>
");
	}

	function test_simpleinline()
	{
		$lines = "{{keycap F1}}  {{term ȳ}}";
		$expected = rn2n(
'<p><span class="keycap">F1</span>  <span class="term">ȳ</span>
</p>
');
		$this->assertEquals($expected, $this->transform($lines));
	}	

	function test_sections()
	{
		$lines ="!!! 
...
!!! 
...()...
!! ܿ 1
...()...
! Ҵܿ 1
...()...
! Ҵܿ 1
...()...
_!  
_!!  
_!!!   
!!! 
...()...";
	$expected = rn2n(
'
<h2></h2>

<p>...
</p>

<h2></h2>

<p>...()...
	</p>

	<h3>ܿ 1</h3>

	<p>...()...
		</p>

		<h4>Ҵܿ 1</h4>

		<p>...()...
		</p>

		<h4>Ҵܿ 1</h4>

		<p>...()...
			</p>

			<h5> </h5>


				<h6> </h6>


					<h7>  </h7>


<h2></h2>

<p>...()...
</p>
');	
		$this->assertEquals($expected, $this->transform($lines));
	}

	function test_comment()
	{
		$lines = '@// ּ';
		$expected = rn2n(
'<div class="comment">ּ</div>
');
		$this->assertEquals($expected, $this->transform($lines));
	}
	
	function test_bracketlinks()
	{
		$lines = '[], [ | http://www.www.www], [HelloWorld]';
		$expected = rn2n(
'<p><a href="%C7%EF%B7%CE" class="wiki"></a>, <a href="http%3A%2F%2Fwww.www.www" class="named-wiki"></a>, <a href="HelloWorld" class="wiki">HelloWorld</a>
</p>
');
		$this->assertEquals($expected, $this->transform($lines));
	}
}
?>