/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public final class AppendExpression
extends BinaryExpression {
    public AppendExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public final ItemType getItemType() {
        ItemType itemType = this.operand0.getItemType();
        ItemType itemType2 = this.operand1.getItemType();
        return Type.getCommonSuperType(itemType, itemType2);
    }

    public final int computeCardinality() {
        int n = this.operand0.getCardinality();
        int n2 = this.operand1.getCardinality();
        if (this.operand0 instanceof EmptySequence) {
            return n2;
        }
        if (this.operand1 instanceof EmptySequence) {
            return n;
        }
        if ((n & 0x100) != 0 && (n2 & 0x100) != 0) {
            return 1792;
        }
        return 1536;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand0 = this.operand0.simplify(staticContext);
        this.operand1 = this.operand1.simplify(staticContext);
        if (this.operand0 instanceof EmptySequence) {
            return this.operand1;
        }
        if (this.operand1 instanceof EmptySequence) {
            return this.operand0;
        }
        if (this.isAtomicSequence()) {
            try {
                return new SequenceExtent(this.iterate(null));
            }
            catch (XPathException xPathException) {
                throw new StaticError(xPathException);
            }
        }
        if (this.operand0 instanceof Value && this.operand1 instanceof AppendExpression && ((AppendExpression)this.operand1).operand0 instanceof Value) {
            return new AppendExpression(new AppendExpression(this.operand0, this.operator, ((AppendExpression)this.operand1).operand0), this.operator, ((AppendExpression)this.operand1).operand1).simplify(staticContext);
        }
        return this;
    }

    private boolean isAtomicSequence() {
        return this.isAtomic(this.operand0) && this.isAtomic(this.operand1);
    }

    private boolean isAtomic(Expression expression) {
        return expression instanceof AtomicValue || expression instanceof SequenceExtent;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return new AppendIterator(this.operand0.iterate(xPathContext), this.operand1, xPathContext);
    }

    public static class AppendIterator
    implements SequenceIterator {
        private SequenceIterator first;
        private Expression second;
        private XPathContext context;
        private SequenceIterator currentIterator;

        public AppendIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext) {
            this.first = sequenceIterator;
            this.second = expression;
            this.context = xPathContext;
            this.currentIterator = sequenceIterator;
        }

        public Item next() throws XPathException {
            Item item = this.currentIterator.next();
            if (item == null && this.currentIterator == this.first) {
                this.currentIterator = this.second.iterate(this.context);
                return this.currentIterator.next();
            }
            return item;
        }

        public Item current() {
            return this.currentIterator.current();
        }

        public int position() {
            if (this.currentIterator == this.first) {
                return this.first.position();
            }
            return this.first.position() + this.currentIterator.position();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new AppendIterator(this.first.getAnother(), this.second, this.context);
        }
    }
}

