/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class CastAsQName
extends ComputedExpression {
    private Expression input;
    private NamespaceResolver nsContext;

    public CastAsQName(Expression expression) {
        this.input = expression;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.nsContext = staticContext.getNamespaceResolver();
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        return super.promote(promotionOffer);
    }

    public int computeCardinality() {
        return 512;
    }

    public ItemType getItemType() {
        return Type.QNAME_TYPE;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.input);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.input.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        StringValue stringValue = (StringValue)atomicValue.getPrimitiveValue();
        try {
            String[] stringArray = Name.getQNameParts(stringValue.getStringValue());
            String string = this.nsContext.getURIForPrefix(stringArray[0], true);
            if (string == null) {
                DynamicError dynamicError = new DynamicError("Prefix '" + stringArray[0] + "' has not been declared");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            return new QNameValue(stringArray[0], string, stringArray[1]);
        }
        catch (QNameException qNameException) {
            DynamicError dynamicError = new DynamicError(qNameException);
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "cast as QName");
        this.input.display(n + 1, namePool, printStream);
    }
}

