/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.XPathException;

public class Choose
extends Instruction {
    private Expression[] conditions;
    private Expression[] actions;

    public Choose(Expression[] expressionArray, Expression[] expressionArray2) {
        this.conditions = expressionArray;
        this.actions = expressionArray2;
    }

    public int getInstructionNameCode() {
        return this.conditions.length == 1 ? 150 : 135;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        int n = 0;
        while (n < this.conditions.length) {
            this.conditions[n] = this.conditions[n].simplify(staticContext);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.actions.length) {
            this.actions[n2] = this.actions[n2].simplify(staticContext);
            ++n2;
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        int n = 0;
        while (n < this.conditions.length) {
            this.conditions[n] = this.conditions[n].analyze(staticContext, itemType);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.actions.length) {
            this.actions[n2] = this.actions[n2].analyze(staticContext, itemType);
            ++n2;
        }
        return this;
    }

    public ItemType getItemType() {
        ItemType itemType = this.actions[0].getItemType();
        int n = 1;
        while (n < this.actions.length) {
            itemType = Type.getCommonSuperType(itemType, this.actions[n].getItemType());
            ++n;
        }
        return itemType;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(this.conditions.length + this.actions.length);
        int n = 0;
        while (n < this.conditions.length) {
            arrayList.add(this.conditions[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.actions.length) {
            arrayList.add(this.actions[n2]);
            ++n2;
        }
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        int n = 0;
        while (n < this.conditions.length) {
            this.conditions[n].promote(promotionOffer);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.actions.length) {
            this.actions[n2].promote(promotionOffer);
            ++n2;
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        int n2 = 0;
        while (n2 < this.conditions.length) {
            printStream.println(ExpressionTool.indent(n) + (n2 == 0 ? "if" : "else if"));
            this.conditions[n2].display(n + 1, namePool, printStream);
            printStream.println(ExpressionTool.indent(n) + "then");
            this.actions[n2].display(n + 1, namePool, printStream);
            ++n2;
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        int n = 0;
        while (n < this.conditions.length) {
            if (this.conditions[n].effectiveBooleanValue(xPathContext)) {
                if (this.actions[n] instanceof Instruction) {
                    return ((Instruction)this.actions[n]).processLeavingTail(xPathContext);
                }
                this.actions[n].process(xPathContext);
                return null;
            }
            ++n;
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        int n = 0;
        while (n < this.conditions.length) {
            if (this.conditions[n].effectiveBooleanValue(xPathContext)) {
                return this.actions[n].evaluateItem(xPathContext);
            }
            ++n;
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        int n = 0;
        while (n < this.conditions.length) {
            if (this.conditions[n].effectiveBooleanValue(xPathContext)) {
                return this.actions[n].iterate(xPathContext);
            }
            ++n;
        }
        return EmptyIterator.getInstance();
    }
}

