/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.GroupAdjacentIterator;
import net.sf.saxon.sort.GroupByIterator;
import net.sf.saxon.sort.GroupEndingIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.GroupStartingIterator;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedGroupIterator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class ForEachGroup
extends Instruction
implements MappingFunction {
    public static final int GROUP_BY = 0;
    public static final int GROUP_ADJACENT = 1;
    public static final int GROUP_STARTING = 2;
    public static final int GROUP_ENDING = 3;
    private Expression select;
    private Expression action;
    private byte algorithm;
    private Object key;
    private Comparator collator = null;
    private SortKeyDefinition[] sortKeys = null;

    public ForEachGroup(Expression expression, Expression expression2, byte by, Object object, Comparator comparator, SortKeyDefinition[] sortKeyDefinitionArray) {
        this.select = expression;
        this.action = expression2;
        this.algorithm = by;
        this.key = object;
        this.collator = comparator;
        this.sortKeys = sortKeyDefinitionArray;
    }

    public int getInstructionNameCode() {
        return 148;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        this.action = this.action.simplify(staticContext);
        if (this.key instanceof Expression) {
            this.key = ((Expression)this.key).simplify(staticContext);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.select = this.select.analyze(staticContext, itemType);
        this.action = this.action.analyze(staticContext, this.select.getItemType());
        if (this.key instanceof Expression) {
            this.key = ((Expression)this.key).analyze(staticContext, this.select.getItemType());
        }
        return this;
    }

    public ItemType getItemType() {
        return this.action.getItemType();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.select.promote(promotionOffer);
        this.action = this.action.promote(promotionOffer);
        if (this.key instanceof Expression) {
            this.key = ((Expression)this.key).promote(promotionOffer);
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(this.select);
        arrayList.add(this.action);
        if (this.key instanceof Expression) {
            arrayList.add(this.key);
        }
        if (this.sortKeys != null) {
            int n = 0;
            while (n < this.sortKeys.length) {
                arrayList.add(this.sortKeys[n].getSortKey());
                Expression expression = this.sortKeys[n].getOrder();
                if (expression != null && !(expression instanceof Value)) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[n].getCaseOrder()) != null && !(expression instanceof Value)) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[n].getDataTypeExpression()) != null && !(expression instanceof Value)) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[n].getLanguage()) != null && !(expression instanceof Value)) {
                    arrayList.add(expression);
                }
                ++n;
            }
        }
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        GroupIterator groupIterator = this.getGroupIterator(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(groupIterator);
        xPathContextMajor.setCurrentGroupIterator(groupIterator);
        xPathContextMajor.setCurrentTemplate(null);
        if (controller.isTracing()) {
            Item item;
            TraceListener traceListener = controller.getTraceListener();
            while ((item = groupIterator.next()) != null) {
                traceListener.startCurrentItem(item);
                this.action.process(xPathContextMajor);
                traceListener.endCurrentItem(item);
            }
        } else {
            Item item;
            while ((item = groupIterator.next()) != null) {
                this.action.process(xPathContextMajor);
            }
        }
        return null;
    }

    private GroupIterator getGroupIterator(XPathContext xPathContext) throws XPathException {
        GroupIterator groupIterator;
        FixedSortKeyDefinition[] fixedSortKeyDefinitionArray;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        switch (this.algorithm) {
            case 0: {
                fixedSortKeyDefinitionArray = xPathContext.newMinorContext();
                fixedSortKeyDefinitionArray.setOrigin(this);
                fixedSortKeyDefinitionArray.setCurrentIterator(sequenceIterator);
                groupIterator = new GroupByIterator(sequenceIterator, (Expression)this.key, (XPathContext)fixedSortKeyDefinitionArray, this.collator);
                break;
            }
            case 1: {
                fixedSortKeyDefinitionArray = xPathContext.newMinorContext();
                fixedSortKeyDefinitionArray.setOrigin(this);
                fixedSortKeyDefinitionArray.setCurrentIterator(sequenceIterator);
                groupIterator = new GroupAdjacentIterator(sequenceIterator, (Expression)this.key, (XPathContext)fixedSortKeyDefinitionArray, this.collator);
                break;
            }
            case 2: {
                groupIterator = new GroupStartingIterator(sequenceIterator, (Pattern)this.key, xPathContext);
                break;
            }
            case 3: {
                groupIterator = new GroupEndingIterator(sequenceIterator, (Pattern)this.key, xPathContext);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (this.sortKeys != null) {
            fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[this.sortKeys.length];
            XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
            int n = 0;
            while (n < this.sortKeys.length) {
                fixedSortKeyDefinitionArray[n] = this.sortKeys[n].reduce(xPathContextMinor);
                ++n;
            }
            groupIterator = new SortedGroupIterator(xPathContextMinor, groupIterator, fixedSortKeyDefinitionArray, this);
        }
        return groupIterator;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.getGroupIterator(xPathContext);
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        xPathContextMinor.setCurrentIterator(sequenceIterator);
        sequenceIterator = new MappingIterator(sequenceIterator, this, xPathContextMinor, null);
        return sequenceIterator;
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        return this.action.iterate(xPathContext);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "for-each-group");
        printStream.println(ExpressionTool.indent(n) + "select");
        this.select.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, namePool, printStream);
    }
}

