/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ApplyImports;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class NextMatch
extends ApplyImports {
    public int getInstructionNameCode() {
        return 159;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        ParameterSet parameterSet = Instruction.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = Instruction.assembleTunnelParams(xPathContext, this.tunnelParams);
        Template template = xPathContext.getCurrentTemplate();
        if (template == null) {
            DynamicError dynamicError = new DynamicError("There is no current template rule");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XT0560");
            throw dynamicError;
        }
        Mode mode = xPathContext.getCurrentMode();
        if (xPathContext.getCurrentIterator() == null) {
            DynamicError dynamicError = new DynamicError("There is no context item");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XT0565");
            throw dynamicError;
        }
        Item item = xPathContext.getCurrentIterator().current();
        if (!(item instanceof NodeInfo)) {
            DynamicError dynamicError = new DynamicError("Cannot call xsl:next-match when context item is not a node");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XT0565");
            throw dynamicError;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        Template template2 = controller.getRuleManager().getNextMatchHandler(nodeInfo, mode, template, xPathContext);
        if (template2 == null) {
            ApplyTemplates.defaultAction(nodeInfo, parameterSet, parameterSet2, xPathContext);
        } else {
            XPathContextMajor xPathContextMajor = xPathContext.newContext();
            xPathContextMajor.setOrigin(this);
            xPathContextMajor.openStackFrame(template2.getStackFrameMap());
            xPathContextMajor.setLocalParameters(parameterSet);
            xPathContextMajor.setTunnelParameters(parameterSet2);
            template2.process(xPathContextMajor);
        }
        return null;
    }
}

