/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public abstract class SimpleNodeConstructor
extends InstructionWithChildren {
    protected Expression select = null;
    protected Expression separator = null;

    public void setSelect(Expression expression) throws StaticError {
        this.select = expression;
        this.adoptChildExpression(expression);
    }

    public final void setSeparator(Expression expression) {
        this.separator = expression;
        this.adoptChildExpression(expression);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        if (this.select != null) {
            this.select = this.select.simplify(staticContext);
        }
        if (this.separator != null) {
            this.separator = this.separator.simplify(staticContext);
        }
        return super.simplify(staticContext);
    }

    public abstract void typeCheck(StaticContext var1, ItemType var2) throws XPathException;

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.typeCheck(staticContext, itemType);
        String string = staticContext.getNamePool().getDisplayName(this.getInstructionNameCode());
        if (this.separator != null) {
            this.separator = this.separator.analyze(staticContext, itemType);
            RoleLocator roleLocator = new RoleLocator(4, string + "/separator", 0);
            this.separator = TypeChecker.staticTypeCheck(this.separator, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        }
        if (this.select != null) {
            this.select = this.select.analyze(staticContext, itemType);
            if (!Type.isSubType(this.select.getItemType(), Type.ANY_ATOMIC_TYPE)) {
                this.select = new Atomizer(this.select);
            }
            if (!Type.isSubType(this.select.getItemType(), Type.STRING_TYPE)) {
                this.select = new AtomicSequenceConverter(this.select, Type.STRING_TYPE);
            }
        } else {
            super.analyze(staticContext, itemType);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        if (this.children != null) {
            arrayList.addAll(Arrays.asList(this.children));
        }
        if (this.select != null && !(this.select instanceof StringValue)) {
            arrayList.add(this.select);
        }
        if (this.separator != null && !(this.separator instanceof StringValue)) {
            arrayList.add(this.separator);
        }
        return arrayList.iterator();
    }

    public CharSequence expandChildren(XPathContext xPathContext) throws XPathException {
        String string = " ";
        if (this.separator != null) {
            string = this.separator.evaluateAsString(xPathContext);
        }
        if (this.select != null) {
            if (this.select instanceof StringValue) {
                return ((StringValue)this.select).getStringValue();
            }
            return this.flatten(this.select.iterate(xPathContext), string);
        }
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        SequenceOutputter sequenceOutputter = new SequenceOutputter();
        sequenceOutputter.setConfiguration(controller.getConfiguration());
        sequenceOutputter.setDocumentLocator(this.getExecutable().getLocationMap());
        xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
        this.processChildren(xPathContextMinor);
        sequenceOutputter.close();
        return this.flatten(sequenceOutputter.getSequence().iterate(xPathContext), string);
    }

    private StringBuffer flatten(SequenceIterator sequenceIterator, String string) throws XPathException {
        Item item;
        StringBuffer stringBuffer = new StringBuffer(80);
        boolean bl = true;
        while ((item = sequenceIterator.next()) != null) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(item.getStringValue());
        }
        return stringBuffer;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string = this.select == null ? "" : this.select.evaluateAsString(xPathContext);
        string = this.checkContent(string, xPathContext);
        try {
            Orphan orphan = new Orphan(xPathContext.getController().getNamePool());
            orphan.setNodeKind((short)this.getItemType().getPrimitiveType());
            orphan.setStringValue(string);
            orphan.setNameCode(this.evaluateNameCode(xPathContext));
            return orphan;
        }
        catch (SkipInstructionException skipInstructionException) {
            return null;
        }
    }

    protected String checkContent(String string, XPathContext xPathContext) throws DynamicError {
        return string;
    }

    protected int evaluateNameCode(XPathContext xPathContext) throws XPathException, XPathException {
        return -1;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return SingletonIterator.makeIterator(this.evaluateItem(xPathContext));
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        if (this.select != null) {
            this.select.display(n, namePool, printStream);
        } else if (this.children.length == 0) {
            printStream.println(ExpressionTool.indent(n) + "empty content");
        } else {
            InstructionWithChildren.displayChildren(this.children, n + 1, namePool, printStream);
        }
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.select.promote(promotionOffer);
        }
        super.promoteInst(promotionOffer);
    }
}

