/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Err;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.XMLChar;

public abstract class Name {
    public static final boolean isQName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return XMLChar.isValidNCName(string);
        }
        if (n == 0 || n == string.length() - 1) {
            return false;
        }
        if (!XMLChar.isValidNCName(string.substring(0, n))) {
            return false;
        }
        return XMLChar.isValidNCName(string.substring(n + 1));
    }

    public static final String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static final String[] getQNameParts(CharSequence charSequence) throws QNameException {
        String[] stringArray = new String[2];
        int n = -1;
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            if (charSequence.charAt(n3) == ':') {
                n = n3;
            }
            ++n3;
        }
        if (n < 0) {
            stringArray[0] = "";
            stringArray[1] = charSequence.toString();
            if (!XMLChar.isValidNCName(charSequence)) {
                throw new QNameException("Invalid QName " + Err.wrap(charSequence));
            }
        } else {
            if (n == 0) {
                throw new QNameException("QName cannot start with colon: " + Err.wrap(charSequence));
            }
            if (n == n2 - 1) {
                throw new QNameException("QName cannot end with colon: " + Err.wrap(charSequence));
            }
            stringArray[0] = charSequence.subSequence(0, n).toString();
            stringArray[1] = charSequence.subSequence(n + 1, n2).toString();
            if (!XMLChar.isValidNCName(stringArray[1])) {
                throw new QNameException("Invalid QName local part " + Err.wrap(stringArray[1]));
            }
        }
        return stringArray;
    }
}

