/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public abstract class AttributeValueTemplate {
    private AttributeValueTemplate() {
    }

    public static Expression make(String string, int n, char c, int n2, StaticContext staticContext) throws XPathException {
        Object object;
        Object object2;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n3 = n;
        int n4 = string.length();
        while (n3 < n4) {
            int n5 = string.indexOf(c, n3);
            int n6 = string.indexOf("{", n3);
            int n7 = string.indexOf("{{", n3);
            int n8 = string.indexOf("}", n3);
            int n9 = string.indexOf("}}", n3);
            if (!(n6 >= 0 && n5 >= n6 || n8 >= 0 && n5 >= n8)) {
                AttributeValueTemplate.addStringComponent(arrayList, string, n3, n5);
                n3 = n5;
                break;
            }
            if (n6 >= 0 && n6 != n7 && n8 < n6) {
                object2 = new StaticError("Unmatched opening curly brace in attribute value template \"" + string.substring(0, n5) + "\"");
                ((XPathException)object2).setErrorCode("XT0350");
                throw object2;
            }
            if (n8 >= 0 && (n6 < 0 || n8 < n6)) {
                if (n8 != n9) {
                    object2 = new StaticError("Closing curly brace in attribute value template \"" + string.substring(0, n5) + "\" must be doubled");
                    ((XPathException)object2).setErrorCode("XT0360");
                    throw object2;
                }
                AttributeValueTemplate.addStringComponent(arrayList, string, n3, n8 + 1);
                n3 = n8 + 2;
                continue;
            }
            if (n7 >= 0 && n7 == n6) {
                AttributeValueTemplate.addStringComponent(arrayList, string, n3, n7 + 1);
                n3 = n7 + 2;
                continue;
            }
            if (n6 >= 0) {
                if (n6 > n3) {
                    AttributeValueTemplate.addStringComponent(arrayList, string, n3, n6);
                }
                object = new ExpressionParser();
                object2 = ((ExpressionParser)object).parse(string, n6 + 1, 115, n2, staticContext);
                object2 = object2.simplify(staticContext);
                n3 = ((ExpressionParser)object).getTokenizer().currentTokenStartOffset + 1;
                if (staticContext.isInBackwardsCompatibleMode()) {
                    arrayList.add(AttributeValueTemplate.makeFirstItem((Expression)object2));
                    continue;
                }
                arrayList.add(AttributeValueTemplate.makeStringJoin((Expression)object2, staticContext.getNamePool()));
                continue;
            }
            throw new IllegalStateException("Internal error parsing AVT");
        }
        if (arrayList.size() == 0) {
            return StringValue.EMPTY_STRING;
        }
        if (arrayList.size() == 1) {
            return ((Expression)arrayList.get(0)).simplify(staticContext);
        }
        object2 = (Concat)SystemFunction.makeSystemFunction("concat", staticContext.getNamePool());
        object = new Expression[arrayList.size()];
        arrayList.toArray((T[])object);
        ((FunctionCall)object2).setArguments((Expression[])object);
        ((ComputedExpression)object2).setLocationId(staticContext.getLocationMap().allocateLocationId(staticContext.getSystemId(), n2));
        return ((FunctionCall)object2).simplify(staticContext);
    }

    private static void addStringComponent(List list, String string, int n, int n2) {
        if (n < n2) {
            list.add(new StringValue(string.substring(n, n2)));
        }
    }

    public static Expression makeStringJoin(Expression expression, NamePool namePool) {
        expression = new Atomizer(expression);
        expression = new AtomicSequenceConverter(expression, Type.STRING_TYPE);
        StringJoin stringJoin = (StringJoin)SystemFunction.makeSystemFunction("string-join", namePool);
        Expression[] expressionArray = new Expression[]{expression, new StringValue(" ")};
        stringJoin.setArguments(expressionArray);
        if (expression instanceof ComputedExpression) {
            stringJoin.setLocationId(((ComputedExpression)expression).getLocationId());
        }
        return stringJoin;
    }

    public static Expression makeFirstItem(Expression expression) {
        if (!Type.isSubType(expression.getItemType(), Type.ANY_ATOMIC_TYPE)) {
            expression = new Atomizer(expression);
        }
        if (Cardinality.allowsMany(expression.getCardinality())) {
            expression = new FirstItemExpression(expression);
        }
        if (!Type.isSubType(expression.getItemType(), Type.STRING_TYPE)) {
            expression = new AtomicSequenceConverter(expression, Type.STRING_TYPE);
        }
        return expression;
    }
}

