/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Comparator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class ExpressionContext
implements StaticContext {
    private StyleElement element;
    private NamePool namePool;

    public ExpressionContext(StyleElement styleElement) {
        this.element = styleElement;
        this.namePool = styleElement.getTargetNamePool();
    }

    public Configuration getConfiguration() {
        return this.element.getPreparedStylesheet().getConfiguration();
    }

    public LocationMap getLocationMap() {
        return this.element.getPrincipalStylesheet().getLocationMap();
    }

    public void issueWarning(String string) {
        this.element.issueWarning(string);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public String getSystemId() {
        return this.element.getSystemId();
    }

    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    public String getBaseURI() {
        return this.element.getBaseURI();
    }

    public String getURIForPrefix(String string) throws XPathException {
        try {
            return this.element.getURIForPrefix(string, false);
        }
        catch (NamespaceException namespaceException) {
            throw new StaticError(namespaceException);
        }
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.element.makeNamespaceContext();
    }

    public int getFingerprint(String string, boolean bl) throws XPathException {
        String[] stringArray;
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new StaticError(qNameException.getMessage());
        }
        String string2 = stringArray[0];
        if (string2.equals("")) {
            String string3 = "";
            if (bl) {
                string3 = this.getURIForPrefix(string2);
            }
            return this.namePool.getFingerprint(string3, string);
        }
        String string4 = this.getURIForPrefix(string2);
        return this.namePool.getFingerprint(string4, stringArray[1]);
    }

    public VariableDeclaration bindVariable(int n) throws StaticError {
        return this.element.bindVariable(n);
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.element.getPrincipalStylesheet().getFunctionLibrary();
    }

    public boolean isElementAvailable(String string) throws XPathException {
        try {
            String[] stringArray = Name.getQNameParts(string);
            String string2 = this.getURIForPrefix(stringArray[0]);
            return this.element.getPreparedStylesheet().getStyleNodeFactory().isElementAvailable(string2, stringArray[1]);
        }
        catch (QNameException qNameException) {
            throw new StaticError("Invalid element name. " + qNameException.getMessage());
        }
    }

    public Comparator getCollation(String string) throws XPathException {
        return this.element.getPrincipalStylesheet().findCollation(string);
    }

    public String getDefaultCollationName() {
        return this.element.getPrincipalStylesheet().getDefaultCollationName();
    }

    public short getDefaultElementNamespace() {
        return this.element.getDefaultXPathNamespace();
    }

    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2004/07/xpath-functions";
    }

    public boolean isInBackwardsCompatibleMode() {
        return this.element.backwardsCompatibleModeIsEnabled();
    }

    public boolean isImportedSchema(String string) {
        return this.getXSLStylesheet().isImportedSchema(string);
    }

    public XSLStylesheet getXSLStylesheet() {
        return this.element.getPrincipalStylesheet();
    }

    public StyleElement getStyleElement() {
        return this.element;
    }
}

