/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.DeferredError;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.Text;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.instruct.TraceWrapper;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.tree.ElementWithAttributes;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;
import org.xml.sax.Locator;

public abstract class StyleElement
extends ElementWithAttributes
implements Locator,
Container,
InstructionInfo {
    protected short[] extensionNamespaces = null;
    private short[] excludedNamespaces = null;
    protected BigDecimal version = null;
    protected StaticContext staticContext = null;
    protected TransformerConfigurationException validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    private int lineNumber;
    private boolean explaining = false;
    private int objectNameCode = -1;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;

    public Executable getExecutable() {
        return this.getPrincipalStylesheet().getExecutable();
    }

    public NamePool getTargetNamePool() {
        return this.getPrincipalStylesheet().getTargetNamePool();
    }

    protected Configuration getConfiguration() {
        return this.getPreparedStylesheet().getConfiguration();
    }

    public StaticContext getStaticContext() {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this);
        }
        return this.staticContext;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public void substituteFor(StyleElement styleElement) {
        this.parent = styleElement.parent;
        this.attributeList = styleElement.attributeList;
        this.namespaceList = styleElement.namespaceList;
        this.nameCode = styleElement.nameCode;
        this.sequence = styleElement.sequence;
        this.extensionNamespaces = styleElement.extensionNamespaces;
        this.excludedNamespaces = styleElement.excludedNamespaces;
        this.version = styleElement.version;
        this.root = styleElement.root;
        this.staticContext = styleElement.staticContext;
        this.validationError = styleElement.validationError;
        this.reportingCircumstances = styleElement.reportingCircumstances;
        this.lineNumber = styleElement.lineNumber;
    }

    protected void setValidationError(TransformerException transformerException, int n) {
        this.validationError = transformerException instanceof TransformerConfigurationException ? (TransformerConfigurationException)transformerException : new TransformerConfigurationException(transformerException);
        this.reportingCircumstances = n;
    }

    public boolean isInstruction() {
        return false;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    protected ItemType getCommonChildItemType() {
        ItemType itemType = NoNodeTest.getInstance();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        do {
            NodeInfo nodeInfo;
            if ((nodeInfo = (NodeInfo)axisIterator.next()) == null) {
                return itemType;
            }
            if (nodeInfo instanceof StyleElement) {
                ItemType itemType2 = ((StyleElement)nodeInfo).getReturnedItemType();
                if (itemType2 == null) continue;
                itemType = Type.getCommonSuperType(itemType, itemType2);
                continue;
            }
            itemType = Type.getCommonSuperType(itemType, NodeKindTest.TEXT);
        } while (itemType != AnyItemType.getInstance());
        return itemType;
    }

    public void markTailCalls() {
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public boolean mayContainFallback() {
        return this.mayContainSequenceConstructor();
    }

    public XSLStylesheet getContainingStylesheet() {
        NodeInfo nodeInfo = this;
        while (!(nodeInfo instanceof XSLStylesheet)) {
            nodeInfo = nodeInfo.getParent();
        }
        return (XSLStylesheet)nodeInfo;
    }

    public int getPrecedence() {
        return this.getContainingStylesheet().getPrecedence();
    }

    public String getURIForPrefix(String string, boolean bl) throws NamespaceException {
        if ("".equals(string) && !bl) {
            return "";
        }
        short s = this.getURICodeForPrefix(string);
        return this.getNamePool().getURIFromURICode(s);
    }

    public final int makeNameCode(String string) throws XPathException, NamespaceException {
        String[] stringArray;
        NamePool namePool = this.getTargetNamePool();
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            throw new StaticError(qNameException.getMessage());
        }
        String string2 = stringArray[0];
        if ("".equals(string2)) {
            return namePool.allocate(string2, (short)0, string);
        }
        String string3 = this.getURIForPrefix(string2, false);
        if (NamespaceConstant.isReserved(string3)) {
            StaticError staticError = new StaticError("Namespace prefix " + string2 + " refers to a reserved namespace");
            staticError.setErrorCode("XT0080");
            throw staticError;
        }
        return namePool.allocate(string2, string3, stringArray[1]);
    }

    public NamespaceContext makeNamespaceContext() {
        int[] nArray = this.getNamespaceCodes();
        int[] nArray2 = new int[nArray.length];
        NamePool namePool = this.getNamePool();
        NamePool namePool2 = this.getTargetNamePool();
        int n = 0;
        while (n < nArray.length) {
            String string = namePool.getPrefixFromNamespaceCode(nArray[n]);
            String string2 = namePool.getURIFromNamespaceCode(nArray[n]);
            nArray2[n] = namePool2.allocateNamespaceCode(string, string2);
            ++n;
        }
        return new NamespaceContext(nArray2, namePool2);
    }

    public void processAllAttributes() throws TransformerConfigurationException {
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).processAllAttributes();
        }
        return;
    }

    public String getAttributeValue(String string) {
        int n = this.getNamePool().allocateClarkName(string);
        return this.getAttributeValue(n);
    }

    public final void processAttributes() throws TransformerConfigurationException {
        block3: {
            try {
                this.prepareAttributes();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                if (this.forwardsCompatibleModeIsEnabled()) {
                    this.setValidationError(transformerConfigurationException, 3);
                    break block3;
                }
                this.compileError(transformerConfigurationException);
            }
        }
    }

    protected void checkUnknownAttribute(int n) throws TransformerConfigurationException {
        String string = this.getNamePool().getURI(n);
        String string2 = this.getURI();
        String string3 = this.getNamePool().getClarkName(n);
        if (string3.equals("{http://saxon.sf.net/}explain")) {
            this.explaining = "yes".equals(this.getAttributeValue(n & 0xFFFFF));
        }
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        if (this.isInstruction() && string3.startsWith("{http://www.w3.org/1999/XSL/Transform") && !string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3.endsWith("}xpath-default-namespace") || string3.endsWith("}extension-element-prefixes") || string3.endsWith("}exclude-result-prefixes") || string3.endsWith("}version"))) {
            return;
        }
        if (string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3 == "xpath-default-namespace" || string3 == "extension-element-prefixes" || string3 == "exclude-result-prefixes" || string3 == "version")) {
            return;
        }
        if ("".equals(string) || "http://www.w3.org/1999/XSL/Transform".equals(string)) {
            this.compileError("Attribute {" + this.getNamePool().getDisplayName(n) + "} is not allowed on this element");
        }
    }

    public abstract void prepareAttributes() throws TransformerConfigurationException;

    protected StyleElement getLastChildInstruction() {
        StyleElement styleElement = null;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof StyleElement) {
                styleElement = (StyleElement)nodeInfo;
                continue;
            }
            styleElement = null;
        }
        return styleElement;
    }

    public Expression makeExpression(String string) throws TransformerConfigurationException {
        try {
            Expression expression = ExpressionTool.make(string, this.staticContext, 0, 0, this.getLineNumber());
            return expression;
        }
        catch (XPathException xPathException) {
            xPathException.setLocator(this);
            if (!this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(xPathException);
            } else if (xPathException.isTypeError()) {
                this.compileError(xPathException);
            }
            ErrorExpression errorExpression = new ErrorExpression(xPathException);
            errorExpression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            errorExpression.setParentExpression(this);
            return errorExpression;
        }
    }

    public Pattern makePattern(String string) throws TransformerConfigurationException {
        try {
            return Pattern.make(string, this.staticContext, this.getPrincipalStylesheet().getExecutable());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new NodeTestPattern(AnyNodeTest.getInstance());
        }
    }

    public Expression makeAttributeValueTemplate(String string) throws TransformerConfigurationException {
        try {
            return AttributeValueTemplate.make(string + '\u0000', 0, '\u0000', this.getLineNumber(), this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new StringValue(string);
        }
    }

    public SequenceType makeSequenceType(String string) throws TransformerConfigurationException {
        this.getStaticContext();
        try {
            ExpressionParser expressionParser = new ExpressionParser();
            return expressionParser.parseSequenceType(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return SequenceType.ANY_SEQUENCE;
        }
    }

    protected void processExtensionElementAttribute(String string) throws TransformerConfigurationException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n;
            }
            this.extensionNamespaces = new short[n];
            n = 0;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                if ("#default".equals(string3)) {
                    string3 = "";
                }
                try {
                    short s = this.getURICodeForPrefix(string3);
                    this.extensionNamespaces[n++] = s;
                }
                catch (NamespaceException namespaceException) {
                    this.extensionNamespaces = null;
                    this.compileError(namespaceException.getMessage());
                }
            }
        }
    }

    protected void processExcludedNamespaces(String string) throws TransformerConfigurationException {
        block10: {
            String string2 = this.getAttributeValue(string);
            if (string2 == null) break block10;
            if ("#all".equals(string2.trim())) {
                int[] nArray = this.getNamespaceCodes();
                this.excludedNamespaces = new short[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    this.excludedNamespaces[n] = (short)(nArray[n] & 0xFFFF);
                    ++n;
                }
            } else {
                int n = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n;
                }
                this.excludedNamespaces = new short[n];
                n = 0;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    if ("#default".equals(string3)) {
                        string3 = "";
                    } else if ("#all".equals(string3)) {
                        this.compileError("In exclude-result-prefixes, cannot mix #all with other values");
                    }
                    try {
                        short s = this.getURICodeForPrefix(string3);
                        this.excludedNamespaces[n++] = s;
                    }
                    catch (NamespaceException namespaceException) {
                        this.excludedNamespaces = null;
                        this.compileError(namespaceException.getMessage());
                    }
                }
            }
        }
    }

    protected void processVersionAttribute(String string) throws TransformerConfigurationException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            try {
                this.version = new DecimalValue(string2).getValue();
            }
            catch (XPathException xPathException) {
                throw new TransformerConfigurationException("The version attribute must be a decimal literal");
            }
        }
    }

    public BigDecimal getVersion() {
        if (this.version == null) {
            NodeInfo nodeInfo = (NodeInfo)((Object)this.getParentNode());
            this.version = nodeInfo instanceof StyleElement ? ((StyleElement)nodeInfo).getVersion() : new BigDecimal("2.0");
        }
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getVersion().compareTo(BigDecimal.valueOf(2L)) > 0;
    }

    public boolean backwardsCompatibleModeIsEnabled() {
        return this.getVersion().compareTo(BigDecimal.valueOf(2L)) < 0;
    }

    protected boolean definesExtensionElement(short s) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        int n = 0;
        while (n < this.extensionNamespaces.length) {
            if (this.extensionNamespaces[n] == s) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isExtensionNamespace(short s) {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExtensionElement(s)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(short s) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        int n = 0;
        while (n < this.excludedNamespaces.length) {
            if (this.excludedNamespaces[n] == s) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isExcludedNamespace(short s) {
        if (s == 2) {
            return true;
        }
        if (this.isExtensionNamespace(s)) {
            return true;
        }
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExcludedNamespace(s)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(String string) throws TransformerConfigurationException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            this.defaultXPathNamespace = string2;
        }
    }

    protected short getDefaultXPathNamespace() {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            String string = nodeInfo.defaultXPathNamespace;
            if (string != null) {
                return this.getTargetNamePool().allocateCodeForURI(string);
            }
            nodeInfo = nodeInfo.getParent();
        }
        return 0;
    }

    public SchemaType getSchemaType(String string) throws TransformerConfigurationException {
        try {
            String string2;
            int n;
            String[] stringArray = Name.getQNameParts(string);
            String string3 = stringArray[1];
            if ("".equals(stringArray[0])) {
                n = this.getDefaultXPathNamespace();
                string2 = this.getTargetNamePool().getURIFromURICode((short)n);
                this.nameCode = this.getTargetNamePool().allocate(stringArray[0], (short)n, string3);
            } else {
                string2 = this.getURIForPrefix(stringArray[0], false);
            }
            n = this.getTargetNamePool().allocate(stringArray[0], string2, string3);
            if (string2.equals("http://www.w3.org/2001/XMLSchema")) {
                SchemaType schemaType = BuiltInSchemaFactory.getSchemaType(StandardNames.getFingerprint(string2, string3));
                if (schemaType == null) {
                    this.compileError("Unknown built-in type " + string);
                    return null;
                }
                schemaType.setFingerprint(n & 0xFFFFF);
                return schemaType;
            }
            if (string2.equals("http://www.w3.org/2004/07/xpath-datatypes")) {
                ItemType itemType = Type.getBuiltInItemType(string2, string3);
                if (itemType == null) {
                    if ("untyped".equals(string3)) {
                        this.compileError("Cannot validate a node as 'untyped'");
                    } else {
                        this.compileError("Unknown built-in type " + string);
                    }
                }
                ((SimpleType)((Object)itemType)).setFingerprint(n & 0xFFFFF);
                return (SimpleType)((Object)itemType);
            }
            if (!this.getPrincipalStylesheet().isImportedSchema(string2)) {
                this.compileError("There is no imported schema for the namespace of type " + string);
                return null;
            }
            SchemaType schemaType = this.getConfiguration().getSchemaType(n & 0xFFFFF);
            if (schemaType == null) {
                this.compileError("There is no type named " + string + " in an imported schema");
            }
            return schemaType;
        }
        catch (NamespaceException namespaceException) {
            this.compileError("Namespace prefix for type annotation is undeclared");
        }
        catch (QNameException qNameException) {
            this.compileError("Invalid type name. " + qNameException.getMessage());
        }
        return null;
    }

    public int getTypeAnnotation(SchemaType schemaType) {
        if (schemaType != null) {
            return schemaType.getFingerprint();
        }
        return -1;
    }

    public void validate() throws TransformerConfigurationException {
    }

    public void postValidate() throws TransformerConfigurationException {
    }

    public Expression typeCheck(String string, Expression expression) throws TransformerConfigurationException {
        ExpressionTool.makeParentReferences(expression);
        if (expression instanceof ComputedExpression) {
            ((ComputedExpression)expression).setParentExpression(this);
        }
        if (expression == null) {
            return null;
        }
        try {
            expression = expression.analyze(this.staticContext, Type.ITEM_TYPE);
            if (this.explaining) {
                System.err.println("Attribute '" + string + "' of element '" + this.getDisplayName() + "' at line " + this.getLineNumber() + ':');
                System.err.println("Static type: " + new SequenceType(expression.getItemType(), expression.getCardinality()));
                System.err.println("Optimized expression tree:");
                expression.display(10, this.getNamePool(), System.err);
            }
            if (this.getConfiguration().getTraceListener() != null) {
                InstructionDetails instructionDetails = new InstructionDetails();
                instructionDetails.setConstructType(2011);
                instructionDetails.setLineNumber(this.getLineNumber());
                instructionDetails.setSystemId(this.getSystemId());
                instructionDetails.setProperty("attribute-name", string);
                TraceInstruction traceInstruction = new TraceInstruction(expression, instructionDetails);
                traceInstruction.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                traceInstruction.setParentExpression(this);
                expression = traceInstruction;
            }
            return expression;
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.isTypeError()) {
                this.compileError(dynamicError);
                return expression;
            }
            ErrorExpression errorExpression = new ErrorExpression(dynamicError);
            errorExpression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return errorExpression;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            ErrorExpression errorExpression = new ErrorExpression(xPathException);
            errorExpression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return errorExpression;
        }
    }

    public void allocateSlots(Expression expression) {
        SlotManager slotManager = this.getContainingSlotManager();
        if (slotManager == null) {
            ExpressionTool.allocateSlots(expression, 0, null);
        } else {
            int n = slotManager.getNumberOfVariables();
            int n2 = ExpressionTool.allocateSlots(expression, n, slotManager);
            if (n2 > n) {
                slotManager.setNumberOfVariables(n2);
            }
        }
    }

    public Pattern typeCheck(String string, Pattern pattern) throws TransformerConfigurationException {
        if (pattern == null) {
            return null;
        }
        try {
            return pattern.typeCheck(this.staticContext, Type.NODE_TYPE);
        }
        catch (DynamicError dynamicError) {
            LocationPathPattern locationPathPattern = new LocationPathPattern();
            locationPathPattern.addFilter(new ErrorExpression(dynamicError));
            return locationPathPattern;
        }
        catch (XPathException xPathException) {
            throw new TransformerConfigurationException("Error in " + string + " pattern", xPathException);
        }
    }

    public void fixupReferences() throws TransformerConfigurationException {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).fixupReferences();
        }
        return;
    }

    public SlotManager getContainingSlotManager() {
        NodeInfo nodeInfo = this;
        while (true) {
            NodeInfo nodeInfo2;
            if ((nodeInfo2 = nodeInfo.getParent()) instanceof XSLStylesheet) {
                if (nodeInfo instanceof StylesheetProcedure) {
                    return ((StylesheetProcedure)((Object)nodeInfo)).getSlotManager();
                }
                return null;
            }
            nodeInfo = nodeInfo2;
        }
    }

    public void validateSubtree() throws TransformerConfigurationException {
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            }
        }
        try {
            this.validate();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.setValidationError(transformerConfigurationException, 3);
            }
            this.compileError(transformerConfigurationException);
        }
        this.validateChildren();
        this.postValidate();
    }

    protected void validateChildren() throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        StyleElement styleElement = null;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).validateSubtree();
            styleElement = (StyleElement)nodeInfo;
        }
        if (styleElement instanceof XSLVariable && !(this instanceof XSLStylesheet)) {
            styleElement.compileWarning("A variable with no following sibling instructions has no effect");
        }
    }

    protected XSLStylesheet getPrincipalStylesheet() {
        XSLStylesheet xSLStylesheet = this.getContainingStylesheet();
        XSLStylesheet xSLStylesheet2;
        while ((xSLStylesheet2 = xSLStylesheet.getImporter()) != null) {
            xSLStylesheet = xSLStylesheet2;
        }
        return xSLStylesheet;
    }

    public PreparedStylesheet getPreparedStylesheet() {
        return this.getPrincipalStylesheet().getPreparedStylesheet();
    }

    public void checkWithinTemplate() throws TransformerConfigurationException {
        StyleElement styleElement = (StyleElement)this.getParentNode();
        if (!styleElement.mayContainSequenceConstructor()) {
            this.compileError("Element must be used only within a sequence constructor");
        }
    }

    protected void checkSortComesFirst(boolean bl) throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        boolean bl2 = false;
        boolean bl3 = false;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLSort) {
                if (bl3) {
                    ((XSLSort)nodeInfo).compileError("Within " + this.getDisplayName() + ", xsl:sort elements must come before other instructions");
                }
                bl2 = true;
                continue;
            }
            if (nodeInfo.getNodeKind() == 3) {
                if (Navigator.isWhite(nodeInfo.getStringValue())) continue;
                bl3 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl && !bl2) {
            this.compileError(this.getDisplayName() + " must have at least one xsl:sort child");
        }
    }

    public void checkTopLevel(String string) throws TransformerConfigurationException {
        if (!(this.getParentNode() instanceof XSLStylesheet)) {
            this.compileError("Element must only be used at top level of stylesheet", string);
        }
    }

    public void checkEmpty() throws TransformerConfigurationException {
        if (this.hasChildNodes()) {
            this.compileError("Element must be empty", "XT0260");
        }
    }

    public void reportAbsence(String string) throws TransformerConfigurationException {
        this.compileError("Element must have a \"" + string + "\" attribute", "XT0010");
    }

    public abstract Expression compile(Executable var1) throws TransformerConfigurationException;

    public Expression[] compileChildren(Executable executable, InstructionWithChildren instructionWithChildren, boolean bl) throws TransformerConfigurationException {
        Expression[] expressionArray;
        instructionWithChildren.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((expressionArray = (Expression[])axisIterator.next()) != null) {
            Instruction instruction;
            Container container;
            if (expressionArray.getNodeKind() == 3) {
                container = new Text(false);
                try {
                    ((SimpleNodeConstructor)container).setSelect(new StringValue(expressionArray.getStringValue()));
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                ((ComputedExpression)container).setLocationId(this.allocateLocationId(this.getSystemId(), expressionArray.getLineNumber()));
                ((ComputedExpression)container).setParentExpression(instructionWithChildren);
                arrayList.add(container);
                continue;
            }
            if (!(expressionArray instanceof StyleElement)) continue;
            container = (StyleElement)expressionArray;
            if (((StyleElement)container).validationError != null) {
                this.fallbackProcessing(executable, (StyleElement)container, arrayList);
                continue;
            }
            Expression expression = ((StyleElement)container).compile(executable);
            if (expression instanceof Instruction) {
                instruction = (Instruction)expression;
                instruction.setLocationId(this.allocateLocationId(this.getSystemId(), ((StyleElement)container).getLineNumber()));
                instruction.setParentExpression(instructionWithChildren);
            }
            if (expression == null) continue;
            if (this.getConfiguration().getTraceListener() != null) {
                instruction = StyleElement.makeTraceInstruction((StyleElement)container, expression);
                instruction.setParentExpression(instructionWithChildren);
                expression = instruction;
            }
            if (!bl && expressionArray instanceof XSLParam) continue;
            arrayList.add(expression);
        }
        expressionArray = new Expression[arrayList.size()];
        expressionArray = arrayList.toArray(expressionArray);
        instructionWithChildren.setChildren(expressionArray);
        return expressionArray;
    }

    protected static TraceWrapper makeTraceInstruction(StyleElement styleElement, Expression expression) {
        if (expression instanceof TraceWrapper) {
            return (TraceWrapper)expression;
        }
        TraceInstruction traceInstruction = new TraceInstruction(expression, styleElement);
        traceInstruction.setLocationId(styleElement.allocateLocationId(styleElement.getSystemId(), styleElement.getLineNumber()));
        return traceInstruction;
    }

    protected void fallbackProcessing(Executable executable, StyleElement styleElement, List list) throws TransformerConfigurationException {
        Object object;
        boolean bl = false;
        AxisIterator axisIterator = styleElement.iterateAxis((byte)3);
        while ((object = (NodeInfo)axisIterator.next()) != null) {
            if (!(object instanceof XSLFallback)) continue;
            bl = true;
            Block block = new Block();
            block.setLocationId(this.allocateLocationId(this.getSystemId(), object.getLineNumber()));
            ((XSLFallback)object).compileChildren(executable, block, true);
            try {
                list.add(block.simplify(this.getStaticContext()));
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        if (!bl) {
            object = new DeferredError(styleElement.validationError);
            ((ComputedExpression)object).setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            ((ComputedExpression)object).setParentExpression(this);
            list.add(object);
        }
    }

    public int allocateLocationId(String string, int n) {
        return this.getStaticContext().getLocationMap().allocateLocationId(string, n);
    }

    protected SortKeyDefinition[] makeSortKeys() {
        SortKeyDefinition[] sortKeyDefinitionArray;
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((sortKeyDefinitionArray = axisIterator.next()) != null) {
            if (!(sortKeyDefinitionArray instanceof XSLSort)) continue;
            ++n;
        }
        if (n > 0) {
            NodeInfo nodeInfo;
            sortKeyDefinitionArray = new SortKeyDefinition[n];
            axisIterator = this.iterateAxis((byte)3);
            int n2 = 0;
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (!(nodeInfo instanceof XSLSort)) continue;
                sortKeyDefinitionArray[n2++] = ((XSLSort)nodeInfo).getSortKeyDefinition();
            }
            return sortKeyDefinitionArray;
        }
        return null;
    }

    protected AttributeSet[] getAttributeSets(String string, List arrayList) throws TransformerConfigurationException {
        int n;
        AttributeSet[] attributeSetArray;
        if (arrayList == null) {
            arrayList = new ArrayList<XSLAttributeSet>(4);
        }
        XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
        List list = xSLStylesheet.getTopLevel();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            attributeSetArray = stringTokenizer.nextToken();
            try {
                n = this.makeNameCode((String)attributeSetArray) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage(), "XT0710");
                n = -1;
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage(), "XT0710");
                n = -1;
            }
            boolean bl = false;
            int n2 = 0;
            while (n2 < list.size()) {
                XSLAttributeSet xSLAttributeSet;
                if (list.get(n2) instanceof XSLAttributeSet && (xSLAttributeSet = (XSLAttributeSet)list.get(n2)).getAttributeSetFingerprint() == n) {
                    arrayList.add(xSLAttributeSet);
                    bl = true;
                }
                ++n2;
            }
            if (bl) continue;
            this.compileError("No attribute-set exists named " + (String)attributeSetArray, "XT0710");
        }
        attributeSetArray = new AttributeSet[arrayList.size()];
        n = 0;
        while (n < arrayList.size()) {
            XSLAttributeSet xSLAttributeSet = (XSLAttributeSet)arrayList.get(n);
            xSLAttributeSet.incrementReferenceCount();
            attributeSetArray[n] = xSLAttributeSet.getInstruction();
            ++n;
        }
        return attributeSetArray;
    }

    protected WithParam[] getWithParamInstructions(Executable executable, boolean bl) throws TransformerConfigurationException {
        NodeInfo nodeInfo;
        WithParam[] withParamArray;
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((withParamArray = (WithParam[])axisIterator.next()) != null) {
            if (!(withParamArray instanceof XSLWithParam) || ((XSLGeneralVariable)(nodeInfo = (XSLWithParam)withParamArray)).isTunnelParam() != bl) continue;
            ++n;
        }
        withParamArray = new WithParam[n];
        n = 0;
        axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            NodeInfo nodeInfo2;
            if (!(nodeInfo instanceof XSLWithParam) || ((XSLGeneralVariable)(nodeInfo2 = nodeInfo)).isTunnelParam() != bl) continue;
            withParamArray[n++] = (WithParam)((XSLWithParam)nodeInfo2).compile(executable);
        }
        return withParamArray;
    }

    protected void compileError(TransformerException transformerException) throws TransformerConfigurationException {
        if (transformerException.getLocator() == null || transformerException.getLocator() instanceof ExpressionLocation) {
            transformerException.setLocator(this);
        }
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        try {
            if (preparedStylesheet == null) {
                throw transformerException;
            }
            preparedStylesheet.reportError(transformerException);
        }
        catch (TransformerException transformerException2) {
            if (transformerException2 instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException2;
            }
            if (transformerException2.getException() instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException2.getException();
            }
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(transformerException);
            transformerConfigurationException.setLocator(this);
            throw transformerConfigurationException;
        }
    }

    protected void compileError(String string) throws TransformerConfigurationException {
        StaticError staticError = new StaticError(string);
        staticError.setLocator(this);
        this.compileError(staticError);
    }

    protected void compileError(String string, String string2) throws TransformerConfigurationException {
        StaticError staticError = new StaticError(string);
        staticError.setErrorCode(string2);
        staticError.setLocator(this);
        this.compileError(staticError);
    }

    protected void compileWarning(String string) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        transformerConfigurationException.setLocator(this);
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        if (preparedStylesheet != null) {
            preparedStylesheet.reportWarning(transformerConfigurationException);
        }
    }

    protected void issueWarning(TransformerException transformerException) {
        PreparedStylesheet preparedStylesheet;
        if (transformerException.getLocator() == null) {
            transformerException.setLocator(this);
        }
        if ((preparedStylesheet = this.getPreparedStylesheet()) != null) {
            preparedStylesheet.reportWarning(transformerException);
        }
    }

    protected void issueWarning(String string) {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        transformerConfigurationException.setLocator(this);
        this.issueWarning(transformerConfigurationException);
    }

    public boolean isTopLevel() {
        return this.getParentNode() instanceof XSLStylesheet;
    }

    public XSLVariableDeclaration bindVariable(int n) throws StaticError {
        XSLVariableDeclaration xSLVariableDeclaration = this.getVariableBinding(n);
        if (xSLVariableDeclaration == null) {
            throw new StaticError("Variable " + this.getTargetNamePool().getDisplayName(n) + " has not been declared");
        }
        return xSLVariableDeclaration;
    }

    public XSLVariableDeclaration getVariableBinding(int n) {
        XSLVariableDeclaration xSLVariableDeclaration;
        Object object;
        block3: {
            NodeInfo nodeInfo = this;
            NodeInfo nodeInfo2 = this;
            if (!this.isTopLevel()) {
                object = nodeInfo.iterateAxis((byte)11);
                do {
                    nodeInfo = (NodeInfo)object.next();
                    while (nodeInfo == null) {
                        nodeInfo = nodeInfo2.getParent();
                        nodeInfo2 = nodeInfo;
                        if (nodeInfo.getParent() instanceof XSLStylesheet) break;
                        object = nodeInfo.iterateAxis((byte)11);
                        nodeInfo = (NodeInfo)object.next();
                    }
                    if (nodeInfo.getParent() instanceof XSLStylesheet) break block3;
                } while (!(nodeInfo instanceof XSLVariableDeclaration) || (xSLVariableDeclaration = (XSLVariableDeclaration)nodeInfo).getVariableFingerprint() != n);
                return xSLVariableDeclaration;
            }
        }
        object = this.getPrincipalStylesheet();
        xSLVariableDeclaration = ((XSLStylesheet)object).getGlobalVariable(n);
        return xSLVariableDeclaration;
    }

    public XSLFunction getStylesheetFunction(int n, int n2) {
        XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
        List list = xSLStylesheet.getTopLevel();
        int n3 = list.size() - 1;
        while (n3 >= 0) {
            Object e = list.get(n3);
            if (e instanceof XSLFunction && ((XSLFunction)e).getFunctionFingerprint() == n && (n2 == -1 || ((XSLFunction)e).getNumberOfArguments() == n2)) {
                XSLFunction xSLFunction = (XSLFunction)e;
                return xSLFunction;
            }
            --n3;
        }
        return null;
    }

    public int getConstructType() {
        return this.getFingerprint();
    }

    public int getInstructionFingerprint() {
        return this.getFingerprint();
    }

    public int getObjectNameCode() {
        return this.objectNameCode;
    }

    public int getObjectFingerprint() {
        return this.objectNameCode == -1 ? -1 : this.objectNameCode & 0xFFFFF;
    }

    public void setObjectNameCode(int n) {
        this.objectNameCode = n;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.makeNamespaceContext();
    }

    public Object getProperty(String string) {
        return this.getAttributeValue(string);
    }

    public Iterator getProperties() {
        NodeInfo nodeInfo;
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        AxisIterator axisIterator = this.iterateAxis((byte)2);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            arrayList.add(namePool.getClarkName(nodeInfo.getNameCode()));
        }
        return arrayList.iterator();
    }

    public String getSystemId(int n) {
        return this.getSystemId();
    }

    public int getLineNumber(int n) {
        return this.getLineNumber();
    }
}

