/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.xpath.XPathException;

public class XSLAttributeSet
extends StyleElement
implements StylesheetProcedure {
    private String nameAtt;
    private String useAtt;
    private SlotManager stackFrameMap;
    private List attributeSetElements = null;
    private AttributeSet[] useAttributeSets = null;
    private AttributeSet procedure = new AttributeSet();
    private int referenceCount = 0;
    private boolean validated = false;

    public int getAttributeSetFingerprint() {
        return this.getObjectFingerprint();
    }

    public AttributeSet getInstruction() {
        return this.procedure;
    }

    public void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        this.useAtt = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "name") {
                this.nameAtt = attributeCollection.getValue(n).trim();
            } else if (string == "use-attribute-sets") {
                this.useAtt = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.setObjectNameCode(this.makeNameCode(this.nameAtt.trim()));
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
    }

    public void validate() throws TransformerConfigurationException {
        Object object;
        if (this.validated) {
            return;
        }
        this.checkTopLevel(null);
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((object = axisIterator.next()) != null) {
            if (object instanceof XSLAttribute) continue;
            this.compileError("Only xsl:attribute is allowed within xsl:attribute-set");
        }
        if (this.useAtt != null) {
            this.attributeSetElements = new ArrayList();
            this.useAttributeSets = this.getAttributeSets(this.useAtt, this.attributeSetElements);
            object = this.attributeSetElements.iterator();
            while (object.hasNext()) {
                ((XSLAttributeSet)object.next()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    public void checkCircularity(XSLAttributeSet xSLAttributeSet) throws TransformerConfigurationException {
        if (this == xSLAttributeSet) {
            this.compileError("The definition of the attribute set is circular");
        } else {
            if (!this.validated) {
                return;
            }
            if (this.attributeSetElements != null) {
                Iterator iterator = this.attributeSetElements.iterator();
                while (iterator.hasNext()) {
                    ((XSLAttributeSet)iterator.next()).checkCircularity(xSLAttributeSet);
                }
            }
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        block3: {
            if (this.referenceCount <= 0) break block3;
            Instruction instruction = new Block();
            this.compileChildren(executable, (InstructionWithChildren)instruction, true);
            if (this.getConfiguration().getTraceListener() != null) {
                TraceInstruction traceInstruction = new TraceInstruction(instruction, this);
                traceInstruction.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                traceInstruction.setParentExpression(this.procedure);
                instruction = traceInstruction;
            }
            try {
                this.procedure.setUseAttributeSets(this.useAttributeSets);
                this.procedure.setNameCode(this.getObjectNameCode());
                this.procedure.setBody(instruction.simplify(this.getStaticContext()));
                this.procedure.setStackFrameMap(this.stackFrameMap);
                this.procedure.setSystemId(this.getSystemId());
                this.procedure.setLineNumber(this.getLineNumber());
                this.procedure.setExecutable(executable);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        return null;
    }

    public int getConstructType() {
        return 132;
    }
}

