/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;

final class SiblingEnumeration
extends AxisIteratorImpl {
    private TinyDocumentImpl document;
    private int nextNodeNr;
    private NodeTest test;
    private TinyNodeImpl startNode;
    private TinyNodeImpl parentNode;
    private boolean getChildren;
    private boolean needToAdvance = false;

    protected SiblingEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.document = tinyDocumentImpl;
        this.test = nodeTest;
        this.startNode = tinyNodeImpl;
        this.getChildren = bl;
        if (bl) {
            this.parentNode = tinyNodeImpl;
            this.nextNodeNr = tinyNodeImpl.nodeNr + 1;
        } else {
            this.parentNode = (TinyNodeImpl)tinyNodeImpl.getParent();
            if (this.parentNode == null) {
                this.nextNodeNr = -1;
            } else {
                this.nextNodeNr = tinyDocumentImpl.next[tinyNodeImpl.nodeNr];
                if (this.nextNodeNr < tinyNodeImpl.nodeNr) {
                    this.nextNodeNr = -1;
                }
            }
        }
        if (this.nextNodeNr >= 0 && nodeTest != null && !nodeTest.matches(this.document.nodeKind[this.nextNodeNr], this.document.nameCode[this.nextNodeNr], this.document.getElementAnnotation(this.nextNodeNr))) {
            this.needToAdvance = true;
        }
    }

    public Item next() {
        if (this.needToAdvance) {
            int n = this.nextNodeNr;
            if (this.test == null) {
                this.nextNodeNr = this.document.next[this.nextNodeNr];
            } else {
                do {
                    this.nextNodeNr = this.document.next[this.nextNodeNr];
                } while (this.nextNodeNr >= n && !this.test.matches(this.document.nodeKind[this.nextNodeNr], this.document.nameCode[this.nextNodeNr], this.document.getElementAnnotation(this.nextNodeNr)));
            }
            if (this.nextNodeNr < n) {
                this.nextNodeNr = -1;
                this.needToAdvance = false;
                return null;
            }
        }
        if (this.nextNodeNr == -1) {
            return null;
        }
        this.needToAdvance = true;
        ++this.position;
        if (this.isAtomizing() && this.document.getElementAnnotation(this.nextNodeNr) == -1) {
            this.current = this.document.getUntypedAtomicValue(this.nextNodeNr);
            return this.current;
        }
        this.current = this.document.getNode(this.nextNodeNr);
        ((TinyNodeImpl)this.current).setParentNode(this.parentNode);
        return this.current;
    }

    public SequenceIterator getAnother() {
        return new SiblingEnumeration(this.document, this.startNode, this.test, this.getChildren);
    }
}

