/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.xpath.XPathEvaluator;
import net.sf.saxon.xpath.XPathException;

public final class XPathExpression {
    private Configuration configuration;
    private Expression expression;
    private NodeInfo contextNode;
    private SlotManager stackFrameMap;
    private XPathExpression sortKey = null;

    protected XPathExpression(Expression expression, Configuration configuration) {
        this.expression = expression;
        this.configuration = configuration;
    }

    protected void setStackFrameMap(SlotManager slotManager) {
        this.stackFrameMap = slotManager;
    }

    public void setSortKey(XPathExpression xPathExpression) {
        this.sortKey = xPathExpression;
    }

    public void setContextNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        if (nodeInfo.getNamePool() != this.configuration.getNamePool()) {
            throw new IllegalArgumentException("Supplied node uses the wrong NamePool");
        }
        this.contextNode = nodeInfo;
    }

    public List evaluate() throws XPathException {
        SequenceIterator sequenceIterator = this.rawIterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Item item;
        while ((item = sequenceIterator.next()) != null) {
            arrayList.add(XPathEvaluator.convert(item));
        }
        return arrayList;
    }

    public Object evaluateSingle() throws XPathException {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.contextNode, this.configuration);
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        SequenceIterator sequenceIterator = this.expression.iterate(xPathContextMajor);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return XPathEvaluator.convert(item);
    }

    public SequenceIterator rawIterator() throws XPathException {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.contextNode, this.configuration);
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        SequenceIterator sequenceIterator = this.expression.iterate(xPathContextMajor);
        if (this.sortKey != null) {
            Expression expression = this.sortKey.expression;
            if (expression.getItemType() instanceof NodeTest) {
                expression = new Atomizer(expression);
            }
            FixedSortKeyDefinition[] fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[]{new FixedSortKeyDefinition()};
            fixedSortKeyDefinitionArray[0].setSortKey(expression);
            fixedSortKeyDefinitionArray[0].bindComparer();
            sequenceIterator = new SortedIterator(xPathContextMajor, sequenceIterator, fixedSortKeyDefinitionArray);
        }
        return sequenceIterator;
    }
}

