<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [

<!ENTITY primary   'normalize-space(concat(primary/@sortas, primary[not(@sortas)]))'>

<!ENTITY group-key "isoi18n:getIndexGroupSortKey(isoi18n:getIsoLangCode(/doc/@lang),
                                               isoi18n:getIndexGroupKey(isoi18n:getIsoLangCode(/doc/@lang), 
                                               &primary;))"
>

<!ENTITY secondary 'normalize-space(concat(secondary/@sortas, secondary[not(@sortas)]))'>
<!ENTITY tertiary  'normalize-space(concat(tertiary/@sortas, tertiary[not(@sortas)]))'>

<!ENTITY sep '" "'>
<!ENTITY scope 'count(ancestor::node()|$scope) = count(ancestor::node())'>
]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:func="http://exslt.org/functions"
                xmlns:isoi18n="java:com.isogen.saxoni18n.Saxoni18nService"
                exclude-result-prefixes="isoi18n"
                extension-element-prefixes="isoi18n"								
                version="1.0">


<!-- ==================================================================== -->
<!-- Derived from Jeni Tennison's work in the HTML case
  
     This code is further based on the DocBook 4.x index processing code.
  -->

<xsl:key name="letter"
         match="index_entry[primary[string(self::*) != '']]"
         use="&group-key;"/>

<xsl:key name="primary"
         match="index_entry[primary[string(self::*) != '']]"
         use="&primary;"/>

<xsl:key name="secondary"
         match="index_entry[primary[string(self::*) != '']]"
         use="concat(&primary;, &sep;, &secondary;)"/>

<xsl:key name="tertiary"
         match="index_entry[primary[string(self::*) != '']]"
         use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;)"/>

<xsl:key name="see-also"
         match="index_entry[seealso and primary[string(self::*) != '']]"
         use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, seealso)"/>

<xsl:key name="see"
         match="index_entry[see and primary[string(self::*) != '']]"
         use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, see)"/>

<xsl:template name="generate-index">

  <xsl:variable name="doc.language" select="/doc/@xml:lang"/>
  <xsl:message>** doc.language="<xsl:value-of select="$doc.language"/>"</xsl:message>
  <h2>
    <xsl:value-of select="isoi18n:getGeneratedTextForKeyBefore('#index', $docLang)"/>
  </h2>
</xsl:template>
  
<xsl:template name="temp">
  <xsl:variable name="sort.language" select="isoi18n:getIsoLangCode($doc.language)"/>
  <xsl:message> + Processing index, sort language="<xsl:value-of select="$sort.language"/>", ...</xsl:message>
  <xsl:variable name="terms"
                select="//index_entry[primary[string(self::*) != ''] and
                                    count(.|key('letter',
                                                isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;)))[&scope;][1]) = 1]"/>
                                    
  <xsl:variable name="alphabetical"
                select="$terms[not(starts-with('#NUMERIC',
                                            isoi18n:getIndexGroupKey($sort.language, &primary;)))]"/>

  <xsl:variable name="others" select="$terms[starts-with('#NUMERIC',
                                             isoi18n:getIndexGroupKey($sort.language, &primary;))]"/>

  <div>
    <xsl:if test="$others">
      <xsl:call-template name="indexdiv.title">
        <xsl:with-param name="titlecontent">
          <xsl:call-template name="gentext">
            <xsl:with-param name="key" select="'index symbols'"/>
          </xsl:call-template>
        </xsl:with-param>
      </xsl:call-template>

      <div>
        <xsl:apply-templates select="$others[&scope;][1]"
                             mode="index-symbol-div">
          <xsl:with-param name="scope" select="$scope"/>
          <xsl:with-param name="sort.language" select="$sort.language"/>
          <xsl:sort lang="{$sort.language}" 
                    select="isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;))"/>
        </xsl:apply-templates>
      </div>
    </xsl:if>

    <xsl:apply-templates select="$alphabetical[count(.|key('letter',
                                 isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;)))[&scope;][1]) = 1]"
                         mode="index-div">
      <xsl:with-param name="scope" select="$scope"/>
      <xsl:with-param name="sort.language" select="$sort.language"/>
      <xsl:sort lang="{$sort.language}" select="isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;))"/>
    </xsl:apply-templates>
  </div>
  <xsl:message> + Index processing done.</xsl:message>
</xsl:template>

<xsl:template match="index_entry" mode="index-div">
  <xsl:param name="scope" select="."/>
  <xsl:param name="sort.language"/>

  <div>
    <xsl:call-template name="indexdiv.title">
      <xsl:with-param name="titlecontent">
        <xsl:value-of select="isoi18n:getIndexGroupLabel($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;))"/>
      </xsl:with-param>
    </xsl:call-template>
    <div>
      <xsl:apply-templates select="key('letter', isoi18n:getIndexGroupKey($sort.language, &primary;))[&scope;]
                                   [count(.|key('primary', &primary;)[&scope;][1])=1]"
                           mode="index-primary">
        <xsl:with-param name="scope" select="$scope"/>
        <xsl:with-param name="sort.language" select="$sort.language"/>
  			<xsl:sort lang="{$sort.language}" select="&primary;"/>          
      </xsl:apply-templates>
    </div>
  </div>
</xsl:template>

<xsl:template match="index_entry" mode="index-symbol-div">
  <xsl:param name="scope" select="."/>
  <xsl:param name="sort.language"/>

  <xsl:variable name="key"
                select="isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;))"/>

  <div>
    <xsl:apply-templates select="key('letter', $key)[&scope;][count(.|key('primary', &primary;)[&scope;][1]) = 1]"
                         mode="index-primary">
      <xsl:with-param name="scope" select="$scope"/>
      <xsl:with-param name="sort.language" select="$sort.language"/>
      <xsl:sort lang="{$sort.language}" select="&primary;"/>
    </xsl:apply-templates>
  </div>
</xsl:template>

<xsl:template match="index_entry" mode="index-primary">
  <xsl:param name="scope" select="."/>
  <xsl:param name="sort.language"/>
  
  <xsl:variable name="writing.mode">
    <xsl:call-template name="get_writing_mode"/>
  </xsl:variable>

  <xsl:variable name="key" select="&primary;"/>
  <xsl:variable name="refs" select="key('primary', $key)[&scope;]"/>
  <p>
    <xsl:apply-templates select="primary"/>

    <xsl:variable name="page-number-citations">
      <xsl:for-each select="$refs[not(see) and not(seealso)
                            and not(secondary)]">
        <xsl:apply-templates select="." mode="reference">
          <xsl:with-param name="scope" select="$scope"/>
        </xsl:apply-templates>
      </xsl:for-each>
    </xsl:variable>

    <xsl:copy-of select="$page-number-citations"/>

    <xsl:if test="$refs[not(secondary)]/*[self::see]">
      <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see', concat(&primary;, &sep;, &sep;, &sep;, see))[&scope;][1])]"
                           mode="index-see">
         <xsl:with-param name="scope" select="$scope"/>
         <xsl:with-param name="sort.language" select="$sort.language"/>
         <xsl:sort lang="{$sort.language}" select="see"/>
      </xsl:apply-templates>
    </xsl:if>

  </p>

  <xsl:if test="$refs/secondary or $refs[not(secondary)]/*[self::seealso]">
    <p>
      <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see-also', concat(&primary;, &sep;, &sep;, &sep;, seealso))[&scope;][1])]"
                           mode="index-seealso">
         <xsl:with-param name="scope" select="$scope"/>
         <xsl:with-param name="sort.language" select="$sort.language"/>
         <xsl:sort lang="{$sort.language}" select="seealso"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="$refs[secondary and count(.|key('secondary', concat($key, &sep;, &secondary;))[&scope;][1]) = 1]"
                           mode="index-secondary">
        <xsl:with-param name="scope" select="$scope"/>
        <xsl:with-param name="sort.language" select="$sort.language"/>
        <xsl:sort lang="{$sort.language}" select="&secondary;"/>
      </xsl:apply-templates>
    </p>
  </xsl:if>
</xsl:template>


<xsl:template match="index_entry" mode="index-see">
   <xsl:param name="scope" select="."/>

   <span>
     <xsl:text> (</xsl:text>
     <xsl:call-template name="gentext">
       <xsl:with-param name="key" select="'see'"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
     <xsl:apply-templates select="see"/>
     <xsl:text>)</xsl:text>
   </span>
</xsl:template>

<xsl:template match="index_entry" mode="index-seealso">
   <xsl:param name="scope" select="."/>

   <p>
     <xsl:text>(</xsl:text>
     <xsl:call-template name="gentext">
       <xsl:with-param name="key" select="'seealso'"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
     <xsl:apply-templates select="seealso"/>
     <xsl:text>)</xsl:text>
   </p>
</xsl:template>

<xsl:template match="index_entry" mode="index-secondary">
  <xsl:param name="scope" select="."/>
  <xsl:param name="sort.language"/>

  <xsl:variable name="writing.mode">
    <xsl:call-template name="get_writing_mode"/>
  </xsl:variable>

  <xsl:variable name="key" select="concat(&primary;, &sep;, &secondary;)"/>
  <xsl:variable name="refs" select="key('secondary', $key)[&scope;]"/>
  <p>
    <xsl:apply-templates select="secondary"/>

    <xsl:variable name="page-number-citations">
      <xsl:for-each select="$refs[not(see) and not(seealso)
                            and not(tertiary)]">
        <xsl:apply-templates select="." mode="reference">
          <xsl:with-param name="scope" select="$scope"/>
        </xsl:apply-templates>
      </xsl:for-each>
    </xsl:variable>

    <xsl:copy-of select="$page-number-citations"/>

    <xsl:if test="$refs[not(tertiary)]/*[self::see]">
      <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see', concat(&primary;, &sep;, &secondary;, &sep;, &sep;, see))[&scope;][1])]"
                           mode="index-see">
        <xsl:with-param name="scope" select="$scope"/>
          <xsl:with-param name="sort.language" select="$sort.language"/>
        <xsl:sort lang="{$sort.language}" select="see"/>
      </xsl:apply-templates>
    </xsl:if>

  </p>

  <xsl:if test="$refs/tertiary or $refs[not(tertiary)]/*[self::seealso]">
    <p>
      <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see-also', concat(&primary;, &sep;, &secondary;, &sep;, &sep;, seealso))[&scope;][1])]"
                           mode="index-seealso">
          <xsl:with-param name="scope" select="$scope"/>
          <xsl:with-param name="sort.language" select="$sort.language"/>
          <xsl:sort lang="{$sort.language}" select="seealso"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="$refs[tertiary and count(.|key('tertiary', concat($key, &sep;, &tertiary;))[&scope;][1]) = 1]" 
                           mode="index-tertiary">
          <xsl:with-param name="scope" select="$scope"/>
          <xsl:with-param name="sort.language" select="$sort.language"/>
          <xsl:sort lang="{$sort.language}" select="&tertiary;"/>
      </xsl:apply-templates>
    </p>
  </xsl:if>
</xsl:template>

<xsl:template match="index_entry" mode="index-tertiary">
  <xsl:param name="scope" select="."/>
  <xsl:param name="sort.language"/>
  
  <xsl:variable name="writing.mode">
    <xsl:call-template name="get_writing_mode"/>
  </xsl:variable>
  
  <xsl:variable name="key" select="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;)"/>
  <xsl:variable name="refs" select="key('tertiary', $key)[&scope;]"/>
  <p>
    <xsl:apply-templates select="tertiary"/>

    <xsl:variable name="page-number-citations">
      <xsl:for-each select="$refs[not(see) and not(seealso)]">
        <xsl:apply-templates select="." mode="reference">
          <xsl:with-param name="scope" select="$scope"/>
        </xsl:apply-templates>
      </xsl:for-each>
    </xsl:variable>

    <xsl:copy-of select="$page-number-citations"/>

    <xsl:if test="$refs/see">
      <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see', concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, see))[&scope;][1])]"
                           mode="index-see">
        <xsl:with-param name="scope" select="$scope"/>
        <xsl:sort lang="{$sort.language}" select="see"/>
      </xsl:apply-templates>
    </xsl:if>

  </p>

  <xsl:if test="$refs/seealso">
    <p>
      <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see-also', concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, seealso))[&scope;][1])]"
                           mode="index-seealso">
        <xsl:with-param name="scope" select="$scope"/>
        <xsl:sort lang="{$sort.language}" select="seealso"/>
      </xsl:apply-templates>
    </p>
  </xsl:if>
</xsl:template>

<!--======================================
     Debugging routines
     ======================================-->
     
<xsl:template name="report_index_terms">
  <xsl:param name="item_list"/>
  <xsl:param name="sort.language"/>
  
  <xsl:message>Index Term Report. Sort language="<xsl:value-of select="$sort.language"/>"
  </xsl:message>
  <xsl:apply-templates select="$item_list" mode="report_index_terms">
    <xsl:with-param name="sort.language" select="$sort.language"/>
    <xsl:sort lang="$sort.language" select="&primary;"/>
  </xsl:apply-templates>
</xsl:template>     

<xsl:template match="index_entry" mode="report_index_terms">
  <xsl:param name="sort.language"/>
<xsl:message>*** sort.language=<xsl:value-of select="$sort.language"/></xsl:message>
  <xsl:variable name="primary" select="isoi18n:escapeUnicodeString(string(primary))"/>
  <xsl:message> + <xsl:value-of select="isoi18n:escapeUnicodeString($primary)"/></xsl:message>
  <xsl:message>   group key: <xsl:value-of select="isoi18n:escapeUnicodeString(isoi18n:getIndexGroupKey($sort.language, &primary;))"/></xsl:message>
  <xsl:for-each select="secondary">
    <xsl:sort lang="$sort.language" select="&secondary;"/>
    <xsl:message>   Secondary: <xsl:value-of select="isoi18n:escapeUnicodeString(string(.))"/></xsl:message>
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
