goto --dbk_configure--
= goto

require"luaiconv"
require"lfs"

----------------------------------------------------
----------------------------------------------------
--                  Լ                        --
----------------------------------------------------
----------------------------------------------------

local function make_file_url(dir)
	local converted = 'file:///' .. dir
	converted = converted:gsub('\\', '/')
	local cd = luaiconv.new("utf-8//TRANSLIT", "euc-kr")
	converted = cd:iconv(converted)

	local encoded = ''

	for i =1, converted:len() do
		byte = converted:byte(i)
		if byte > 127 then
			encoded = encoded .. string.format('%%%%%X', byte)
		else
			encoded = encoded .. converted:sub(i, i)
		end
	end
	return encoded
end

local function get_file_content(filename, tplfile)
	local f = io.open(filename, 'r')
	if f then
		return f:read('*a')
	else
		return io.open(tplfile, 'r'):read('*a')
	end
end

local function save_file(filename, text)
	local outfile = assert(io.open(filename, "w"))
	outfile:write(text)
	assert(outfile:close())
end

local function text_replace(patterns, template)
	local result = template
	for search, replace in pairs(patterns) do
		result = result:gsub(search, replace)
	end
	return result
end

local function short_dir_name()
	local p = io.popen('command.com /C cd')
	return string.gsub(p:read("*a"), '%s+$', '')
end

local function parse_jar_version(fop_lib_dir)
	local versions = {}
	for file in lfs.dir(fop_lib_dir) do
		if string.find(file, '.jar$') then
			local i, j, name, version = string.find(file, '(.-)([0-9.]+)%.jar')
			if name and version then
				versions[name] = version
			end
		end
	end
	return versions
end

local function replace_versions(str, versions)
	for k, v in pairs(versions) do
		str = string.gsub(str, '\\' .. string.gsub(k,'-', '%%-')..'.-jar', '\\'..k..v..'.jar')
	end
	return str
end

function make_scripts(fop_lib_dir, bat_tpls)
	local versions = parse_jar_version(fop_lib_dir)
	for bat, tpl in pairs(bat_tpls) do
		local str = get_bat_content(bat, tpl)
		str = replace_versions(str, versions)
		local f = io.open(bat, 'w')
		f:write(str)
		f:close()
	end
end

----------------------------------------------------
----------------------------------------------------
--                                            --
----------------------------------------------------
----------------------------------------------------

curdir = short_dir_name()

if (not curdir) then
	print("ɰ Դϴ. http://docbook.kr/  Խǿ  ּ")
	os.exit()
end

curdir_url = make_file_url(curdir)

print "dbkshell.bat մϴ."
local dbkshell_tpl = get_file_content('dbkshell.bat', 'installer/tpls/dbkshell.bat.tpl')
dbkshell = text_replace({
		['(set DOCBOOK_HOME=).-\n'] = '%1'..curdir..'\n',
		['(set DBK_BASE_URL=).-\n'] = '%1'..curdir_url:gsub('%%', '%%%%')..'\n'},
	dbkshell_tpl)
save_file('dbkshell.bat', dbkshell)

print "conf/fop-config.xml մϴ."
local fop_conf_tpl = get_file_content('conf/fop-config.xml', 'installer/tpls/fop-config.xml.tpl')
fop_conf_tpl = text_replace({
		['<base>.-<'] = '<base>' .. curdir_url .. '<',
		['<font%-base>.-<'] = '<font-base>' .. curdir_url .. '<'},
	fop_conf_tpl)
save_file('conf/fop-config.xml', fop_conf_tpl)

----- fop  Java   -------
local fop_lib_dir = 'software/fop/lib'

local versions = parse_jar_version(fop_lib_dir)

local bat_tpls = {
	['bin/xalan.bat']='installer/tpls/xalan.bat.tpl',
	['bin/saxon.bat']='installer/tpls/saxon.bat.tpl',
	['bin/fop.bat']='installer/tpls/fop.bat.tpl',
	['bin/ttfreader.bat']='installer/tpls/ttfreader.bat.tpl',
}

for bat, tpl in pairs(bat_tpls) do
	local str = get_file_content(bat, tpl)
	print(bat .. " մϴ.")
	str = replace_versions(str, versions)
	local f = io.open(bat, 'w')
	f:write(str)
	f:close()
end

io.write[[===============================================
 ϴ. 
   ͸(]]
io.write(lfs.currentdir())
print[[) dbkshell.bat ؼ 
ں ۾ Ͻø ˴ϴ.
===============================================]]





--[[
:--dbk_configure--
@echo off
@bin\lua5.1.exe configure.bat
if NOT "%1"=="--nopause" cmd
::]]
