require"zip"
require"lfs"

local function get_archive_name(url)
	local i, j, name = string.find(url, '([^/]+)%.zip')
	return name
end

local function get_base_dir(filepath)
	local i, j, name = string.find(filepath, '^([^/]+)')
	if i then
		return name
	else
		return ''
	end
end

local function get_filename(filepath)
	local i, j, name = string.find(filepath, '([^/]+)$')
	return name
end

local function is_dir(dir)
	local d = lfs.attributes(dir)
	return d and d.mode =="directory"
end

local function make_dir(path)
	local dir = ''
	if string.sub(path, 1, 1) == '/' then
		dir = '/'
	end
	for w in string.gmatch(path, '[^/]+') do
		dir = dir .. w
		if not is_dir(dir) then
			local r, err = lfs.mkdir(dir)
			if err then return 'mkdir ' .. err end
		end
		dir = dir .. '/'
	end
end

local function save_to_file(src, filepath)
	local dir_path = string.gsub(filepath, '/[^/]+$', '')
	local err = make_dir(dir_path)
	if err then return err end
	dst, err = io.open(filepath, "wb")
	if err then return err end
	dst:write(src:read("*a"))
	src:close()
	dst:flush()
	dst:close()
end

function install_files(spec, report_func, install_dir)

	local archive = spec.archive or get_archive_name(spec.url)
	local zfile, err = zip.open('files/' .. archive .. '.zip')
	if err then return err end

	local base_dir = get_base_dir(zfile:files()().filename)

	if spec.files then
		make_dir(spec.dest)
		for i, v in ipairs(spec.files) do
			local src, err = zfile:open(string.gsub(v, '%%T', base_dir))
	        if err then return err end
			err = save_to_file(src, install_dir .. spec.dest .. '/' .. get_filename(v))
	        if err then return '  - ' .. err end
	        if not report_func() then return 'user canceled' end
		end
	elseif spec.paths then
		for file in zfile:files() do
			if string.sub(file.filename, -1) ~= '/' then
				for i, v in ipairs(spec.paths) do
					local i, j, m = string.find(file.filename, v[1])
					if m then
						local src, err = zfile:open(file.filename)
				        if err then return err end
						err = save_to_file(src, install_dir .. v[2] .. m)
				        if err then return '  - ' .. err end
				        if not report_func() then return 'user canceled' end
						break
					end
				end
			end
		end
	end
end
