<?xml version="1.0"?>
<!--
This is an example configuration file for FOP.
This file contains the same settings as the default values
and will have no effect if used unchanged.

Relative config url's will be resolved relative to
the location of this file.
-->
<!-- NOTE: This is the version of the configuration -->
<fop version="1.0">
<!-- Base URL for resolving relative URLs -->
  <base>{DBK_BASE_URL}</base>
  <font-base>{DBK_BASE_URL}</font-base>
<!-- Source resolution in dpi (dots/pixels per inch) for determining
 the size of pixels in SVG and bitmap images, default: 72dpi -->
  <source-resolution>100</source-resolution>
<!-- Target resolution in dpi (dots/pixels per inch) for specifying
 the target resolution for generated bitmaps, default: 72dpi -->
  <target-resolution>100</target-resolution>
<!-- Default page-height and page-width, in case
 value is specified as auto -->
  <default-page-settings height="297mm" width="210mm"/>


	<use-cache>false</use-cache>
<!-- Information for specific renderers -->
<!-- Uses renderer mime type for renderers -->
  <renderers>
    <renderer mime="application/pdf">
      <filterList>
<!-- provides compression using zlib flate (default is on) -->
        <value>flate</value>
<!-- encodes binary data into printable ascii characters (default off)
This provides about a 4:5 expansion of data size -->
<!-- <value>ascii-85</value> -->
<!-- encodes binary data with hex representation (default off)
This filter is not recommended as it doubles the data size -->
<!-- <value>ascii-hex</value> -->
      </filterList>
      <fonts>
<!-- embedded fonts -->
<!--
        This information must exactly match the font specified
        in the fo file. Otherwise it will use a default font.

        For example,
        <fo:inline font-family="Arial" font-weight="bold" font-style="normal">
            Arial-normal-normal font
        </fo:inline>
        for the font triplet specified by:
        <font-triplet name="Arial" style="normal" weight="bold"/>

        If you do not want to embed the font in the pdf document
        then do not include the "embed-url" attribute.
        The font will be needed where the document is viewed
        for it to be displayed properly.

        possible styles: normal | italic | oblique | backslant
        possible weights: normal | bold | 100 | 200 | 300 | 400
                          | 500 | 600 | 700 | 800 | 900
        (normal = 400, bold = 700)
-->
<!--
        <font metrics-url="arial.xml" kerning="yes" embed-url="arial.ttf">
          <font-triplet name="Arial" style="normal" weight="normal"/>
          <font-triplet name="ArialMT" style="normal" weight="normal"/>
        </font>
        <font metrics-url="arialb.xml" kerning="yes" embed-url="arialb.ttf">
          <font-triplet name="Arial" style="normal" weight="bold"/>
          <font-triplet name="ArialMT" style="normal" weight="bold"/>
        </font>
-->
<!-- +++ font configuration for [UnBatang] +++ -->
        <font kerning="yes" metrics-url="fonts/UnBatang.xml" embed-url="fonts/UnBatang.ttf">
          <font-triplet style="normal" weight="normal" name="serif"/>
          <font-triplet style="italic" weight="normal" name="serif"/>
          <font-triplet style="normal" weight="normal" name="UnBatang"/>
          <font-triplet style="italic" weight="normal" name="UnBatang"/>
        </font>
<!-- +++ font configuration for [UnBatangBold] +++ -->
        <font kerning="yes" metrics-url="fonts/UnBatangBold.xml" embed-url="fonts/UnBatangBold.ttf">
          <font-triplet style="normal" weight="bold" name="serif"/>
          <font-triplet style="normal" weight="bold" name="UnBatang"/>
          <font-triplet style="normal" weight="bold" name="UnBatangBold"/>
        </font>
<!-- +++ font configuration for [UnDotum] +++ -->
        <font kerning="yes" metrics-url="fonts/UnDotum.xml" embed-url="fonts/UnDotum.ttf">
          <font-triplet style="normal" weight="normal" name="sans-serif"/>
          <font-triplet style="italic" weight="normal" name="sans-serif"/>
          <font-triplet style="normal" weight="normal" name="UnDotum"/>
          <font-triplet style="italic" weight="normal" name="UnDotum"/>
        </font>
<!-- +++ font configuration for [UnDotumBold] +++ -->
        <font kerning="yes" metrics-url="fonts/UnDotumBold.xml" embed-url="fonts/UnDotumBold.ttf">
          <font-triplet style="normal" weight="bold" name="sans-serif"/>
          <font-triplet style="normal" weight="bold" name="UnDotum"/>
          <font-triplet style="normal" weight="bold" name="UnDotumBold"/>
        </font>

<!-- +++ font configuration for [NanumGothic_Coding] +++ -->
        <font kerning="yes" metrics-url="fonts/NanumGothicCoding.xml" embed-url="fonts/NanumGothicCoding.ttf">
          <font-triplet style="normal" weight="normal" name="monospace"/>
          <font-triplet style="italic" weight="normal" name="monospace"/>
          <font-triplet style="normal" weight="normal" name="NanumGothicCoding"/>
          <font-triplet style="italic" weight="normal" name="NanumGothicCoding"/>
        </font>

<!-- +++ font configuration for [NanumGothic_Coding_Bold] +++ -->
        <font kerning="yes" metrics-url="fonts/NanumGothicCoding-Bold.xml" embed-url="fonts/NanumGothicCoding-Bold.ttf">
          <font-triplet style="normal" weight="bold" name="monospace"/>
          <font-triplet style="italic" weight="bold" name="monospace"/>
          <font-triplet style="normal" weight="bold" name="NanumGothicCoding-Bold"/>
          <font-triplet style="italic" weight="bold" name="NanumGothicCoding-Bold"/>
        </font>

<!-- +++ font configuration for [UnGraphic] +++ -->
        <font kerning="yes" metrics-url="fonts/UnGraphic.xml" embed-url="fonts/UnGraphic.ttf">
          <font-triplet style="normal" weight="normal" name="UnGraphic"/>
          <font-triplet style="italic" weight="normal" name="UnGraphic"/>
        </font>
<!-- +++ font configuration for [UnGraphicBold] +++ -->
        <font kerning="yes" metrics-url="fonts/UnGraphicBold.xml" embed-url="fonts/UnGraphicBold.ttf">
          <font-triplet style="normal" weight="bold" name="UnGraphic"/>
          <font-triplet style="normal" weight="bold" name="UnGraphicBold"/>
        </font>
      </fonts>
<!-- This option lets you specify additional options on an XML handler -->
<!--
      <xml-handler namespace="http://www.w3.org/2000/svg">
        <stroke-text>false</stroke-text>
      </xml-handler>
-->
    </renderer>
    <renderer mime="application/postscript">
<!-- This option forces the PS renderer to rotate landscape pages -->
<!--
      <auto-rotate-landscape>true</auto-rotate-landscape>-->
<!-- This option lets you specify additional options on an XML handler -->
<!--
      <xml-handler namespace="http://www.w3.org/2000/svg">
        <stroke-text>false</stroke-text>
      </xml-handler>
      -->
    </renderer>
    <renderer mime="application/vnd.hp-PCL"/>
<!-- MIF does not have a renderer
    <renderer mime="application/vnd.mif">
    </renderer>
    -->
    <renderer mime="image/svg+xml">
      <format type="paginated"/>
      <link value="true"/>
      <strokeText value="false"/>
    </renderer>
    <renderer mime="application/awt"/>
    <renderer mime="text/xml"/>
<!-- RTF does not have a renderer
    <renderer mime="text/rtf">
    </renderer>
    -->
    <renderer mime="text/plain">
      <pageSize columns="80"/>
    </renderer>
  </renderers>
</fop>
