require"lfs"
require"socket.http"
require"socket.ftp"
require"socket.url"
require"ltn12"

function get_remote_filesize(url, fallback_size)
	local parsed_url = url
	if type(url) == 'string' then
		parsed_url = socket.url.parse(url)
	end
	if parsed_url.scheme == 'http' then
		local r, e, h = socket.http.request{
			method = "HEAD",
			url = url,
			redirect = true,
		}
		if r == nil then return fallback_size, e end
		return h['content-length']
	else
		return fallback_size, 'unknown scheme(check url!)'
	end
end

function get_filename(filepath)
	local i, j, name = string.find(filepath, '([^/]+)$')
	return name
end


local function http_download_file(parsed_url, target_filename, step_func)
	local url=socket.url.build(parsed_url)
	local tmpfile = os.tmpname()
	r, e = socket.http.request{
		url = url,
		sink = ltn12.sink.file(io.open(tmpfile, "wb")), 
		step = step_func
	}
	if r == nil then
		os.remove(tmpfile)
		return e
	else
		os.rename(tmpfile, target_filename)
	end
end

local function ftp_download_file(parsed_url, target_filename, step_func)
	local tmpfile = os.tmpname()

	parsed_url.sink = --ltn12.sink.null
		ltn12.sink.file(io.open(tmpfile, "wb")) 
	parsed_url.step = step_func
	
	local r, e, h = socket.ftp.get(parsed_url)
	if r == nil then
		os.remove(tmpfile)
		return e
	else
		os.rename(tmpfile, target_filename)
	end

end

function download_file(url, filename, filesize, report_func)
	local parsed_url = socket.url.parse(url)
	local step_func = function (src, snk)
		local chunk, src_err = src()
		if not report_func(chunk) then
			return false, 'user canceled'
		end
		local ret, snk_err = snk(chunk, src_err)
		return chunk and ret and not src_err and not snk_err, src_err or snk_err
	end
	if parsed_url.scheme == 'http' then
		return http_download_file(parsed_url, filename, step_func)
	elseif parsed_url.scheme == 'ftp' then
		return ftp_download_file(parsed_url, filename, step_func)
	else
		return "wrong url : " .. url
	end
end
