<?php

/*
  This is the starting file for PhpWiki. All this file does
   is set configuration options, and at the end of the file 
   it includes() the file lib/main.php, where the real action begins.

   This file is divided into six parts: Parts Zero, One, Two, Three,
   Four and Five. Each one has different configuration settings you 
   can change; in all cases the default should work on your system, 
   however, we recommend you tailor things to your particular setting.
*/

/////////////////////////////////////////////////////////////////////
// Part Zero: If PHP needs help in finding where you installed the
//   rest of the PhpWiki code, you can set the include_path here.
//gryu*
//ini_set('include_path', './');

define('WikiToDocbookPath', 'lib/wiki2docbook');

/////////////////////////////////////////////////////////////////////
// Part Null: Don't touch this!

define ('PHPWIKI_VERSION', '1.3.0-jeffs-hacks');
require "lib/prepend.php";
rcs_id('$Id: index.php,v 1.8 2003/06/25 08:40:59 gryu Exp $');

/////////////////////////////////////////////////////////////////////
//
// Part One:
// Authentication and security settings:
// 
/////////////////////////////////////////////////////////////////////

// If set, we will perform reverse dns lookups to try to convert the users
// IP number to a host name, even if the http server didn't do it for us.
define('ENABLE_REVERSE_DNS', false);

// Username and password of administrator.
// Set these to your preferences. For heaven's sake
// pick a good password!

//<!-- gryu+
define('ADMIN_USER', "admin");
define('ADMIN_PASSWD', "adminps");
//--> gryu +

/*<!-- gryu+
define('ADMIN_USER', "###########");
define('ADMIN_PASSWD', "##########");
-->*/

// If true, only the admin user can make zip dumps, else
// zip dumps require no authentication.
define('ZIPDUMP_AUTH', false);

// The maximum file upload size.
define('MAX_UPLOAD_SIZE', 16 * 1024 * 1024);

// If the last edit is older than MINOR_EDIT_TIMEOUT seconds, the default
// state for the "minor edit" checkbox on the edit page form will be off.
define("MINOR_EDIT_TIMEOUT", 7 * 24 * 3600);

// Actions listed in this array will not be allowed.
//$DisabledActions = array('dumpserial', 'loadfile');

// PhpWiki can generate an access_log (in "NCSA combined log" format)
// for you.  If you want one, define this to the name of the log file.
define('ACCESS_LOG', '/tmp/wiki_access_log');


// If ALLOW_BOGO_LOGIN is true, users are allowed to login
// (with any/no password) using any userid which: 1) is not
// the ADMIN_USER, 2) is a valid WikiWord (matches $WikiNameRegexp.)
define('ALLOW_BOGO_LOGIN', true);

// The login code now uses PHP's session support.  Usually, the default
// configuration of PHP is to store the session state information in
// /tmp.  That probably will work fine, but fails e.g. on clustered
// servers where each server has their own distinct /tmp (this
// is the case on SourceForge's project web server.)  You can specify
// an alternate directory in which to store state information like so
// (whatever user your httpd runs as must have read/write permission
// in this directory):

// ini_set('session.save_path', 'some_other_directory');


/////////////////////////////////////////////////////////////////////
//
// Part Two:
// Database Selection
//
/////////////////////////////////////////////////////////////////////

//
// This array holds the parameters which select the database to use.
//
// Not all of these parameters are used by any particular DB backend.
//
$DBParams = array(
   // Select the database type:
   'dbtype' => 'SQL',
   //'dbtype' => 'dba',
   
   // For SQL based backends, specify the database as a DSN
   // The most general form of a DSN looks like:
   //
   //   phptype(dbsyntax)://username:password@protocol+hostspec/database
   //
   // For a MySQL database, the following should work:
   //
   //   mysql://user:password@host/databasename
   //
   // FIXME: My version Pear::DB seems to be broken enough that there is
   //    no way to connect to a mysql server over a socket right now.
   //'dsn' => 'mysql://guest@:/var/lib/mysql/mysql.sock/test',
//<!--
   'dsn' => 'mysql://dbuser:dbpasswd@localhost/dbwiki',
//-->   
   //'dsn' => 'pgsql://localhost/test',
   
   // Used by all DB types:

   // prefix for filenames or table names
   /* 
    * currently you MUST EDIT THE SQL file too (in the schemas/ directory
    * because we aren't doing on the fly sql generation during the
    * installation.
   */
//gryu*
   'prefix' => 'dbwiki_',
   
   // Used by 'dba'
   'directory' => "/tmp",
   'dba_handler' => 'gdbm',   // Either of 'gdbm' or 'db2' work great for me.
   //'dba_handler' => 'db2',
   //'dba_handler' => 'db3',    // doesn't work at all for me....
   'timeout' => 20,
   //'timeout' => 5
);

/////////////////////////////////////////////////////////////////////
//
// The next section controls how many old revisions of each page
// are kept in the database.
//
// There are two basic classes of revisions: major and minor.
// Which class a revision belongs in is determined by whether the
// author checked the "this is a minor revision" checkbox when they
// saved the page.
// 
// There is, additionally, a third class of revisions: author revisions.
// The most recent non-mergable revision from each distinct author is
// and author revision.
//
// The expiry parameters for each of those three classes of revisions
// can be adjusted seperately.   For each class there are five
// parameters (usually, only two or three of the five are actually set)
// which control how long those revisions are kept in the database.
//
//   max_keep: If set, this specifies an absolute maximum for the number
//             of archived revisions of that class.  This is meant to be
//             used as a safety cap when a non-zero min_age is specified.
//             It should be set relatively high, and it's purpose is to
//             prevent malicious or accidental database overflow due
//             to someone causing an unreasonable number of edits in a short
//             period of time.
//
//   min_age:  Revisions younger than this (based upon the supplanted date)
//             will be kept unless max_keep is exceeded.  The age should
//             be specified in days.  It should be a non-negative,
//             real number,
//
//   min_keep: At least this many revisions will be kept.
//
//   keep:     No more than this many revisions will be kept.
//
//   max_age:  No revision older than this age will be kept.
//
// Supplanted date:  Revisions are timestamped at the instant that they cease
// being the current revision.  Revision age is computed using this timestamp,
// not the edit time of the page.
//
// Merging: When a minor revision is deleted, if the preceding revision is by
// the same author, the minor revision is merged with the preceding revision
// before it is deleted.  Essentially: this replaces the content (and supplanted
// timestamp) of the previous revision with the content after the merged minor
// edit, the rest of the page metadata for the preceding version (summary, mtime, ...)
// is not changed.
//
// Keep up to 8 major edits, but keep them no longer than a month.
$ExpireParams['major'] = array('max_age' => 32,
                               'keep'	   => 8);
// Keep up to 4 minor edits, but keep them no longer than a week.
$ExpireParams['minor'] = array('max_age' => 7,
                               'keep'    => 4);
// Keep the latest contributions of the last 8 authors up to a year.
// Additionally, (in the case of a particularly active page) try to keep the
// latest contributions of all authors in the last week (even if there are
// more than eight of them,) but in no case keep more than twenty unique
// author revisions.
$ExpireParams['author'] = array('max_age'  => 365,
                                'keep'     => 8,
                                'min_age'  => 7,
                                'max_keep' => 20);

/////////////////////////////////////////////////////////////////////
// 
// Part Three:
// Page appearance and layout
//
/////////////////////////////////////////////////////////////////////

// Select your language/locale - default language "C": English
// other languages available: Dutch "nl", Spanish "es", German "de",
// Swedish "sv", and Italian, "it".
//
// Note that on some systems, apprently using these short forms for
// the locale won't work.  On my home system 'LANG=de' won't result
// in german pages.  Somehow the system must recognize the locale
// as a valid locale before gettext() will work, i.e., use 'de_DE',
// 'nl_NL'.
$LANG='C';
//$LANG='nl_NL';

// Setting the LANG environment variable (accomplished above) may or
// may not be sufficient to cause PhpWiki to produce dates in your
// native language.  (It depends on the configuration of the operating
// system on your http server.)  The problem is that, e.g. 'de' is
// often not a valid locale.
//
// A standard locale name is typically of  the  form
// language[_territory][.codeset][@modifier],  where  language is
// an ISO 639 language code, territory is an ISO 3166 country code,
// and codeset  is  a  character  set or encoding identifier like
// ISO-8859-1 or UTF-8.
//
// You can tailor the locale used for time and date formatting by setting
// the LC_TIME environment variable.  You'll have to experiment to find
// the correct setting:
//putenv('LC_TIME=de_DE');

// If you specify a relative URL for the CSS and images,
// the are interpreted relative to DATA_PATH (see below).
// (The default value of DATA_PATH is the directory in which
// index.php (this file) resides.)

//   ̸

define('HOME_PAGE', '빮');

// CSS  ġ
//
// CSS  ġԴϴ. index.php ִ   
//ġ ϸ ˴ϴ. ⺻ dbwiki.css Դϴ.
define("CSS_URL", "dbwiki.css");

//ΰ ̹ ġ.  index.php 
$logo = "images/dbwiki.png";


// ¥, ð . PHP strftime Լ ̴ Ͱ  Դϴ.
// http://www.php.net/manual/en/function.strftime.php .
$datetimeformat = "%m %e(%Y) %r ";	// ð   
$dateformat = "%m %e(%Y) ";	// ð ϸ   .

//   (  )
define("NUM_RELATED_PAGES", 5);

// ø ϵ. index.php .
$templates = array("BROWSE" =>    "templates/dbwikibrowse.html",
		   "EDITPAGE" =>  "templates/editpage.html",
		   "MESSAGE" =>   "templates/message.html",
		   "HTMLSOURCE" => "templates/htmlsource.html",
		   "DOCBOOKSOURCE" => "templates/docbooksource.html"
		   );

/* WIKI_PGSRC -- specifies the source for the initial page contents
 * of the Wiki.  The setting of WIKI_PGSRC only has effect when
 * the wiki is accessed for the first time (or after clearing the
 * database.) WIKI_PGSRC can either name a directory or a zip file.
 * In either case WIKI_PGSRC is scanned for files --- one file per page.
 */
//define('WIKI_PGSRC', "pgsrc"); // Default (old) behavior.
define('WIKI_PGSRC', 'pages.zip'); // New style.
//define('WIKI_PGSRC', '../../../Logs/Hamwiki/hamwiki-20010830.zip'); // New style.

// DEFAULT_WIKI_PGSRC is only used when the language is *not*
// the default (English) and when reading from a directory:
// in that case some English pages are inserted into the wiki as well
// DEFAULT_WIKI_PGSRC defines where the English pages reside 
// FIXME: is this really needed?  Can't we just copy
//  these pages into the localized pgsrc?
//define('DEFAULT_WIKI_PGSRC', "pgsrc");
// These are the pages which will get loaded from DEFAULT_WIKI_PGSRC.	
//$GenericPages = array("ReleaseNotes", "SteveWainstead", "TestPage");

/////////////////////////////////////////////////////////////////////
//
// Part four:
// Mark-up options.
// 
/////////////////////////////////////////////////////////////////////

// allowed protocols for links - be careful not to allow "javascript:"
// URL of these types will be automatically linked.
// within a named link [name|uri] one more protocol is defined: phpwiki
$AllowedProtocols = "http|https|mailto|ftp|news|gopher";

// URLs ending with the following extension should be inlined as images
$InlineImages = "png|jpg|gif";

// Perl regexp for WikiNames ("bumpy words")
// (?<!..) & (?!...) used instead of '\b' because \b matches '_' as well
//gryu+
$WikiNameRegexp = "(?<![0-9A-Za-z])([A-Z][a-z]+){2,}(?![0-9A-Za-z])";
//gryu- $WikiNameRegexp = "(?<![[:alnum:]])([[:upper:]][[:lower:]]+){2,}(?![[:alnum:]])";


// InterWiki linking -- wiki-style links to other wikis on the web
//
// Intermap file for InterWikiLinks -- define other wikis there
// Leave this undefined to disable InterWiki linking.
define('INTERWIKI_MAP_FILE', "lib/interwiki.map");

/////////////////////////////////////////////////////////////////////
//
// Part five:
// URL options -- you can probably skip this section.
//
/////////////////////////////////////////////////////////////////////
/******************************************************************
 *
 * The following section contains settings which you can use to tailor
 * the URLs which PhpWiki generates. 
 *
 * Any of these parameters which are left undefined will be
 * deduced automatically.  You need only set them explicitly
 * if the auto-detected values prove to be incorrect.
 *
 * In most cases the auto-detected values should work fine,
 * so hopefully you don't need to mess with this section.
 *
 ******************************************************************/

/*
 * Canonical name and httpd port of the server on which this
 * PhpWiki resides.
 */
//define('SERVER_NAME', 'some.host.com');
//define('SERVER_PORT', 80);

/*
 * Absolute URL (from the server root) of the PhpWiki
 * script.
 */
//define('SCRIPT_NAME', '/dbwiki/index.php');

/*
 * Absolute URL (from the server root) of the directory
 * in which relative URL's for images and other support files
 * are interpreted.
 */
//define('DATA_PATH', '/some/where');

/*
 * Define to 'true' to use PATH_INFO to pass the pagename's.
 * e.g. http://www.some.where/index.php/HomePage instead
 * of http://www.some.where/index.php?pagename=HomePage
 * FIXME: more docs (maybe in README).
 */
//define('USE_PATH_INFO', false);

/*
 * VIRTUAL_PATH is the canonical URL path under which your
 * your wiki appears.  Normally this is the same as
 * dirname(SCRIPT_NAME), however using, e.g. apaches mod_actions
 * (or mod_rewrite), you can make it something different.
 *
 * If you do this, you should set VIRTUAL_PATH here.
 *
 * E.g. your phpwiki might be installed at at /scripts/phpwiki/index.php,
 * but  * you've made it accessible through eg. /wiki/HomePage.
 *
 * One way to do this is to create a directory named 'wiki' in your
 * server root.  The directory contains only one file: an .htaccess
 * file which reads something like:
 *
 *    Action x-phpwiki-page /scripts/phpwiki/index.php
 *    SetHandler x-phpwiki-page
 *    DirectoryIndex /scripts/phpwiki/index.php
 *
 * In that case you should set VIRTUAL_PATH to '/wiki'.
 *
 * (VIRTUAL_PATH is only used if USE_PATH_INFO is true.)
 */
//define('VIRTUAL_PATH', '/dbwiki/index.php');

include "lib/config.php";

if ( USE_PATH_INFO && $_SERVER['PATH_INFO'] == '' )
{
	header("Location: index.php/");
	exit;
}

////////////////////////////////////////////////////////////////
// Okay... fire up the code:
////////////////////////////////////////////////////////////////
include "lib/main.php";

// (c-file-style: "gnu")
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
?>
