<?php
// (c-file-style: "gnu")
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
// $Id: w2d_transform.php,v 1.3 2004/01/07 04:19:03 gryu Exp $

define("END_LINE", "\n");
$FieldSeparator = "\x81";
define ('TAB_SIZE', 1);

class Wiki2DocBookTransform
{
	var $Formatters;
	var $InlineFormatters;
	var $FirstLetters;
	var $Params;
	var $Tokens;
	var $TokenId;
	// 
	function Wiki2DocBookTransform()
	{
		$this->Formatters = array();
		$this->FirstLetters = array();
		$this->InlineFormatters = array();
		$this->Tokens = array();
		$this->TokenId = 0;
	}

	function register($first, $func)
	{
		$this->FirstLetters[] = $first;
		$this->Formatters[$first] = $func;
	}
	
	function registerInline($func)
	{
		$this->InlineFormatters[] = $func;
	}
	
	function formatInline($line)
	{
		$line = htmlspecialchars($line);
		foreach($this->InlineFormatters as $format)
		{
			$line = $format($line, $this);
		}
		return $line;
	}

	function addToken($str)
	{
		global $FieldSeparator;
		$this->TokenId++;
		$key = $FieldSeparator.$this->TokenId.$FieldSeparator;
		$this->Tokens[$key] = $str;
		
		return $key;
	}

	function untokenize(&$str)
	{
		global $FieldSeparator;
		if ( is_array($this->Tokens) )
		{
			$keys = array_keys($this->Tokens);
			$values = array_values($this->Tokens);
			$str = str_replace($keys, $values, $str);
		}
	}	
		
	function maketabs($level)
	{
		$result = '';
		if ($level > 0)
			$result = str_repeat($this->Params['IndentChar'], $level);
		return $result;
	}

	
	function do_transform($html, $content)
	{
		global $FieldSeparator;
		$this->Params['prevSectionLevel'] = 0;
		// Loop over all lines of the page and apply transformation rules

		$isParaStarted = false;
		reset($content);
		$line = current($content);
		do 
		{
			$first = substr($line, 0, 1);
			if (in_array($first, $this->FirstLetters) )
			{
				$indent = $this->Params['indent'];
				$result= $this->Formatters[$first]($content, $this);
				if ($result != '') 
				{
					if ($isParaStarted)
					{
						$html .= $indent ."</para>\n";
						$isParaStarted = false;
					}

					$html .= $result;
					$line = next($content);
					continue;
				}
			} 
			$line = current($content); // $this->Formatters ȣ⿡  迭  Ͱ   ִ.
			$formattedLine = $this->formatInline($line);
			if ($isParaStarted)
			{
				if (strlen($line) == 0)
				{
					$html .= $this->Params['indent']."</para>\n";
					$isParaStarted = false;
				}
				else
					$html .= $this->Params['indent']. $formattedLine . END_LINE;
				}
			else
			{
				if (strlen($line) > 0)
				{
					$html .= $this->Params['indent']."<para>" . $formattedLine . END_LINE;
					$isParaStarted = true;
				}
			}
			$line = next($content);
		} while ($line !== FALSE ) ;
		
		if( $isParaStarted ) 
			$html .= $this->Params['indent']."</para>\n";
		 
		$unclosedSections = $this->Params['UnclosedSections'];

		// Ȥ       ݴ´.
		while ( !empty($this->Params['general_block']))
		{
			$indent = $this->Params['indent'];
			$closing = array_pop($this->Params['general_block']);
			$html .= "$indent</{$closing}>\n";
		}
		
		while ( $unclosedSections > 0 )
		{
			$html .= "\n" . $this->maketabs($this->Params['prevSectionLevel']-2) . "</section>\n";
			$this->Params['prevSectionLevel']--;
			$unclosedSections--;
		}

		$this->untokenize($html);
		return $html;
	} // end do_transfrom()

} // end class Wiki2DocBookTransform
?>
