<?php
// (c-file-style: "gnu")
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
// $Id: w2h_transform.php,v 1.3 2004/01/07 04:19:03 gryu Exp $

define("END_LINE", "\n");
$FieldSeparator = "\x81";
define ('TAB_SIZE', 1);

class WikiToHtmlTransform
{
	var $Formatters;
	var $InlineFormatters;
	var $FirstLetters;
	var $Params;
	var $Tokens;
	var $TokenId;
	// 
	function WikiToHtmlTransform()
	{
		$this->Formatters = array();
		$this->FirstLetters = array();
		$this->InlineFormatters = array();
		$this->Tokens = array();
		$this->TokenId = 0;
	}

	function register($first, $func)
	{
		$this->FirstLetters[] = $first;
		$this->Formatters[$first] = $func;
	}
	
	function registerInline($func)
	{
		$this->InlineFormatters[] = $func;
	}
	
	function formatInline($line)
	{
		foreach($this->InlineFormatters as $format)
		{
			$line = $format($line, $this);
		}
		return htmlspecialchars($line);
	}

	function addToken($str)
	{
		global $FieldSeparator;
		$this->TokenId++;
		$key = $FieldSeparator.$this->TokenId.$FieldSeparator;
		$this->Tokens[$key] = $str;
		
		return $key;
	}
	function replaceToken($token, $val, $str)
	{
		global $FieldSeparator;
		$key = $FieldSeparator.$token.$FieldSeparator;
		return str_replace($key, $val, $str);
	}
	function untokenize(&$str)
	{
		global $FieldSeparator;
		if ( is_array($this->Tokens) )
		{
			foreach($this->Tokens as $key => $val)
			{
				$str = str_replace($key, $val, $str);
			}
		}
	}	
		
	function maketabs($level)
	{
		$result = '';
		if ($level > 0)
			$result = str_repeat($this->Params['IndentChar'], $level);
		return $result;
	}

	
	function do_transform($html, $content)
	{
		global $FieldSeparator;
		$this->Params['prevSectionLevel'] = 0;
		// Loop over all lines of the page and apply transformation rules

		$html = '';
		$isParaStarted = false;
		reset($content);
		$line = current($content);
		do 
		{
			$first = substr($line, 0, 1);
			if (in_array($first, $this->FirstLetters) )
			{
				$result= $this->Formatters[$first]($content, $this);
				if ($result != '') 
				{
					if ($isParaStarted)
					{
						$html .= $this->Params['indent']."</p>\n";
						$isParaStarted = false;
					}

					$html .= $result;
					$line = next($content);
					continue;
				}
			} 
			$line = current($content); // $this->Formatters ȣ⿡  迭  Ͱ   ִ.
			$formattedLine = $this->formatInline($line);
			if ($isParaStarted)
			{
				if (strlen(trim($formattedLine)) == 0)
				{
					$html .= $this->Params['indent']."</p>\n";
					$isParaStarted = false;
				}
				else
					$html .= $this->Params['indent']. $formattedLine . END_LINE;
				}
			else
			{
				if (strlen(trim($formattedLine)) > 0)
				{
					$html .= $this->Params['indent']."<p>" . $formattedLine . END_LINE;
					$isParaStarted = true;
				}
			}
			$line = next($content);
		} while ($line !== FALSE ) ;
		
		if( $isParaStarted ) 
			$html .= $this->Params['indent']."</p>\n";

		// Ȥ       ݴ´.			
		while ( !empty($this->Params['general_block']))
		{
			$html .= '</div>';
			array_pop($this->Params['general_block']);
		}

		if ($this->Params['Toc']->isOn == true)
		{
			if ( count($this->Params['Toc']->RawList) > 0 )
			{
				$toc= '<table class="toc"><tr><td>' . "\n<b></b><br />\n". w2h_sublist($this->Params['Toc']->RawList, '#', 2, $this)
					 . "</td></tr></table>\n";
			}
			else 
				$toc = '';
			$html = $this->replaceToken('TOC', $toc, $html);				
		}
		$this->untokenize($html);
		
		return $html;
	} // end do_transfrom()

} // end class Wiki2DocBookTransform
?>
