unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Menus, OleCtrls, SHDocVw_TLB, EmbeddedWB,
  psvPHP, ExtCtrls, RichEditHighlight, Clipbrd;

type
  TfrmMain = class(TForm)
    psvPHP: TpsvPHP;
    PageControl: TPageControl;
    WikiView: TTabSheet;
    HTMLView: TTabSheet;
    WebBrowser: TEmbeddedWB;
    DocBookView: TTabSheet;
    btnUpdate: TButton;
    richWiki: TRichEdit;
    MainMenu1: TMainMenu;
    mmoFile: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog1: TSaveDialog;
    ReplaceDialog1: TReplaceDialog;
    mmoOpen: TMenuItem;
    mmoNew: TMenuItem;
    mmoSave: TMenuItem;
    mmoSaveAs: TMenuItem;
    mmoQuit: TMenuItem;
    richDocBook: TRichEdit;
    DocBookXML: TTabSheet;
    WbXML: TEmbeddedWB;
    PopupMenu: TPopupMenu;
    pmuCopy: TMenuItem;
    pmuPaste: TMenuItem;
    pmuCut: TMenuItem;
    pmuSelectAll: TMenuItem;
    pmuDelete: TMenuItem;
    procedure mmoCloseClick(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure richWikiChange(Sender: TObject);
    procedure btnUpdateClick(Sender: TObject);
    procedure mmoQuitClick(Sender: TObject);
    procedure mmoOpenClick(Sender: TObject);
    procedure pmuCopyClick(Sender: TObject);
    procedure pmuPasteClick(Sender: TObject);
    procedure pmuCutClick(Sender: TObject);
    procedure pmuSelectAllClick(Sender: TObject);
    procedure pmuDeleteClick(Sender: TObject);
    procedure mmoSaveClick(Sender: TObject);
    procedure mmoSaveAsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;
  WikiTextChanged : Boolean;
  TempHtmlFilePath : String;
  TempXmlFilePath : String;
  WikiFilePath: String;

implementation

{$R *.dfm}

procedure TfrmMain.mmoCloseClick(Sender: TObject);
begin
    WebBrowser.Stop;
    frmMain.Close;
end;

procedure TfrmMain.PageControlChange(Sender: TObject);

begin
    if WikiTextChanged then
    begin
        btnUpdateClick(Sender);
        WikiTextChanged := false;
    end;

end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
    AppPath : String;
begin
    WikiTextChanged := true;
    AppPath := ExtractFilePath(Application.ExeName);
    TempHtmlFilePath := AppPath + 'temp.html';
    TempXmlFilePath := AppPath + 'temp.xml';
    PageControl.ActivePageIndex := 0;
end;

procedure TfrmMain.richWikiChange(Sender: TObject);
begin
    WikiTextChanged := true;
end;

procedure TfrmMain.btnUpdateClick(Sender: TObject);
var
    Lines : TStringList;
    strTemp : String;
begin

    psvPHP.FileName := ExtractFilePath(Application.Exename) + 'scripts\\html.php';
    // #129  . PHP ũƮ $FieldSeparator ش
    strTemp := StringReplace(richWiki.Text,
            '&', #129'amp'#129, [rfReplaceAll, rfIgnoreCase]);

    strTemp := StringReplace(strTemp,
            '+', #129'plus'#129, [rfReplaceAll, rfIgnoreCase]);


    psvPHP.Variables.Items[0].Value := strTemp;

    Lines := TStringList.Create;
    Lines.Text := psvPHP.Execute;
    Lines.SaveToFile(TempHtmlFilePath);

    WebBrowser.Navigate(TempHtmlFilePath);

    psvPHP.FileName := ExtractFilePath(Application.Exename) + 'scripts\\docbook.php';
    psvPHP.Variables.Items[0].Value := strTemp;
    richDocBook.Clear;
    strTemp := psvPHP.Execute;
    richDocBook.Text := strTemp;
    Lines.Text := strTemp;
    Lines.SaveToFile(TempXmlFilePath);
    WbXML.Navigate(TempXmlFilePath);
    Lines.Free;
end;



procedure TfrmMain.mmoQuitClick(Sender: TObject);
begin
    WebBrowser.Stop;
    frmMain.Close;
end;

procedure TfrmMain.mmoOpenClick(Sender: TObject);

begin
    if(OpenDialog.Execute ) then
    begin
        richWiki.Lines.LoadFromFile( OpenDialog.FileName );
        WikiFilePath := OpenDialog.FileName;
        PageControl.ActivePage := WikiView;
    end;

end;

procedure TfrmMain.pmuCopyClick(Sender: TObject);
var CurrentRichEditPtr: ^TRichEdit;
begin
    if (PageControl.ActivePageIndex = 2)  then //DocBookXML 
        CurrentRichEditPtr := @richDocBook
    else
        CurrentRichEditPtr := @richWiki;

    CurrentRichEditPtr.CopyToClipboard;
end;

procedure TfrmMain.pmuPasteClick(Sender: TObject);
var CurrentRichEditPtr: ^TRichEdit;
begin
    if (PageControl.ActivePageIndex = 2)  then //DocBookXML 
        CurrentRichEditPtr := @richDocBook
    else
        CurrentRichEditPtr := @richWiki;

    CurrentRichEditPtr.PasteFromClipboard;
end;

procedure TfrmMain.pmuCutClick(Sender: TObject);
var CurrentRichEditPtr: ^TRichEdit;
begin
    if (PageControl.ActivePageIndex = 2)  then //DocBookXML 
        CurrentRichEditPtr := @richDocBook
    else
        CurrentRichEditPtr := @richWiki;

    CurrentRichEditPtr.CutToClipboard;
end;

procedure TfrmMain.pmuSelectAllClick(Sender: TObject);
var CurrentRichEditPtr: ^TRichEdit;
begin
    if (PageControl.ActivePageIndex = 2)  then //DocBookXML 
        CurrentRichEditPtr := @richDocBook
    else
        CurrentRichEditPtr := @richWiki;
    CurrentRichEditPtr.SelectAll;
end;

procedure TfrmMain.pmuDeleteClick(Sender: TObject);
var CurrentRichEditPtr: ^TRichEdit;
begin
    if (PageControl.ActivePageIndex = 2)  then //DocBookXML 
        CurrentRichEditPtr := @richDocBook
    else
        CurrentRichEditPtr := @richWiki;

    CurrentRichEditPtr.SelText := '';
end;

procedure TfrmMain.mmoSaveClick(Sender: TObject);
begin
    if (WikiFilePath = '') then
        mmoSaveAsClick(Sender)
    else
        richWiki.Lines.SaveToFile(WikiFilePath);
end;

procedure TfrmMain.mmoSaveAsClick(Sender: TObject);
begin
    if SaveDialog1.Execute then
    begin
        richWiki.Lines.SaveToFile(SaveDialog1.FileName);
        WikiFilePath := SaveDialog1.FileName;
    end;
end;

end.
