<?php
/**
 * DBClient
 *
 * @package php.db
 */

/**
 * DB ڿ  ߻ ŬԴϴ.
 *
 * <code>
 *  // DB  
 *  $db = db_('mssql', 'test_db', true);
 * 
 *  // Ÿ Ÿ  
 *  $data = $db->getMetaData("table");
 *  echo $data->top(1);
 *
 *  // ν  
 *	$db->spName('test');
 *	$db->spBind('aaa', 'int', 3, $is_output);     
 *	$db->spBind('bbb', 'int', 3, 'return', $var); 
 *
 *	$db->spSet('aaa', 10);
 * 
 *	$db->spExecute();
 *
 *	echo $db->spGet('bbb');
 *	print_r($db->spGetParameters());
 *
 *  // DB  
 *  $db->close();
 *
 * </code>
 *
 * @package php.db
 * @see DB_()
 */
abstract class DBClient extends PObject {

	/**
	 * Ӽ  
	 *
	 * program, host, port, id, pass, db, schema, version 
	 * 
	 */
	private $__attribute = array();

	/**
	 *  resource
	 *
	 * @var resource
	 */
	private $__con;

	/**
	 * ResultSet 
	 *
	 * @var resource
	 */
	private $__db_result;

	/**
	 * Statement
	 *
	 * @var resource
	 */
	private $__db_statement;


	/**
	 *     
	 *
	 * @var resource
	 */
	private $__db_exec;


	/**
	 * ν ̸
	 *
	 * @var string
	 */
	protected $__sp_name;


	/**
	 * ε õ ɼ 
	 *
	 * type : ε Ÿ, proc, sql, insert, delete, update
	 * 
	 * @var array 
	 */
	protected $__sp_option = array();


	/**
	 * ν  Ʈ 
	 *
	 * @var array
	 */
	protected $__sp_bind_list = array();

	/**
	 * ν  resource
	 *
	 * @var resource
	 */
	protected $__sp_execute_result = null;

	/**
	 * ν  resource
	 *
	 * @var resource 
	 */
	protected $__sp_statement = null;

	
	/**
	 *  sql  
	 *
	 */ 
	private $__sql_history = array();

	/*
	 *  
	 *
	 * Ӽ  
	 *
	 * @param string|array $option  db ϸ Ǵ dbȯ 迭 
	 */
	public function __construct($option = '')  {
		if (gettype($option) == 'string') { 
			$this->setConfig($option);				// ini  о 
		} else if (gettype($option) == 'array'){ 
			$this->set($option);					// ɼ ü  
		}
	}

	/**
	 * Ҹ 
	 * 
	 */
	public function __destruct() { 
		// db Ǿ  db  ݴ´ 
		if ($this->isConnected()) { 
			$this->close();
		}
		// ޸  ؼ Լ  
	}

	/**
	 * Ӽ о , getAttribute()   Դϴ. 
	 *
	 * ex) echo $dbclient->program;
	 * 
	 * @param	string $key   ̸ 
	 * @return	mixed
	 *
	 */
	public function __get($key) { 
		return $this->__attribute[strtolower($key)];
	}

	/**
	 * Ӽ ϱ , setAttribute()   Դϴ. 
	 *
	 * ex) $dbclient->program = "mssql";
	 * 
	 * @param	string $key	Ӽ ̸
	 * @param	mixed $value Ӽ
	 * @return	mixed
	 *
	 */
	public function __set($key, $value) { 
		$this->__attribute[strtolower($key)] = $value;
	}

	/**
	 *  ࿡   row  
	 *
	 * @return	int
	 */
	public function affectedRows() { return 0; }

	/**
	 * Ʈ  
	 *
	 * @access public
	 * @return bool ۵Ǿ true, ƴϸ false 
 	 */
	public function begin() { return true; }

	/**
	 * 
	 * 
     * @return DBClient  ü
	 */
	public function connect() 
	{
		//  
		$this->setConnection($this->_connect());

		// ɼ  ,  DB °  
		if ($this->getConnection()) $this->runOption();

		// йȣ 
		$this->id	= "";
		$this->pass = "";

		return $this;
	}

	/**
	 * ɼ  
	 *
	 *  ̿  ɼ ڵ Ѵ. 
	 * 
	 * DB ° ּ. 
	 * 
	 */
	public function runOption() { 
		return true;
	}

	/**
	 *  resource ȯ
	 * 
     * @return resource
	 */
	public function getConnection() { 
		return $this->__con;
	}

	/**
	 *  resource 
	 * 
	 */
	public function setConnection($con) { 
		$this->__con = $con;
	}

	/**
	 * ó   
	 * 
     * @return resource
	 */
	public function getExecute() { 
		return $this->__db_exec;
	}

	/**
	 * ó 
	 * 
	 */
	public function setExecute($exec) { 
		$this->__db_exec = $exec;
	}


	/**
	 *    
	 * 
	 * @return resource 
	 */
	public function getResult($result = null) {
		return ($result) ? $result : $this->__db_result;
	}

	/**
	 * ⺻  
	 * 
	 * @param resource $result 
	 */
	public function setResult($result) { 
		$this->__db_result = $result;
	}

	public function getStatement() { 
		return $this->__db_statement;
	}

	public function setStatement($stmt) { 
		$this->__db_statement = $stmt;
	}


	/**
	 * commit 
	 * 
	 */
	public function commit() { }


	/**
	 * ݱ
	 * 
	 * @return bool 
	 */
	public function close()
	{ 
		return true;
	}

	/**
	 *    
	 * 
	 * @static 
	 * @param	string $dbClass	database  (mysql, mssql, oracle, progres, cubrid, sqlite)
	 * @param string|array $db db ϸ Ǵ dbȯ 迭 
	 * @param	bool $isConnect database   , ̸ true , ⺻ false 
	 * @return	DBClient		DBClient  Ŭ
	 */
	public static function createConnector($dbClass, $db, $isConnect = false) {

		$obj = null;

		if (class_exists($dbClass)) { 
			$obj = new $dbClass($db);

			if ($isConnect) $obj->connect();
		} 

		return $obj;
	}

	/**
	 * DBData ü  
	 * 
	 * @param	resource $resource	 ҽ
	 * @return	DBData
	 */
	public function createData($result) {
		// ⺻ Data Ŭ ϰ 
		// Data Ŭ  ٸ Data Ŭ ϸ ȴ. 

		$data = new DBData($this);

		if (!$result)
			return $data;

		$data->setFields($this->getFieldList($result));
		//$data->setTypeList($this->getFieldTypeList($result));
		$data->setRows($this->fetchAll($result));

		return $data;
	}



	/**
	 * 
	 * 
	 * @param unknown_type $table
	 * @return unknown_type
	 * @deprecated
	 */
	public function deleteFrom($table) { 
		return $this->query("delete from {$table}");
	}

	/**
	 *  
	 * 
	 */
	public function error() { return ""; } 

	/**
	 *  DB ڿ escape	
	 * 
	 * @param string $str  escape  ڿ 
	 * @return string escape  ڿ
	 */
	public function escape($str) { 
		return str_replace("'", "''", $str);
	}

	/**
	 * ü ڵ 
	 *
	 * @param	resource $result  
	 * @return	array	ڵ迭 
	 */
	public function fetchAll($result) {
		$temp = array();

		while($row = $this->fetch($result)) { 
			$temp[] = array_change_key_case($row, CASE_LOWER);
		}
		
		return $temp;	
	} 


	/**
	 * DBData  
	 * 
	 * @param	string $query DB query
	 * @param	boolean $isOne ε ĭ ű
	 * @return	DBData 
	 */
	public function getData($query, $isOne = false) 
	{
		$this->query($query);

		$data = $this->createData($this->getResult());

		if (!$this->getResult())  
			$this->free($this->getResult());

		if ($isOne) 
			$data->next();

		return $data;
	}
	
	/**
	 * paging  DBData  
	 * 
	 * @param string $query
	 * @param int $page default 1 
	 * @param int $count default 10 
	 * @return DBData
	 */
	abstract function getPageData($query, $page, $count = 10) ;
	
	/**
	 * Ѱ¥ Record   
	 * 
	 * @param string $query
	 * @param string $baseClass
	 * @return DBData
	 */
	public function getOne($query) { 
		return $this->getData($query, true);
	}
	
	/**
	 * sql id    
	 * 
	 * @param string $id
	 * @param array $param
	 * @return int
	 */
	public function sql($id, $param = array()) { 
		return $this->query($this->getSqlTemplate($id, $param));
	}
	
	/**
	 * sql id  DBData   
	 * 
	 * @param string $id
	 * @param array $param
	 * @return DBData
	 */
	public function sqlData($id, $param = array()) { 
		return $this->getData($this->getSqlTemplate($id, $param), false);
	}
	
	/**
	 * sql id  ¡ DBData  
	 * 
	 * @param string $id
	 * @param array $param
	 * @return DBData
	 */
	public function sqlPage($id, $param = array()) { 
		return $this->getPageData($this->getSqlTemplate($id, $param), d_($param['page'], 1), d_($param['count'], 10));
	}

	/**
	 * sql id  DBData   
	 * 
	 * @param string $id
	 * @param array $param
	 * @return DBData
	 */
	public function sqlOne($id, $param = array()) { 
		return $this->getOne($this->getSqlTemplate($id, $param));
	}

	/**
	 * result set   ¿ ٷ DBData ü  
	 * 
	 * @param bool $isOne true : ĭ 
	 * @param string $baseClass Ŭ ̸ 
	 * @return DBData
	 */
	public function getBindData($isOne = false) {

		$data = $this->createData($this->getResult());

		if ($isOne) 
			$data->next();

		return $data;
	}

	/**
	 *  
	 * 
	 * @param	int $total ü 
	 * @param	int $limitPage   Ʈ 
	 * @param	int $limitBlock   
	 * @return	array		count : ü, page :  , block :   
	 */
	public function getPageCount($total, $limitPage, $limitBlock) { 
		$count	= $total;
		$page	= ceil($count/$limitPage);
		$block	= ceil($page/$limitBlock);

		$temp = array('count'=>$count, 'page'=>$page, 'block'=>$block);

		return $temp;		
	}

	/**
	 *   
	 * 
	 * @param	string $sql	  
	 * @param	int $limitPage   Ʈ 
	 * @param	int $limitBlock   
	 * @return	array count : ü, page :  , block :   
	 */
	public function getPageCountSubquery($sql, $limitPage, $limitBlock) {
		$sql = "SELECT COUNT(*) as cnt FROM ( $sql )";

		return $this->getPageCountQuery($sql, $limitPage, $limitBlock);
	}

	/**
	 * Ϲ  
	 *
	 * count(*)  alias cnt  ؾ  .
	 * 
	 * @param	string $sql	Ϲ  
	 * @param	int $limitPage   Ʈ 
	 * @param	int $limitBlock	  
	 * @return	array	count : ü, page :  , block :   
	 */
	public function getPageCountQuery($sql, $limitPage, $limitBlock) {
		$data = $this->getData($sql, true);

		return $this->getPageCount($data->get('cnt', 0), $limitPage, $limitBlock);
	}

	/**
	 * Ǿ  ؼ ʵ帮Ʈ  ´. 
	 * DBDataü   Ǿ  
	 *
	 * @param	resource $result    
	 * @return	array			
	 */
	public function getFieldList($result) {
		// ʵ Ʈ  
		$ncols = $this->getFieldCount($result);

		$arr = array();
		for ($i = 0; $i < $ncols; $i++) {
			$arr[] = $this->getFieldName($result, $i);
		}		

		return $arr;
	}



	/**
	 * Ǿ  ؼ ʵ Ÿ Ʈ  ´. 
	 * DBDataü   Ǿ  
	 *
	 * @param	resource $result    
	 * @return	array			
	 */
	public function getFieldTypeList($result) { 
		// ʵ Ʈ  
		$ncols = $this->getFieldCount($result);

		$arr = array();
		for ($i = 0; $i < $ncols; $i++) {
			$arr[] = $this->getFieldType($result, $i);
		}		

		return $arr;
	}

	/**
	 * ʵ Ÿ(ڷ) php    
	 *
	 * @param string $type ŸԹڿ 
	 * @return int|string PHP
	 */
	public function getTypeConstant($type) { 
		return $type;
	}

	/**
	 * ʵ Ÿ(ڷ) DB Էµ  ִ ڿ  
	 *
	 * @param string $type ŸԹڿ 
	 * @param mixed $value Է°
	 * @param boolean $is_null  üũ   , true üũ, false  üũ  
	 * @return string ȯ ڿ
	 */
	public function getTypeString($type, $value, $is_null = false ) {
		return ($is_null & is_null($value)) ? 'NULL' : sprintf("'%s'", $this->escape($value));
	}

	/**
	 * getTypeString Ī 
	 *
	 * @param string $type ŸԹڿ 
	 * @param mixed &$value Է°
	 * @param boolean $is_null  üũ   , true üũ, false  üũ  
	 * @return string ȯ ڿ
	 */	
	public function ts($type, &$value, $is_null = false ) { 
		$value = $this->getTypeString($type, $value, $is_null);

		return $value;
	}

	/**
	 *  Ÿ Ÿ 
	 * 
	 * <pre>
	 *   : php/db/meta/
     *   : {ŸŸ}Data_{program}{version}.php 
	 * </pre>
	 *
	 * <code>
	 * 	    //   db  ̺ Ʈ Dataü ȯ
	 * 		$db->getMetaData('table');					
	 * 
	 *		// ־ ̺ ؼ ε Ʈ Dataü ȯ
	 *		$db->getMetaData('index', '̸̺');	
	 * 
	 * 		// ־ ̺ ؼ ÷ Ʈ Dataü ȯ
	 *		$db->getMetaData('column', '̸̺');	
	 * 
	 * </code>
	 *
	 * @param string $meta_type  ŸŸ Ÿ  (table, database, column, index, job, param, proc, view, serial, etc)
	 * @param string $object ü ̸ 
	 * @param array $option    ɼ, DB Ʋ 
	 * @return	DBData 
	 */
	public function getMetaData($meta_type = 'table', $object = '', $option = array()) {

		//  ̸ 
		$filename = sprintf("%sData_%s%s.php", ucwords($meta_type), strtoupper($this->program), $this->version );

		// ŸData ʿ  
		$meta_info = array(
			'schema_name'	=> $this->escape($this->schema),
			'object_name'	=> $this->escape($object),
			'db_name'		=> $this->escape($this->db),
			'option'		=> $option
		);

		///  н  
		$path = LIB.str_replace('/', DIRECTORY_SEPARATOR, "php/db/meta/").$filename;
	
		// Ÿ sql о
		if (file_exists($path)) {
			return include $path;
		} else { 
			return dbdata_($this);
		}
	}
	
	/**
	 * SQL ø  
	 *
	 * @param string $id sql  ̵ 
	 * @param array $data sql ø   ʿ Ÿ 
	 *
	 */
	public function getSqlTemplate($id, $param = array()) { 
		$filename = str_replace('.', '/', $id).".php";
		
		$path = LIB."sql/".$filename;
		
		if (file_exists($path)) { 
			return include $path;
		} else { 
			trigger_error("file not exists : ".$id, E_USER_ERROR);
			return ""; 
		}
	}

	/**
	 *  DB Ȯϱ 
	 *
	 * <code>
	 * if ($dbclient->is('mssql')) { 
	 *    echo "database is mssql";
	 * } 
	 *
	 * if ($dbclient->is('mysql', '5')) { 
     *    echo "current version : mysql 5" ;
	 * }
	 * </code>
	 *
	 * @param	string $db_name	Ÿ̽  (mysql, mssql, oracle, postgres, cubrid, sqlite)
	 * @param	string $version	Ӽ
	 * @return	boolean			
	 *
	 */
	public function is($db_name, $version = '') { 
		if (!$version) { 
			return ($this->program == strtolower($db_name));
		} else { 
			return ($this->program == strtolower($db_name) && $this->version == $version);
		}
	}

	/**
	 * Ǿ ִ θ ˷
	 *
	 * @access public 
	 * @return bool Ǿ  true, ƴϸ false 
	 */
	public function isConnected() { 
		return ($this->getConnection()) ? true : false ;
	}

	/**
	 * rollback
	 * 
	 */
	public function rollback() { }


	/**
	 * result set ̵ 
	 *
	 * @param	int $count ̵ row  
	 */
	public function seek($count) { }

	/**
	 * ἳ
	 * 
	 * @param	array $option   ̸ 
	 *
	 */
	public function set($option = array())
	{
		$this->__attribute = $option;
	}

	/**
	 * ἳ,  /php/db/conf/{name}.ini Ͽ   
	 * 
	 * program : dbα׷ 
	 * host : db ּ <br >
	 * port : Ʈ <br >
	 * id   : ̵ <br > 
	 * pass : йȣ  <br >
	 * db   : db ̸  <br >
	 * version :  <br >
	 * schema  : Ű  <br >
	 * 
	 * db  ݾ Ʋϴ. 
	 * 
	 * @param string $name   ̸ 
	 * @param string $type $type  ´   
	 */
	public function setConfig($name, $type = 'default') { 
		$name		= strtolower($name);

		$path = LIB."php/db/conf/{$name}.ini";

		if (!file_exists($path)) return; 

		$arr = parse_ini_file($path, true);

		$key = ($type == 'default') ? $name : $type;

		$this->set($this->getProperty($arr[$key]));
	}

	/**
	 * Ӽ 
	 * 
	 * @param  array $arr db   
	 * @return array   ͸ ϰ Ѱش. 
	 */
	public function getProperty($arr) { 

		foreach ($arr as $key => $value) { 
			$arr[$key]	 = str_replace("{LIB}", LIB, $value);
		}

		return $arr;
	}

	/**
	 * ε Ʈ  
	 *
	 * @param string $name ε ̸ 
	 * @param string $type ε Ÿ, Ÿ̽  Ʋ 
	 * @param string $output output , in, out, inout, return 
	 * @param int $length Ÿ, -1  
	 * @param mixed &$value  Ÿ Ǵ output   Ÿ
	 * @param array $option ε ɶ Ÿ ɼ 
	 *                      update : bool, Ʈ ʵ 
	 *                      op :  , "and", "or"
	 * @deprecated
	 * @see DBProc::bind()
	 */
	public function spBind($name, $type = '', $output = 'in', $length = -1, &$value = null , $option = array()) {

		$this->__sp_bind_list[strtolower($name)] = array(
			'name'		=> $name,
			'type'		=> strtolower($type),
			'output'	=> strtolower($output),
			'length'	=> $length,
			'value'		=> $value,
			'option'	=> $option,
		);
	}



	/**
	 * ν  
	 *
	 *  Ŭ ϴ Ŭ spExecute ޼ҵ带 ؼ ν    ֽϴ.
	 * 
	 * @deprecated
	 * @see DBProc::execute()
	 */
	public function spExecute()  {}

	/**
	 * Ķ   
	 * 
	 * @param string $name Ķ ̸ 
	 * @return mixed spBind ߴ $value   ɴϴ.
	 * @deprecated
	 * @see DBProc::get() 
	 */
	public function spGet($name) {
		return $this->__sp_bind_list[strtolower($name)]['value'];
	}	

	/**
	 * Ķ Ʈ  
	 * 
	 * @return array ε ̸  value  迭 մϴ.
	 * @deprecated
	 * @see DBProc::gets()
	 */
	public function spGetParameters() {
		$temp = array();

		foreach ($this->__sp_bind_list as $key => $arr) { 
			$temp[$key] = $arr['value'];
		}

		return $temp;
	}

	/**
	 * ν ̸ 
	 * 
	 * @param string $str  or ν ̸
	 * @param string|array $option ε  ɼ Ѵ. type : ε  Ÿ, proc,sql,insert,update,delete   ̴.
	 * @deprecated
	 * @see DBProc::name() 
	 */
	public function spName($str, $option = 'proc')  {

		if (is_string($option)) { 
			$option = array('type' => $option);
		}

		$this->__sp_name = $str;
		$this->__sp_option = $option;
	}

	/** 
	 * Ķ   
	 * 
	 * @param string $name ε ̸ 
	 * @param mixed $value	ε ̸  Ÿ
	 * @deprecated
	 * @see DBProc::set() 
	 */
	public function spSet($name, $value) {
		$this->__sp_bind_list[strtolower($name)]['value'] = $value;	
	}

	/** 
	 * Ķ Ʈ  
	 *
	 * @param array $arr ε    մϴ.
	 * @deprecated
	 * @see DBProc::sets()
	 */
	public function spSetParameters($arr) {
		foreach ($arr as $key => $value) { 
			$this->spSet($key, $value);
		}
	}


	/**
	 *  ҽ 
	 * 
	 * @return	resource		 ҽ 
	 */
	abstract protected function _connect();

	/**
	 * ޸ 
	 *
	 * @param	resource $result   
	 */
	abstract public function free($result) ;


	/**
	 * ڵ 
	 *
	 * @param	resource $result  
	 * @return	array
	 */
	abstract public function fetch($result) ;


	/**
	 * ʵ   
	 *
	 * @param	resource $result  
	 * @return	int
	 */
	abstract public function getFieldCount($result) ;

	/**
	 * ʵ ̸   
	 *
	 * @param	resource $result  
	 * @param	int $i ʵ offset, 0-based number
	 * @return	string		ʵ ̸ 
	 */
	abstract public function getFieldName($result, $i) ;

	/**
	 * ʵ Ÿ   
	 *
	 * @param	resource $result  
	 * @param	int $i ʵ offset, 0-based number
	 * @return	string		ʵ Ÿ ̸ 
	 */
	abstract public function getFieldType($result, $i);

	/**
	 *  ϱ
	 *
	 * @param	string $sql	sql 
	 * @return	resource		 ,   false 
	 */
	abstract public function query($sql) ;

	
	/**
	 * sql history ϱ 
	 *
	 * @param string $sql sql 
	 */
	public function addSql($sql) { 
		$this->__sql_history[] = $sql;
	}

	/**
	 *  sql  
	 *
	 * @param int $num  sql ε ȣ 
	 * @return string sql 
	 */
	public function getSql($num = '') { 
		$index = ($num == '') ? sizeof($this->__sql_history)-1 : 0;

		return $this->__sql_history[$index];
	}

	/**
	 *  sql ϱ 
	 */
	public function printSql() { 
		echo "<pre>".print_r($this->__sql_history, true)."</pre>";
	}

	/**
	 * prepare
	 * 
	 * ӹ Ŭ  
	 * 
	 */
	public function prepare($sql) { 

	}

	/**
	 * prepare  ε Ѵ. 
	 *
	 * ӹ Ŭ 
	 * 
	 * @param string $name ε ̸ 
	 * @param string $type ε Ÿ, Ÿ̽  Ʋ 
	 * @param string $output output , in, out, inout, return 
	 * @param int $length Ÿ, -1  
	 * @param mixed $value  Ÿ Ǵ output   Ÿ
	 *
	 *  
	 */
	public function bind($name, $type = '', $output = 'in', $length = -1, &$value = null ) { 

	}

	/**
	 * prepare  Ѵ. 
	 *
	 * ӹ Ŭ  
	 */
	public function execute() { 

	}
	
	/**
	 * ν  ü  ,  ؾմϴ. 
	 * 
	 * @param string $name
	 * @param mixed $option
	 * @return DBProc
	 */
	public function createProc($name, $option = '') { 
		return null;
	}

	/**
	 * prepare   ޸  
	 *
	 * ӹ Ŭ  
	 */ 
	public function freeStatement($stmt) { } 

}

?>