<?php
/**
 * Oracle
 *
 * @package php.db
 */

//import("php.db.DBClient");


/**
 * Ŭ  Ŭ  
 *
 * @package php.db
 */
class Oracle extends DBClient { 

	private $tempStmt;
	private $cursor = array();

	/**
	 * 
	 *
	 */
	public function __construct($option) {
		parent::__construct($option);
	}

	/**
	 * database  
	 * 
	 * @return resource  resource
	 */
	public function _connect() {
		// 10g 
		if ($this->version == '10') { 
			$sid = sprintf("//%s/%s", $this->host, $this->db);
		} else { 
			$sid = $this->db;
		}

		return oci_connect($this->id, $this->pass, $sid, $this->charset, constant($this->session_mode));
	}

	/**
	 *  ݱ 
	 */
	public function close() {

		if ($this->isConnected()) {
			oci_close($this->getConnection());
		}
	}

	/** 
	 * commit 
	 *
	 * @return bool
	 */
	public function commit() {
		return oci_commit($this->getConnection());
	}

	public function define($column, $var, $type) {
		return oci_define_by_name($this->getResult(), $column, $var, $type);
	}

	/**
	 *  ޼ 
	 * 
	 * @return string  ޼ 
	 */
	public function error() {
		$arr = oci_error();

		return $arr['message'];
	}

	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $stmt select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($stmt) {		
		return oci_fetch_array($stmt, OCI_ASSOC + OCI_RETURN_LOBS + OCI_RETURN_NULLS);
	}

	/**
	 * ü ġ
	 *
	 * @param resource $stmt Ľ̵ Statement ü 
	 */
	public function fetchAll($stmt) { 
		oci_fetch_all($stmt, $temp, 0, -1, OCI_ASSOC +  OCI_FETCHSTATEMENT_BY_ROW);

		foreach ($temp as &$arr) { 
			$arr = array_change_key_case($arr, CASE_LOWER);
		}
		
		return $temp;
	}	

	/** 
	 * ޸  
	 * 
	 * @return bool
	 */
	public function free($result) { 
		return $this->freeStatement();
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $stmt select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($stmt) {
		return oci_num_fields($stmt);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $stmt select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($stmt, $i) {
		return oci_field_name($stmt, $i+1);
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $stmt select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($stmt, $i) {
		return oci_field_type($stmt, $i+1);
	}

	/**
	 * DBData  
	 * 
	 * <code>
	 * $db = DB_('oracle', 'test', true);
	 * 
	 * $data = $db->getData("select 1 from dual");
	 * echo $data;
	 * 
	 * $db->close();
	 * </code>
	 *
	 * @param	string $query DB query
	 * @param	boolean $isOne ε ĭ ű
	 * @param	string $baseClass  Ŭ ̸ 
	 * @return	DBData 
	 */
	public function getData($query, $isOne = false) 
	{

		$this->prepare($query);
		$this->execute();

		return $this->getBindData($isOne);
	} 

	/**
	 * cursor  DBData 
	 *
	 * <code>
	 * 
	 * $db = DB_('oracle', 'test', true);
	 * 
	 * $cursor = $db->newCursor('test_cursor');
	 * 
	 * ....... 
	 * 
	 * $data = $db->getCursorData('test_cursor');
	 * echo $data;
	 * 
	 * $db->close();
	 * 
	 * </code>
	 * 
	 * @return DBData 
	 */
	function getCursorData($name, $isOne = false) {

		$data = $this->createData($this->cursor[$name]);

		//   ¥ true
		// true ̸ next ٷ  · Ѿ´. 
		if ($isOne) 
			$data->next();

		return $data;
	}

	/**
	 * select  ؼ ¡ DBData Ѵ. 
	 *
	 * <code>
	 *
	 * $db = DB_('oracle', 'test', true);
	 *
	 * $data = $db->getPageData("select 1 from dual", 1, 10);
	 * echo $data;
	 *
	 * $db->close();
	 * 
	 * </code>
	 * 
	 * @param string $query select 
	 * @param int $page    
	 * @param int $count  Ʈ  
	 * @param string $baseClass  DBData   Ŭ , ⺻ DBData  
	 * @return DBData
	 */
	public function getPageData($query, $page, $count = 10) {

		//  ϱ 
		$start = ($page-1)*$count+1;
		$end = $start + $count-1;

		$sql = " SELECT * FROM ( SELECT a.*, RowNum as rNum FROM ( $query ) a WHERE RowNum <= $end ) WHERE $start <= rNum";

		return $this->getData($sql, false);
	}


	/**
	 * ʵ Ÿ(ڷ) php    
	 *
	 * @param string $type ŸԹڿ 
	 * @return int|string PHP
	 */
	public function getTypeConstant($type)
	{
		$type = strtoupper($type);

		switch ($type) {
			case 'FILE' :
				return SQLT_FILE;
			case 'CFILE' :
				return SQLT_CFILE;
			case 'CLOB': 
				return SQLT_CLOB;
			case 'BLOB':
				return SQLT_BLOB;
			case 'INT':
			case 'NUMBER':
				return SQLT_INT;
			case 'VARCHAR':
			case 'VARCHAR2':
				return SQLT_CHR;
			case 'LONG':
				return SQLT_LNG;
			case 'LBI':
				return SQLT_LBI;
			case 'BIN':					// binary
			case 'BINARY':				
				return SQLT_BIN;
			case 'RDD':					// rowid
			case 'ROWID':					
				return SQLT_RDD;
			case 'NTY':					// named types				
				return SQLT_NTY;
			case 'RSET':				// cursor
			case 'CURSOR':				
				return SQLT_RSET;
			default: 
				return -1;
		}
	}

	/**
	 * ʵ Ÿ(ڷ) DB Էµ  ִ ڿ  
	 *
	 * @param string $type ŸԹڿ 
	 * @param mixed $value Է°
	 * @param boolean $is_null  üũ   , true üũ, false  üũ  
	 * @return string ȯ ڿ
	 */
	public function getTypeString($type, $value, $is_null = false, $option = array('date_format' => 'YYYYMMDDHH24MISS')) { 
		$type = strtoupper($type);
		$temp = '';
		switch ($type) {
			case 'CHAR': 
			case 'NCHAR': 
			case 'NVARCHAR2' :
			case 'VARCHAR2':
				$temp = sprintf("'%s'", $this->escape($value));
				break;
			case 'DATE':
				$temp = sprintf("TO_DATE('%s', '%s')", $this->escape($value), $option['date_format']);
				break;
			case 'NUMBER':
				$temp = $value;
				break;
			case 'BLOB':
			case 'CLOB':
			case 'LONG RAW' :
			case 'LONG' : 
			case 'NCLOB':
			case 'ROW' :
				$temp = sprintf("'%s'", $this->escape($value));
				break;
			default: 
				$temp = $value;
				break;
		}

		return ($is_null && is_null($value)) ? 'NULL' : $temp;
	}


	/**
	 * execute ޼ҵ带   ̸ о ڵ  Ѵ. 
	 *
	 * @param resource $stmt  statement
	 * @param int $count ̸ о ڵ  
	 * @return bool   true,  false 
	 */
	public function setPrefetch($stmt, $count = 10) { 
		return oci_set_prefetch($stmt, $count);
	}

	/**
	 * Ŀ ϱ 
	 * 
	 * @param string $name Ŀ̸ 
	 */
	public function newCursor($name) {
		$this->cursor[$name] = oci_new_cursor($this->getConnection());
	}

	/** 
	 * Ϲ   
	 * 
	 * @param string $sql  query 
	 * @param bool $isCommit commit  , ٷ commit ̸ true, ƴϸ false
	 * @param array $args ε   
	 */
	public function query($query, $isCommit = true, $args = array()) {
		$this->prepare($query);


		foreach ($args as $key => $value) { 
			$this->bind($key, $value);
		}

		$this->execute();

		if ($isCommit) {
			$this->commit();
		}

		return $this->getResult();
	}

	/** 
	 * rollback
	 *
	 * @return bool  ̸ true, ̸ false 
	 */
	public function rollback() {
		return oci_rollback($this->getConnection());
	}

	/**
	 * ν 
	 * 
	 * <code>
	 *  // 1. Ϲ  
	 * 
	 *  // 2.    
	 * </code> 
	 * 
	 * @return bool ̸ true, ̸ false
	 * @todo insert, update ,delete  ؼ ڵ  binding   ִ   
	 */
	public function spExecute() {
	
		$bind_list = "";
		$keys = array_keys($this->__sp_bind_list);

		// ü  
		if ($this->__sp_option['type'] == 'sql') { 
			$str = $this->__sp_name;
		} 
		// Ű  
		else { 

			// ε Ʈ  
			foreach ( $keys as $key) { 
				// ̸  
				$bind_list[] = ':'.$this->__sp_bind_list[$key]['name'];
			}

			$bind_list = implode(",", $bind_list);

			// ν ڿ  
			$str = "BEGIN {$this->__sp_name}($bind_list); END;";
		}


		$this->__sp_statement = $this->prepare($str);

		// ε Ű 
		foreach ($keys as $key) { 

			$this->bind(
				$this->__sp_bind_list[$key]['name'],
				$this->__sp_bind_list[$key]['type'],
				$this->__sp_bind_list[$key]['output'],
				$this->__sp_bind_list[$key]['length'],
				$this->__sp_bind_list[$key]['value']			
			);
		}

		$this->__sp_execute_result = $this->execute(OCI_DEFAULT);

		// ν  
		return $this->__sp_execute_result;
	
	}

	public function getResult() { 
		return $this->getStatement();
	}


	/**
	 * sql  Ľϱ 
	 *
	 * @param string $query Ľ̵ 
	 * @return resource Ľ̵ statment resource
	 */
	public function prepare($query) {
		$this->addSql($query);

		$this->setStatement(oci_parse($this->getConnection(), $query));
		return $this->getStatement();
	}


	/** 
	 * bind ޼ҵ 
	 *
	 * @param string $name ε ̸ 
	 * @param string $type ε Ÿ, Ÿ̽  Ʋ 
	 * @param string $output output , in, out, inout, return 
	 * @param int $length Ÿ, -1  
	 * @param mixed $value  Ÿ Ǵ output   Ÿ
	 * @return bool 
	 */
	public function bind($name, $type = '', $output = 'in', $length = -1, &$value = null) {
		$param = ":".$name;		// ̸  

		return oci_bind_by_name($this->getResult(), $param, $value, $length, $this->getTypeConstant($type));
	}

	/**
	 *   
	 *
	 * <code>
	 * $db = DB_('oracle', 'test', true);
	 *
	 * $db->prepare("insert into test_table values ('1', '2')");
	 * $db->execute();		//   
	 * $db->commit();
	 *
	 * $db->close();
	 * </code>
	 * 
	 * @return resource statement  ҽ 
	 */
	public function execute($mode = OCI_DEFAULT) {
		$this->setExecute(oci_execute($this->getStatement(), $mode));
		return $this->getExecute();
	}

	/**
	 * prepare ޸  
	 * 
	 * @param resource $stmt oci_prepare() Լ   resource 
	 * @return bool  
	 */
	public function freeStatement($stmt) {
		return oci_free_statement($stmt);
	}

	/**
	 * ν  ü ´. 
	 * 
	 * 
	 * @see lib/php/db/DBClient#createProc($name)
	 * @return OracleProc 
	 */
	public function createProc($str, $option = 'proc') { 
		$proc = new OracleProc($this);
		$proc->name($str, $option);
		
		return $proc;
	}
}

?>