<?php

/**
 * DB ν  ߻ȭ Ŭ 
 * 
 * @package php.db.proc
 */

/**
 * Cubrid ν 
 * 
 * 
 * @author easylogic
 *
 */
class CubridProc extends DBProc { 
	
	private $_statement;
	
	/**
	 *  
	 * 
	 * @param DBClient $connector
	 */
	public function __construct(DBClient $connector) { 
		parent::__construct($connector);	
	}
	
	/**
	 * ν 
	 * 
	 * @return bool ̸ true, ̸ false
	 */
	public function execute() {
		$conn = $this->getConnector();
	
		$output_count	= 0;
		$output_list	= array();

		// ڿ  
		$head = "call {$this->_name}(";
		$temp = array();
		$var_init = array();
		$bind_init = array();

		// ε ڿ  
		foreach (array_keys($this->_bind) as $key) { 

			// out, inout ̸ ʱⰪ  
			if ($this->_bind[$key]['output'] == 'in') { 
				$bind_init[] = $this->_bind[$key];
			} else { 

				$var_init[] = sprintf("select %s into %s from db_root;", 
											$conn->getTypeString($this->_bind[$key]['type'], 
											$this->_bind[$key]['value']), 
											$this->_bind[$key]['name']
				);

			}

			// ν   
			if ($this->_bind[$key]['output'] == 'in') { 
				$temp[]	= '?';
			} else {
				$temp[]	= $this->_bind[$key]['name'];
			}

			// out, inout  ̸  
			if (in_array($this->_bind[$key]['output'], array('out', 'inout'))) { 
				$output_list[] = $this->_bind[$key]['name'];
			}
		}
		
		$head .= implode(",", $temp);

		$head .= ") ";


		// output   
		foreach ($var_init as $var_sql) { 
			$conn->query($var_sql);
		}

		// ν  
		$this->_statement = $conn->prepare($head);

		// ε 
		foreach ($bind_init as $key => $value) { 
			$conn->bind($this->_statement, $key+1, $value['value'], $value['type']);
		}

		$this->_result = $conn->query($this->_statement);

		// output  ޱ 
		if (count($output_list) > 0 ) { 
			$sql = "select ".implode(",", $output_list). " from db_root ";
			$data = $conn->getOne($sql);

			foreach ($output_list as $output_var) { 
				$this->_bind[$output_var]['value'] = $data->get($output_var);
			}
		}

		return true;

	
	}		
}
?>