<?php

/**
 * DB ν  ߻ȭ Ŭ 
 * 
 * @package php.db.proc
 */

abstract class DBProc extends PObject { 
	
	protected $_name;
	protected $_option = array();
	protected $_bind = array();
	protected $_result;
	
	private $connector = null;
	
	public function __construct($connector) { 
		$this->setConnector($connector);	
	}
	
	/**
	 * 
	 * @return DBClient
	 */
	public function getConnector() { 
		return $this->connector;
	}
	
	public function setConnector(DBClient $connector) { 
		$this->connector = $connector;
	}
	
	public function getName() { 
		return $this->_name;
	}
	
	public function getOption($key = 'type') { 
		return $this->_option[$key];		
	}
	
	public function getBind($key, $subKey) { 
		return $this->_bind[strtolower($key)][$subKey];
	}
	
	public function getResult() { 
		return $this->_result;
	}
	
	/**
	 * ν ̸ 
	 * 
	 * @param string $str  or ν ̸
	 * @param string|array $option ε  ɼ Ѵ. type : ε  Ÿ, proc,sql,insert,update,delete   ̴. 
	 */
	public function name($str, $option = 'proc')  {

		if (is_string($option)) { 
			$option = array('type' => $option);
		}

		$this->_name = $str;
		$this->_option = $option;
	}
	
	/**
	 * ε Ʈ  
	 *
	 * @param string $name ε ̸ 
	 * @param string $type ε Ÿ, Ÿ̽  Ʋ 
	 * @param string $output output , in, out, inout, return 
	 * @param int $length Ÿ, -1  
	 * @param mixed &$value  Ÿ Ǵ output   Ÿ
	 * @param array $option ε ɶ Ÿ ɼ 
	 *                      update : bool, Ʈ ʵ 
	 *                      op :  , "and", "or"
	 */
	public function bind($name, $type = '', $output = 'in', $length = -1, &$value = null , $option = array()) {

		$this->_bind[strtolower($name)] = array(
			'name'		=> $name,
			'type'		=> strtolower($type),
			'output'	=> strtolower($output),
			'length'	=> $length,
			'value'		=> $value,
			'option'	=> $option,
		);
	}	
	
	/** 
	 * Ķ   
	 * 
	 * @param string $name ε ̸ 
	 * @param mixed $value	ε ̸  Ÿ 
	 */
	public function set($name, $value) {
		$this->_bind[strtolower($name)]['value'] = $value;	
	}

	/** 
	 * Ķ Ʈ  
	 *
	 * @param array $arr ε    մϴ.
	 */
	public function sets($arr) {
		foreach ($arr as $key => $value) { 
			$this->set($key, $value);
		}
	}	
	
	/**
	 * ν  
	 *
	 *  Ŭ ϴ Ŭ spExecute ޼ҵ带 ؼ ν    ֽϴ.
	 * 
	 */
	public function execute()  {}

	/**
	 * Ķ   
	 * 
	 * @param string $name Ķ ̸ 
	 * @return mixed spBind ߴ $value   ɴϴ. 
	 */
	public function get($name) {
		return $this->_bind[strtolower($name)]['value'];
	}	

	/**
	 * Ķ Ʈ  
	 * 
	 * @return array ε ̸  value  迭 մϴ.
	 */
	public function gets() {
		$temp = array();

		foreach ($this->_bind as $key => $arr) { 
			$temp[$key] = $arr['value'];
		}

		return $temp;
	}	
}
?>