<?php
/**
 * Request  Լ  
 * 
 * @package php.lang
 *
 * @todo Լ ϴ Request Ŭ ޼ҵ带  Ѵ. 
 * @todo Session Ŭ  
 * @todo Cookie Ŭ  
 * @todo Server Ŭ  
 */


/**
 * HTTP û(Request) õ Ÿ Ѵ. 
 * static ޼ҵθ ̷ ֽϴ. 
 *
 * @package php.lang
 *
 * @todo Request ü õ Լ  ؾѴ. 
 * 
 */
class Request { 
	
	public function __construct() {} 

	public static function get($field, $value = '', $is_set = false) { 
		if (empty($_GET[$field])) {
			$_GET[$field] = $value;
		}

		if ($is_set) { 
			$_GET[$field] = $value;
		}

		return $_GET[$field];
	}

	public static function post($field, $value = '', $is_set = false) { 
		if (empty($_POST[$field])) {
			$_POST[$field] = $value;
		}

		if ($is_set) { 
			$_POST[$field] = $value;
		}

		return $_POST[$field];
	}

	public static function vars($field, $value = '', $is_set = false) { 
		if (empty($_REQUEST[$field])) {
			$_REQUEST[$field] = $value;
		}

		if ($is_set) {
			$_REQUEST[$field] = $value;
		}

		return $_REQUEST[$field];
	}

	public static function is($method) { 
		return (Request::method() == strtoupper($method));
	}

	public static function method() { 
		return strtoupper($_SERVER['REQUEST_METHOD']);
	}

	public static function view($type) { 
		$arr = self::getGlobals($type);

		if (gettype($arr) != "array") {
			return "迭 ƴմϴ.";
		}
		
		echo "<table border='1'>";
		echo  "<tr><th>Key</th><th>Value</th></tr>";
		
		foreach ($arr as $key => $value) {

				if (is_array($value)) { 
					echo  "<tr><td>";
					echo $key;
					echo "</td><td>";
					self::view($value);
					echo "</td></tr>";					
				} else { 

					$value = htmlspecialchars($value);
					$value = nl2br($value);
					echo  "<tr><td>";
					echo $key;
					echo "</td><td>";
					echo $value;
					echo "</td></tr>";	
				}
		}

		echo "</table>";
	}

	public static function getGlobals($type) { 
		if (is_array($type) ) return $type;

		$type = strtoupper($type);
		switch($type) { 
			case 'POST' :		return $_POST;
			case 'GET' :		return $_GET;
			case 'REQUEST' :	return $_REQUEST;
			default	:			return ${"_".$type};
		}
	}
}

?>