<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * WBControl
 *
 * @package php.ui.winbinder
 */
class WBControl extends WBComponent { 

	/**
	 *  
	 *
	 */
	public function __construct($options = array()) { 
		parent::__construct($options);
	}

	protected function createComponent() { 

		$tab = (isset($this->ntab)) ? $this->parent->getTabIndex($this->ntab) : $this->ntab ;

		$instance = wb_create_control(
				WBApplication::getInstance($this->parent), 
				$this->class, 
				$this->caption, 
				$this->x, 
				$this->y, 
				$this->width, 
				$this->height, 
				$this->id, 
				$this->style, 
				$this->param, 
				$tab
		);

		return $instance;
	}

	protected function initCreate() { 
		$defaultStyle = WBC_ENABLED | WBC_VISIBLE;
		$defaultParam = 0;

		$this->style = (isset($this->style)) ? $this->style | $defaultStyle : $defaultStyle;
		$this->param = (isset($this->param)) ? $this->param | $defaultParam : $defaultParam;		
	}

	protected function initEvent() { 
		parent::initEvent();

		$this->setEvent('click',		'onClick');
		$this->setEvent('doubleclick',	'onDoubleClick');
		$this->setEvent('focus',		'onFocus');
		$this->setEvent('blur',			'onBlur');
	}

	// Ʈ ʱȭ 
	protected function initComponent() { 
		parent::initComponent();

		// Ű    
		if (isset($this->accel)) $this->setAccel($this->accel);

		// Ŀ  
		if (isset($this->focus)) $this->focus();

		//  Ұ  
		if (isset($this->disabled))	$this->setEnabled(!$this->disabled);

		// ̱  
		if (isset($this->visible))	$this->setVisible($this->visible);

		// ׵θ  
		if (isset($this->border))	$this->setBorder($this->border);

		// ,   ȵǾ   ̸  ũ  
		if (!isset($this->width) || !isset($this->height)) { 
			$arr = $this->getPreferedSize();

			$this->setSize($arr['width'], $arr['height']);

		}
	}

	/**
	 * item  
	 *
	 */
	public function createItems($items , $clear = false , $param = null) { 
		return wb_create_items($this->getInstance(), $items, $clear, $param);
	}

	/**
	 *   
	 *
	 */
	public function deleteItems($items = null) { 
		return wb_delete_items($this->getInstance(), $items);
	}

	/**
	 * Ʈ ޸  
	 *
	 */
	public function destroy() { 
		return wb_destroy_control($this->getInstance());
	}

	/**
	 * Ȱ  
	 *
	 * @return bool 
	 */
	public function isEnabled() { 
		return wb_get_enabled($this->getInstance()) ;
	}

	/**
	 * Treeview node depth  
	 *
	 * @param int $item TreeView node 
	 * @return int 
	 */
	public function getLevel($item) { 
		return wb_get_level($this->getInstance(), WBApplication::getInstance($item));
	}

	/**
	 * õ index  
	 *
	 * @return int 
	 */
	public function getSelected() { 
		return wb_get_selected($this->getInstance());
	}

	/**
	 * TreeView , expanded, collapsed ǥ 
	 *
	 * @return bool true : expanded, false : collpased 
	 */
	public function getState($item) { 
		return wb_get_state($this->getInstance(), $item);
	}

	/**
	 * value  
	 *
	 * @param int $item 
	 * @param int $subitem 
	 * @return mixed  
	 */
	public function getValue($item = null, $subitem = null) { 
		return wb_get_value($this->getInstance(), $item, $subitem);
	}

	/**
	 * enabled  
	 *
	 * @param bool $enabled
	 */
	public function setEnabled($enabled = true) { 
		return wb_set_enabled($this->getInstance(), $enabled);
	}

	/**
	 *  ̹  
	 *
	 * @param int $index 
	 * @param int $item 
	 * @param int $subitem 
	 */
	public function setItemImage($index, $item = 0, $subitem = 0) { 
		return wb_set_item_image($this->getInstance(), $index, $item, $subitem);
	}

	/**
	 * Ű  
	 *
	 * @param string $keybind 
	 */
	public function setAccel($keyBind) { 
		$this->parent->setAccel($this->id, $keyBind, array($this, 'onClick'));
	}

	/**
	 * selected  
	 *
	 * @param int $items 
	 * @param bool $selected 
	 */
	public function setSelected($items, $selected = true) { 
		return wb_set_selected($this->getInstance(), $items, $selected);
	}

	/**
	 * TreeView   
	 *
	 * @param int $item 
	 * @param bool $state  
	 */
	public function setState($item, $state) { 
		return wb_set_state($this->getInstance(), $item, $state);
	}

	/**
	 * value  
	 *
	 * @param mixed $value 
	 * @param int $item 
	 */
	public function setValue($value, $item = null) { 
		return wb_set_value($this->getInstance(), $value, $item);
	}

	public function setBorder($isBorder = true) { 
		return $this->setStyle(WBC_BORDER, $isBorder);
	}

	/**
	 *  ϱ 
	 * 
	 * @param int $min 
	 * @param int max 
	 */
	public function setRange($min = 0, $max = 0) { 
		return wb_set_range($this->getInstance(), $min, $max);
	}

	/**
	 * ϱ 
	 *
	 * @param bool $asc true ̸ asc, false ̸ desc 
	 * @param bool $subitem 
	 */
	public function sort($asc = true , $subitem = null) { 
		return wb_sort($this->getInstance(), $asc, $subitem);
	}

	/**
	 * ̺Ʈ  
	 *
	 * @param WBEvent $eo ̺Ʈ ü 
	 */
	public function fire($eo) { 
		// focus
		if ($eo->isFocus()) { $this->fireEvent('focus', $eo); return; }

		// double click 
		if ($eo->isDoubleClick()) { $this->fireEvent('doubleclick', $eo); return; }

		// default click event 
		$this->fireEvent('click', $eo); 
	}

	/**
	 * click ̺Ʈ  
	 *
	 */
	public function click() { 
		// WM_COMMAND, MAKELONG(ID, BN_CLICKED), HWND
		// ::SendMessage(hwndParent, WM_COMMAND, MAKELONG(nButtonID, BN_CLICKED), hwndButton);

		$this->send(WBUser::WM_COMMAND, ($this->id | (WBUser::BN_CLICKED << 16)), $this->getHwnd()->hwnd);
	}

	
	/**
	public function setMinimumSize($width = 0, $height = 0) {
		parent::setMinimumSize($width, $height);

		$this->setArea(WBC_MINSIZE, 0, 0, $width, $height);
	}

	public function setMaximumSize($width = 0, $height = 0) {
		parent::setMaximumSize($width, $height);

		$this->setArea(WBC_MAXSIZE, 0, 0, $width, $height);
	}
	**/
}

?>