<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBHTMLControl
 *
 * @package php.ui.winbinder
 */
class WBHTMLControl extends WBControl { 
	public function __construct($options = array()) { 
		$options['class'] = HTMLControl;

		parent::__construct($options);
	}

	// ü ʱȭ 
	protected function initComponent() { 
		parent::initComponent();	

		if (isset($this->url))	{
			$this->setLocation($this->url);
		} else { 
			$this->blank();
		}
	}

	/**
	 * HTMLControl  Լ 
	 * 
	 * 
	 * // ⺻  
	 * cmd:back		Go to previously visited page.
	 * cmd:forward	Go to a page previously viewed before issuing the back command.
	 * cmd:refresh	Redraw the current page.
	 * cmd:stop		Stop the current action, like loading a page.
	 * cmd:busy		Return TRUE if the browser is busy or FALSE if idle.
	 * cmd:blank	Clear the page.
	 */
	public function setLocation($location = "cmd:blank") { 
		return wb_set_location($this->getInstance(), $location);
	}

	public function blank() { 
		$this->setLocation("cmd:blank");
	}

	public function back() { 
		$this->setLocation("cmd:back");
	}

	public function forward() { 
		$this->setLocation("cmd:forward");
	}

	public function refresh() { 
		$this->setLocation("cmd:refresh");
	}

	public function stop() { 
		$this->setLocation("cmd:stop");
	}

	public function busy() { 
		$this->setLocation("cmd:busy");
	}

}

?>
