<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBListView
 *
 * @package php.ui.winbinder
 */
class WBListView extends WBControl { 
	private $_header = array();

	public function __construct($options = array()) { 
		$options['class'] = ListView;

		parent::__construct($options);
	}

	protected function initCreate() { 
		parent::initCreate();

		if (isset($this->sort) && $this->sort)	 $this->style |= WBC_SORT;
	}

	protected function initEvent() { 
		parent::initEvent();

		$this->setEvent('headerSelected', 'onHeaderSelected');
		$this->setEvent('deleteRow', 'onDeleteRow');
		$this->setEvent('insertRow', 'onInsertRow');
	}

	// ü ʱȭ 
	protected function initComponent() { 
		parent::initComponent();	

		if (isset($this->header))	$this->setHeader($this->header);
		if (isset($this->items))	$this->setItems($this->items);
		if (isset($this->line))		$this->setLine($this->line);
		if (isset($this->checkbox))	$this->setCheckBox($this->checkbox);
	}

	/**
	 *   
	 *
	 */
	public function setLine($isLine = false) { 
		return $this->setStyle(WBC_LINES, $isLine);
	}

	/**
	 *   
	 *
	 *
	 */
	public function setHeader($headerList = array()) { 
		$this->_header = $headerList;

		$this->setText($this->_header);
	}

	/**
	 *  ߰ ϱ 
	 * 
	 *
	 *
	 */
	public function addHeader($header) { 
		$this->_header[] = $header;

		$this->setHeader($this->_header);
	}

	/**
	 * Ÿ  
	 *
	 * <code>
	 * 
	 * // two dimension array 
	 * $listview->setItems(array(array(1,2,3), array(4,5,6), ...));
	 * 
	 * </code>
	 *
	 */
	public function setItems($items = array()) { 

		// clear cell 
		$this->initItems();

		// set data 
		$this->createItems($items);
	}

	/** 
	 * WBListView clear 
	 *
	 *
	 */
	public function init() { 
		// Clears all column titles
		$this->initHeader();

		// Clears all cells
		$this->initItems();
	}

	/**
	 * item(data) ʱȭ 
	 *
	 *
	 */
	public function initItems() { 
		return $this->deleteItems();
	}

	/**
	 *  ʱȭ
	 *
	 */
	public function initHeader() { 
		return $this->setText(array());
	}

	/**
	 *  ϱ 
	 *
	 *
	 */ 
	public function length() { 
		return $this->getItemCount();
	}

	/**
	 * Row ߰ ϱ 
	 *
	 * 
	 *
	 */
	public function addRow($arr) { 
		$this->createItems(array($arr));
	}

	/**
	 * Row  ϱ 
	 *
	 *
	 */ 
	public function deleteRow($index) { 
		$this->deleteItems($index);
	}

	/**
	 * column   
	 *
	 *
	 */
	public function getColumn($index, $column) { 
		return $this->getText($index, $column);
	}

	/**
	 * row   
	 *
	 * @return array 
	 */
	public function getRow($index) { 
		return $this->getText($index);
	}

	/**
	 * ü 迭   
	 *
	 *
	 */
	public function getItems() { 
		return $this->getText();
	}

	/**
	 * column ϱ 
	 *
	 *
	 */
	public function setColumn($index, $column, $text) { 
		$this->setText($text, $index, $column);
	}

	/**
	 * row  ϱ 
	 *
	 *
	 */
	public function updateRow($index, $row ) { 
		$this->setText($row, $index);
	}

	/**
	 * Ư index row ϱ 
	 *
	 *
	 */ 
	public function insertRow($index, $row) { 
		for ($i = $this->length()-1; $i >= $index; $i--) { 
			$this->updateRow($i + 1, $this->getRow($i));
		}

		$this->updateRow($index, $row);
	}

	/**
	 * header   
	 *
	 *
	 */
	public function setColumnSize($size = array()) { 
		$this->setSize($size);
	}
	
	/**
	 * üũڽ  
	 *
	 *
	 */
	public function setCheckBox($isCheckBox = false) { 
		$this->setStyle(WBC_CHECKBOXES, $isCheckBox);
	}

	/**
	 *  õǾ row index
	 *
	 * @return array selected index list 
	 */
	public function getSelectedIndex() { 
		return $this->getSelected();
	}

	/**
	 * üũ Ǿ ִ Ʈ  
	 *
	 *
	 */
	public function getCheckedList() { 
		return $this->getValue();
	}

	/**
	 * üũ   
	 *
	 *
	 */
	public function isChecked($index) { 
		return $this->getValue($index);
	}

	/**
	 * row üũ ϱ 
	 *
	 *
	 */
	public function setChecked($index, $isChecked = true) { 
		$this->setValue($isChecked, $index);
	}

	/**
	 * ̺Ʈ   
	 *
	 */
	public function fire($eo) {
		parent::fire($eo);

		// header selected event 
		if ($eo->isHeaderSelected()) { $this->fireEvent('headerSelected', $eo); return; }
	}

}

?>