<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBMenu
 *
 * @package php.ui.winbinder
 */
class WBMenu extends WBControl { 

	private $menuItem = array();

	public function __construct($options = array()) { 
		$options['class'] = Menu;

		parent::__construct($options);
	}

	public function initCreate() { 
		parent::initCreate();

		if ($this->items) { 
			$temp = array();

			foreach ($this->items as $item) { 
				if (is_array($item)) { 
					if ($item['caption']) { 
						$item['parent'] = $this;
						$tempItem = new WBMenuItem($item);

						$temp[] = $tempItem->getMenuTemplate();
						$this->menuItem[] = $tempItem;
					} else { 
						$tempItem = new WBMenuItem(array(
							'parent'	=> $this,
							'caption'	=> $item[1],
							'hint'		=> $item[2],
							'image'		=> $item[3],
							'accel'		=> $item[4],
							'callback'	=> $item[5],
						));

						$temp[] = $tempItem->getMenuTemplate();
						$this->menuItem[] = $tempItem;
					}
				} else { 
					$temp[] = $item;
				}
			}

			$this->caption = $temp;
		}
	}

	public function initComponent() { 
		parent::initComponent();

		foreach ($this->menuItem as $item) { 
			$item->initMenuItem();
		}
	}

	public function getMenuItem($index = 0) { 
		return $this->menuItem[$index];
	}

	public function getMenuItemList() { 
		return $this->menuItem;
	}
}

?>
