<?php
/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * WBObject, ֻ Ŭ 
 *
 * @package php.ui.winbinder
 */
class WBObject extends PObject { 
	private $_defaultEvent = array();
	private $_userEvent = array();
	private $_options = array();

	/**
	 * WBObject  
	 *
	 *  id Ӽ Ǿ   id ڵ ؼ Ѵ. 
	 *
	 * @param array $options WBObject   ɼ Ʈ 
	 */
	public function __construct($options = array()) { 

		// ̵  
		$options['id'] = (isset($options['id'])) ? $options['id'] : WBApplication::getIdCount() ;
		WBApplication::setObject($options['id'], $this);

		//   
		if ($options['name']) { 
			WBApplication::setName($options['name'], $options['id']);
		}

		// Ӽ  
		$this->setOptionList($options);

		// ̺Ʈ  Լ 
		$this->initEvent();
	}

	protected function initEvent() { 

		// ̺Ʈ    
		if ($this->event) { 
			foreach ($this->event as $event => $callback) { 
				if (is_callable($callback, false)) { 
					$this->on($event, $callback);
				} else if (is_array($callback)) { 
					foreach ($callback as $event2 => $callback2) { 
						if (is_callable($callback2, false)) { 
							$this->on($event2, $callback2);
						}
					}
				}
			}
		}
	}

	/**
	 * option  
	 *
	 * @param string $key option key 
	 * @param mixed $value option value 
	 */
	public function setOption($key, $value) { 
		$this->_options[strtolower($key)] = $value;
	}

	/**
	 * options  
	 *
	 * @param array options 
	 */
	public function setOptionList($options = array()) { 
		foreach ($options as $key => $value) { 
			$this->setOption($key, $value);
		}
	}

	/**
	 * $key  ´   
	 *
	 * @param string $key option key 
	 * @return mixed option value 
	 */
	public function getOption($key) { 
		return $this->_options[strtolower($key)];
	}

	/**
	 * option list 
	 *
	 * @return array 
	 */
	public function getOptionList() { 
		return $this->_options;
	}

	/**
	 * ⺻ ̺Ʈ شϴ callback Լ  
	 *
	 * @param string $event ̺Ʈ ̸ 
	 * @param string|array $function callback Լ 
	 */
	public function setEvent($event, $function) { 
		$this->_defaultEvent[strtolower($event)] = $function;
	}

	/**
	 *  ̺Ʈ ߰ 
	 * 
	 * @param string $event ̺Ʈ ̸ 
	 * @param string|array $function callback Լ 
	 */
	public function addEvent($event, $function) { 
		$this->_userEvent[strtolower($event)][] = $function;
	}

	/**
	 * addEvent()  
	 *
	 * @param string $event ̺Ʈ ̸ 
	 * @param string|array $function callback Լ 
	 */
	public function on($event, $function) { 
		$this->addEvent($event, $function);
	}

	/**
	 * option value ϱ 
	 *
	 * <code>$obj->class = AppWindow;</code>
	 *
	 * @param string $key option key 
	 * @param mixed $value option value 
	 */
	public function __set($key, $value) { 
		$this->setOption($key, $value);
	}

	/**
	 * $key  ´   
	 *
	 * <code>echo $obj->class;</code>
	 *
	 * @param string $key option key 
	 * @return mixed option value 
	 */
	public function __get($key) { 
		return $this->getOption($key);
	}


	/**
	 * ɼ   üũ 
	 *
	 * <code>
	 * if (isset($obj->class)) { 
	 *    echo 'class ɼ Ǿ ';
	 * }
	 * </code>
	 * 
	 * @param string $key option key 
	 */
	public function __isset($key) { 
		return isset($this->_options[strtolower($key)]);
	}

	/**
	 * option ޸  
	 *
	 * @param string $key option key 
	 */
	public function __unset($key) { 
		unset($this->_options[strtolower($key)]);
	}
	
	/**
	 * getXXX ޼ҵ忡 ؼ  ޼ҵ Ѵ. 
	 * 
	 * @param string $name
	 * @param array $args
	 * @return mixed
	 */
	public function __call($name, $args = array()) { 
		$name = ucfirst($name);
		$method = "get{$name}";
		
		if (is_callable(array($this, $method))) { 
			return call_user_func_array(array($this, $method), $args);
		}
		
		return $this;
	}

	/**
	 * ̺Ʈ  
	 * 
	 * <code> $com->fireEvent('click', $eventObject);</code>
	 *
	 */
	public function fireEvent() { 
		
		$arr = func_get_args();

		$event = array_shift($arr);
		$event = strtolower($event);

		// ⺻ ̺Ʈ 
		if ($this->_defaultEvent[$event] 
			&& is_callable(array($this, $this->_defaultEvent[$event]))) 	
		{ 
			call_user_func_array(array($this, $this->_defaultEvent[$event]), $arr);
		}
		
		//  ̺Ʈ 
		if (array_key_exists($event, $this->_userEvent)) { 
			foreach ($this->_userEvent[$event] as $func) { 
				if (is_callable($func)) { 
					call_user_func_array($func, $arr);
				}
			}
		}
	}

	/** 
	 * ̺Ʈ   
	 *  ŸԿ ´ ̺Ʈ  
	 *
	 */
	protected function fire($eo) { 
		
	}
}

?>