<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBTabControl
 *
 * @package php.ui.winbinder
 */
class WBTabControl extends WBControl { 

	private $_pageList = array();
	private $_pageObject = array();
	private $_rootPanel = array();

	
	public function __construct($options = array()) { 
		$options['class'] = TabControl;

		parent::__construct($options);
	}

	public function initComponent() { 
		parent::initComponent();

		$this->setHandler();

		$this->setEvent('activate',		'onActivate');

		if (isset($this->tab))		$this->setTab($this->tab);
	}

	public function handler($window, $id, $ctrl = 0, $param1 = 0, $param2 = '') { 

		// ̺Ʈü (EventObject  ʿ)
		$eventObject = new WBEvent($window, $id, $ctrl, $param1, $param2);

		// ̺Ʈ ڵ鷯  
		$this->setHandler();

		switch($id) { 
		case IDDEFAULT:			 
			//   ̺Ʈ
			$this->fire($eventObject);
			break;
		default: 
			// component ̺Ʈ 
			$obj = WBApplication::getObject($id);
			
			if ($obj) { 
				$obj->fire($eventObject);
			}  else { 
				$this->fireEvent('accel', $eventObject);
			}

			break;

		}
			
	}

	public function setHandler() { 
		wb_set_handler($this->getInstance(), '__tabcontrol_handler');
	}

	public function getTabIndex($page = null) { 
		if (is_string($page)) { 
			return array_search($page, $this->_pageList);
		} else if (is_int($page)) { 
			return $page;
		} else if (is_null($page)) { 
			return $this->getActiveTab();
		}

		return false;
	}

	public function setTab($tab = array()) { 
		if (is_string($tab)) { 
			$tab = array_map('trim', explode("\n", $tab));
		} 

		foreach ($tab as $page) { 
			$this->addTab($page);
		}
	}

	/**
	 * Tab page ߰Ѵ. 
	 * 
	 * 
	 * @return int TabIndex
	 */
	public function addTab($tab) { 

		$tabIndex = $this->getTabIndex($tab);

		if ($tabIndex === false) { 

			// tab ڿ ߰ 
			$this->_pageList[] = $tab;

			// tabIndex ϱ 
			$tabIndex = sizeof($this->_pageList)-1;

			// tab  
			$this->createItems($tab);
			
			// tab Ʈг  
			$this->setRootPanel(new WBPanel(), $tab);
		} 
		
		return $tabIndex;
	}

	public function setActiveTab($tab) { 
		$this->setSelected($this->getTabIndex($tab), true);
	}

	public function getActiveTab() { 
		return $this->getSelected();
	}

	public function getRootPanel($tab = null) { 
		return $this->_rootPanel[$this->getTabIndex($tab)];
	}

	public function setRootPanel($panel = null, $tab = null ) { 
		if ($panel instanceof WBPanel) { 
			$this->_rootPanel[$this->getTabIndex($tab)] = $panel;
		}
	}

	public function add($component) { 
		return $this->getRootPanel($component->ntab)->add($component);
	}

	public function getTabList() { 
		return $this->_pageList;
	}

	public function doLayout() { 
		foreach ($this->_rootPanel as $panel) { 
			if ($panel)  {
				$size = $this->getSize(true);

				$panel->setBounds(0, 0, $size['width'], $size['height']);
				$panel->doLayout();
			}
		}
	}

	public function fire($eo) { 
		parent::fire($eo);

		if ($eo->isHeaderSelected()) { $this->fireEvent('activate', $eo, $eo->getParam2()); return; }
	}

	public function setTabText($tab, $text) { 
		$this->setText($text, $this->getTabIndex($tab));
	}

	public function getTabText($tab) { 
		return $this->getText($this->getTabIndex($tab));
	}

}

function __tabcontrol_handler($window, $id, $ctrl = 0, $param1 = 0, $param2 = '') { 
	WBApplication::getObject(wb_get_id($window))->handler($window, $id, $ctrl, $param1, $param2);
}


?>
