<?php


/**
 * ̾ƿ 
 *
 * @package php.ui.winbinder.layout
 */

/**
 * WBTableLayout 
 *
 * ̺  ̾ƿ 
 * 
 * @package php.ui.winbinder.layout
 */
class WBTableLayout extends WBLayout { 

	private $column_count = 1;
	private $row_count = 1;

	/** 
	 * Construct  
	 *
	 * <code>
	 * 
	 * // example 
	 * new WBTableLayout(array('*', '*'), array('*', 0.5, 0.2));
	 *
	 * </code> 
	 *
	 * width  3 ·   ִ. 
	 * 
	 * <pre>
	 * '*' :  ũ,  ũ⿡ Ͽ   
	 * 0.5(float) : (%) ũ  
	 * 5 (int) : (px) ũ  
	 * </pre> 
	 * 
	 * @param array $colums set columns width 
	 * @param array $row set rows width 
	 * @param int $vgap set vertical gap size
	 * @param int $hgap set horizontal gap size
	 *
	 */
	public function __construct($columns = array('*'), $rows = array('*'), $vgap = 1, $hgap = 1 ) { 
		parent::__construct(array(
			'columns'	=> $columns,
			'rows'		=> $rows,
			'vgap'		=> $vgap,	
			'hgap'		=> $hgap,	
		));
	}

	protected function initLayout() { 
		parent::initLayout();

		$this->vgap		= isset($this->vgap)	? $this->vgap	: 1;
		$this->hgap		= isset($this->hgap)	? $this->hgap	: 1;

		$this->column_count	= count($this->columns);
		$this->row_count	= count($this->rows);
	}

	private function getBlockSize($size, $list = array()) { 

		$count = count($list);

		$temp_block = array();
		$extra_size = $size;
		foreach ($list as $index => $column) { 
			if (is_float($column)) { 
				$list[$index] = floor($column * $size);
				$extra_size -= $list[$index]; //    
			} else if (is_int($column)) { 
				$extra_size -= $column;		//    
			} else if ($column == '*') { 
				$temp_block[] = $index;
			}
		}

		if (count($temp_block) > 0) { 
			$one_size = floor($extra_size / count($temp_block));

			foreach ($temp_block as $col) { 
				$list[$col] = $one_size;
			}
		} 

		return $list;
	}

	private function getTableSize($bounds) { 

		$columns = $this->getBlockSize($bounds['width'], $this->columns);
		$rows = $this->getBlockSize($bounds['height'], $this->rows);

		$table = array();

		$y = 0;	// y ǥ  

		foreach ($rows as $rowIndex =>$row) { 
			$table[$rowIndex] = array();

			$x = 0 ;	// x  ǥ  
			foreach ($columns as $columnIndex => $column) { 
				$table[$rowIndex][$columnIndex] = array(
					'x' => $x,
					'y' => $y,
					'width' => ($columnIndex == 0) ? $column : $column - $this->hgap,
					'height' => ($rowIndex == 0) ? $row : $row - $this->vgap,
				);

				// x ġ  
				$x += $column + $this->hgap;
			}

			// y ġ  
			$y += $row + $this->vgap;
		}

		$tempList = array();

		//  ġ Ī Ű 
		foreach ($table as $rowIndex => $row ) { 
			foreach ($row as $columnIndex => $arr) { 
				$arr['x'] += $bounds['x'];
				$arr['y'] += $bounds['y'];

				$tempList[] = $arr;
			}
		}

		return $tempList;
	}

	// span   
	private function getSpanSize($component) { 
		// $com->colspan, $com->rowspan

		$table = $this->getTableSize($component->getBounds(true));
		$tempTable = array_fill(0, count($table), null);

		$componentList = $component->getComponentList();

		$componentArea = array();

		// 
		foreach ($componentList as $index => $com ) { 
			// 1. get start point 
			$startPoint = $this->getStartPoint($tempTable);

			// 2. caculate span point
			$pointList = $this->getSpanPoint($startPoint, $com);

//			print_r(array($startPoint, $pointList));

			// 3. set point by $index 
			foreach ($pointList as $point) { 
				$this->setPoint($tempTable, $index, $point['column'], $point['row']);
			}

			// 4. get start, end point 
			$areaPointList = $this->getAreaPoint($pointList);

//			print_r($areaPoint);

			// 5. calculate real x,y,width,height
			$calArea = $this->calculateArea($table, $areaPointList);

			//print_r($calArea);

			$componentArea[] = $calArea; 

		}

		return $componentArea;
	}

	private function calculateArea(&$table, $areaPointList) { 

		// start point 
		$start = $this->getPoint($areaPointList['start'][0], $areaPointList['start'][1]);

		// end point 
		$end = $this->getPoint($areaPointList['end'][0], $areaPointList['end'][1]);

		$area = array(
			'x'			=> $table[$start]['x'],
			'y'			=> $table[$start]['y'],
			'width'		=> $table[$end]['x'] - $table[$start]['x'] + $table[$end]['width'],
			'height'	=> $table[$end]['y'] - $table[$start]['y'] + $table[$end]['height'],
		);



		return $area;
	}

	private function getAreaPoint($pointList) { 
		$temp = array();

		foreach ($pointList as $point) { 
			$temp[] = array($point['column'], $point['row']);
		}

		return array(
			'start' => min($temp),	
			'end'	=> max($temp),	
		);
	}

	private function getSpanPoint($startPoint, $component) { 
		$colspan = (isset($component->colspan)) ? $component->colspan : 1;
		$rowspan = (isset($component->rowspan)) ? $component->rowspan : 1;

		$colspan = (intval($colspan) > 1) ? intval($colspan) : 1;
		$rowspan = (intval($rowspan) > 1) ? intval($rowspan) : 1;

		$temp = array();

		for($i = 0; $i < $rowspan; $i++) {
			for ($j = 0; $j < $colspan; $j++){
				$temp[] = array(
					'column'	=> $startPoint['column'] + $j,
					'row'		=> $startPoint['row'] + $i
				);
			}
		}

		// ִ ũ  
		foreach ($temp as &$point) { 
			if ($point['column'] >= $this->column_count) $point['column'] = $this->column_count;
			if ($point['row'] >= $this->row_count) $point['row'] = $this->row_count;
		}

		return $temp;

	}

	private function getStartPoint(&$arr) { 
		foreach ($arr as $index => $value) { 
			if (is_null($value)) { 
				return array(
					'column' => $index % $this->column_count, 
					'row' => intval($index / $this->column_count),
				);
			}
		}
		
		return array();
	}

	private function getPoint($column, $row) { 
		return $row*$this->column_count + $column;
	}

	private function setPoint(&$arr, $value, $column, $row) { 
		$point = $this->getPoint($column, $row, $this->column_count, $this->row_count); 

		// Ʈ  
		$arr[$point] = $value;
	}

	public function render($component) { 

		$size			= $component->getBounds(true);
		$table			= $this->getSpanSize($component);

		$componentList	= $component->getComponentList();

		foreach ($componentList as $i => $com) { 

			$x		= $table[$i]['x'];
			$y		= $table[$i]['y'];
			$width	= $table[$i]['width'];
			$height = $table[$i]['height'];

			$com->setBounds($x, $y, intval($width), intval($height));
		}

	}


}
?>