<?php
/**
 *
 * @package php.ui.winbinder.win32
 */

class WBGdi extends WBLibrary { 

	public function __construct()  { 
		parent::__construct('GDI');
	}

	public static function rgb($r, $g, $b) { 
		$r = $r & 0x0000FF;
		$g = ($g << 8) & 0x00FF00;
		$b = ($b << 16) & 0xFF0000;

		return ($r | $g | $b);
	}

	public static function rgbHex($rgb) { 
		$r = ($rgb & 0xFF0000) >> 16;
		$g = ($rgb & 0x00FF00) >> 8;
		$b = $rgb & 0x0000FF;

		return self::rgb($r, $g, $b);
	}

	public static function colorR($rgb) { 
		return ($rgb & 0x0000FF);
	}

	public static function colorG($rgb) { 
		return ($rgb & 0x00FF00) >> 8;
	}

	public static function colorB($rgb) { 
		return ($rgb & 0xFF0000) >> 16;
	}

	public static function colorHex($rgb) { 
		$r = self::colorR($rgb);
		$g = self::colorG($rgb);
		$b = self::colorB($rgb);

		$r = ($r << 16) & 0xFF0000;
		$g = ($g << 8) & 0x00FF00;
		$b = ($b) & 0x0000FF;

		return ($r | $g | $b);
	}
}


?>