//===================================================================
// File		: mac_general.c
// Author	: haekim@etri.re.kr
// Date		: 2007.11.27
// Description : 
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include <stdlib.h>
#include "nos.h"

INT8 txbuf[NMAC_MAX_PAYLOAD_SIZE]; // 116
INT8 rxbuf[NMAC_MAX_PAYLOAD_SIZE]; // 116
NMAC_TX_INFO txinfo;
NMAC_RX_INFO rxinfo;
UINT8 n;

#include "nano_mac.h"
extern void nmac_rx_intr_handler(void);


void rf_rx_callback(void)
{
	led_toggle(1);
	if ( mac_rx(&rxinfo) )
	{
		uart_puts("\n\rRX : ");
		uart_putu( ((UINT8*)rxinfo.payload_ptr)[0]);	// or rxbuf[0]. print out only the first byte of payload.
		mac_tx_noack(&txinfo);
		txbuf[0]++;
	}
}

void command(UINT8 rx_char)
{
	UINT8 tx_power;
	if (rx_char == 'r' || rx_char == 'R')
	{
		led_toggle(1);
   		if ( mac_rx(&rxinfo) )
		{
			uart_puts("\n\rRX : ");
			uart_putu( ((UINT8*)rxinfo.payload_ptr)[0]);	// or rxbuf[0]. print out only the first byte of payload.
		}
		else
		{
			uart_puts("\n\rRX queue is empty");
		}
	}
	else if (rx_char == 't' || rx_char == 'T')
	{
		led_toggle(2);
		txbuf[0] = n;	// write the packet number to tx_payload[0]
		if (mac_tx(&txinfo))
		{
			uart_puts("\n\r\t\tTX : ");
			uart_putu(n);
		}
		else
		{
			uart_puts("\n\r\t\t\t\tTX failed: ");
			uart_putu(n);
		}
		n++;
	}
	else if (rx_char == 'a' || rx_char == 'A')
	{
		mac_tx_noack(&txinfo);
	}
	else if (rx_char == 'n' || rx_char == 'N')
	{
		mac_set_rx_cb( NULL );	// default : NULL, sets a callback function for RX interrupt
	}
	else if (rx_char == 's' || rx_char == 'S')
	{
		mac_set_rx_cb( rf_rx_callback );	// default : NULL, sets a callback function for RX interrupt
	}
	else if (rx_char == 'd' || rx_char == 'D')
	{
		ENTER_CRITICAL();
		delay_ms(10000);
		EXIT_CRITICAL();
	}
	else
	{
		tx_power = 
(UINT8)(atoi((INT8*)(&rx_char)));
		if ((tx_power > 0) && (tx_power < 10))
		{
			led_toggle(3);
			mac_set_tx_power(5);
		}
	}
}

int main (void) 
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	uart_puts("Input my address.\n\r");
	uart_gets(txbuf, 6); // Maximum of short address is 65535 --> 5 character + '\0' character.

	// Initialize MAC
	mac_init(26, 0x0312, atoi(txbuf)); // channel:0x0B~0x1A (11~26), PAN Id , short address(source node Id) = 0x0---
	//mac_set_tx_power(6);
	//mac_set_rx_range(0, 65535);	// if DEMO_MAC_M
	mac_set_rx_cb( rf_rx_callback );	// default : NULL, sets a callback function for RX interrupt



	uart_puts("Input destination address(0~65534) or Broadcast(65535).\n\r");
	uart_gets(txbuf, 6); // Maximum of short address is 65535 --> 5 character + '\0' character.
	txinfo.dest_addr = atoi(txbuf); // destination node Id = 0x1---, 0xffff :broadcast. (Pan ID must be also 0xffff to broadcast.)		

   	// Initalize COMMON protocol parameters
	txinfo.payload_ptr = txbuf;
	rxinfo.payload_ptr = rxbuf;

	// Write dummy data to tx_payload.
   	for (n = 1; n < NMAC_MAX_PAYLOAD_SIZE; n++) 
	{
		((UINT8*)txinfo.payload_ptr)[n] = n;	//or txbuf[n] = n;
	}

	// UART interrupt callback fucntion registering
	uart_getc_callback(command);
	enable_uart_rx_intr();

	txinfo.payload_length 	= 4;//NMAC_MAX_PAYLOAD_SIZE-1;


	uart_printf("\nCommand : (T)x, (R)x or (1~9) to change TX power.\n");
	while(1);

	return 0;
} // main
