//===================================================================
//
// Max payload, Extream data flow Test
// thru_tx.c (@shert, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "nos.h"

NMAC_TX_INFO tx_info;
UINT8 tx_payload[NOS_MAC_MAX_PAYLOAD_SIZE];	// Nano mac max payload : 116 byte

int main (void)
{
   	UINT8 n;
	
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	tx_info.dest_addr = 0x5678; // destination node id = 0x5678 (B)
	tx_info.payload_length 	= NOS_MAC_MAX_PAYLOAD_SIZE; // NMAC_MAX_PAYLOAD_SIZE(115);
	tx_info.payload_ptr = tx_payload;

	// Write dummy data to tx_payload[1]~[114].
   	for (n = 1; n < NOS_MAC_MAX_PAYLOAD_SIZE; n++) 
	{
		tx_payload[n] = n;
	}
	n = 0;

	mac_init(0x1a, 0x2420, 0x1234);	// channel=26, PAN id = 0x2420, source node id = 0x1234 (A)
	//mac_set_rx_range(0x0000, 0xffff); // default (from mac_init)
	//mac_rx_on();		// default : on (from mac_init)
						// ack packet can be received even if rf has been turned off.
	//nmac_set_rx_cb(void (*func)(void)); // default : NULL. RX interrupt callback function
	
   	while (TRUE) 
   	{
		tx_payload[0]++;
		mac_tx(&tx_info);
	}
    	return 0;
} // main
