//===================================================================
// File		: nmac_getc.c
// Author	: haekim@etri.re.kr
// Date		: 2007.02.07
// Description : "SPLMAC_RXQ_LEN(4)" test. Rx queue length is 4 (Round Queue)
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

//INT8 txbuf[NMAC_MAX_PAYLOAD_SIZE]; // 115
INT8 txbuf[117]; // 115
//INT8 rxbuf[NMAC_MAX_PAYLOAD_SIZE]; // 115
INT8 rxbuf[117]; // 115
NMAC_TX_INFO txinfo;
NMAC_RX_INFO rxinfo;
UINT8 n;

void read_frame(void)
{
	
	if ( mac_rx(&rxinfo) )		// Get a packet from the queue;
	{
		led_toggle(3);		
		uart_printf("RX : %u\n",((UINT8*)(rxinfo.payload_ptr))[0] );
		//uart_printf("RX : %u\n",rx_payload[0]);	
		//mac_tx(&txinfo);
	}
 }


void command(UINT8 rx_char)
{
	if (rx_char == 'r' || rx_char == 'R')
	{
   		if ( mac_rx(&rxinfo) )
		{
			uart_puts("\n\rRX : ");
			uart_putu( ((UINT8*)rxinfo.payload_ptr)[0]);	// print out only the first byte of 115byte payload.
		}
		else
		{
			uart_puts("\n\rRX queue is empty");
		}
	}
	else if (rx_char == 't' || rx_char == 'T')
	{
		txbuf[0] = n;	// write the packet number to tx_payload[0]
		if (mac_tx(&txinfo))
		{
			uart_puts("\n\r\t\tTX : ");
			uart_putu(n);
		}
		else
		{
			uart_puts("\n\r\t\t\t\tTX failed: ");
			uart_putu(n);
		}
		n++;
	}	
	else if (rx_char == '1')
	{
		led_toggle(1);
		mac_set_tx_power(3);		
	}
	else if (rx_char == '2') 
	{
		led_toggle(2);
		mac_set_tx_power(4);		
	}
	else if (rx_char == '3')
	{
		led_toggle(3);
		mac_set_tx_power(5);
	}
}


//----------------- Dummy thread ------------------
void task1(void *args)
{
	while (TRUE) 
	{
		delay_ms(200);
	}
}


//----------------- Dummy thread ------------------
void task2(void *args)
{
	while (TRUE)
   	{
		delay_ms(200);
	}
}


//----------------- Dummy thread ------------------
void task3(void *args)
{
    while (TRUE)
    {
		delay_ms(200);
    }
}

int main (void) 
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	uart_puts("Input my address.\n\r");
	uart_gets(txbuf, 6); // Maximum of short address is 65535 --> 5 character + '\0' character.

	// Initialize MAC
	mac_init(12, 0x0312, atoi(txbuf)); // channel:0x0B~0x1A (11~26), PAN Id , short address(source node Id) = 0x0---
	//mac_set_rx_range(0, 65535);
	mac_set_tx_power(6);
	
	uart_puts("Input destination address(0~65534) or Broadcast(65535).\n\r");
	uart_gets(txbuf, 6); // Maximum of short address is 65535 --> 5 character + '\0' character.
	txinfo.dest_addr = atoi(txbuf); // destination node Id = 0x1---, 0xffff :broadcast. (Pan ID must be also 0xffff to broadcast.)		



   	// Initalize COMMON protocol parameters
	txinfo.payload_ptr = txbuf;
	txinfo.payload_length 	= 4;//NMAC_MAX_PAYLOAD_SIZE;
	rxinfo.payload_ptr = rxbuf;


	// Write dummy data to tx_payload[1]~[114].
    	for (n = 1; n < NMAC_MAX_PAYLOAD_SIZE; n++) 
	{
		((UINT8*)txinfo.payload_ptr)[n] = n;
		//txbuf[n] = n;		
	}

	// UART interrupt callback fucntion registering
	uart_getc_callback(command);
	enable_uart_rx_intr();

//	mac_set_rx_cb( read_frame );	// default : NULL, sets a callback function for RX interrupt

	uart_printf("\nCommand : (T)x, (R)x or LED(1), LED(2), LED(3) toggle\n");
	thread_create(1, task1, NULL, 0, PRIORITY_NORMAL);
	thread_create(2, task2, NULL, 0, PRIORITY_NORMAL);
	thread_create(3, task3, NULL, 0, PRIORITY_NORMAL);
 	sched_start();
	while(1);

	return 0;
} // main
